/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.plan;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ThrowableConsumer;
import java.sql.SQLException;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;

public abstract class RawPlanData {
    public abstract void load(@NotNull DatabaseConnection var1, @NotNull String var2, boolean var3);

    public abstract void load(@NotNull String var1);

    public abstract String dump();

    protected static StateSaver setAutoCommit(final boolean autoCommit) {
        return new StateSaver(){
            private Boolean myAutoCommit = null;

            @Override
            public void save(DatabaseConnection conn) throws PlanRetrievalException {
                try {
                    this.myAutoCommit = conn.getAutoCommit();
                    conn.setAutoCommit(autoCommit);
                }
                catch (SQLException e) {
                    throw new PlanRetrievalException("Failed to set auto commit", (Throwable)e);
                }
            }

            @Override
            public void restore(DatabaseConnection conn) {
                try {
                    if (this.myAutoCommit != null) {
                        conn.setAutoCommit(this.myAutoCommit.booleanValue());
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        };
    }

    protected static void useStatementWithPreserved(final DatabaseConnection conn, final ResourceUser<? super ReusableSmartStatement<String>> user, StateSaver ... savers) throws PlanRetrievalException {
        RawPlanData.withPreserved(conn, (ResourceUser<? super DatabaseConnection>)new ResourceUser<DatabaseConnection>(){

            @Override
            public void use(DatabaseConnection resource) throws PlanRetrievalException, SQLException {
                try (ReusableSmartStatement statement = SmartStatements.poweredBy((DatabaseConnection)conn).simple().reuse();){
                    user.use(statement);
                }
            }
        }, savers);
    }

    @NotNull
    protected static ResultsProducer.VoidReadyProcessor<Unit> processing(@NotNull ThrowableConsumer<? super RemoteResultSet, ? extends Exception> consumer) {
        if (consumer == null) {
            RawPlanData.$$$reportNull$$$0(0);
        }
        ResultsProducer.VoidReadyProcessor voidReadyProcessor = StandardResultsProcessors.results(rs -> {
            try {
                consumer.consume(rs);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PlanRetrievalException("Failed to process plan query results", (Throwable)e);
            }
        }, () -> RawPlanData.failWithEmptyResultSetError());
        if (voidReadyProcessor == null) {
            RawPlanData.$$$reportNull$$$0(1);
        }
        return voidReadyProcessor;
    }

    protected static void failWithEmptyResultSetError() {
        throw new PlanRetrievalException("No data returned for plan query");
    }

    protected static void withPreserved(DatabaseConnection conn, ResourceUser<? super DatabaseConnection> user, StateSaver ... savers) throws PlanRetrievalException {
        int preserved = 0;
        for (StateSaver saver : savers) {
            ++preserved;
            saver.save(conn);
        }
        try {
            user.use((DatabaseConnection)conn);
        }
        catch (SQLException ignore) {
            throw new ProcessCanceledException();
        }
        finally {
            for (int i2 = preserved - 1; i2 >= 0; --i2) {
                try {
                    savers[i2].restore(conn);
                    continue;
                }
                catch (Exception e) {
                    AbstractPlanModelBuilder.LOG.warn((Throwable)e);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/plan/RawPlanData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/plan/RawPlanData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "processing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processing";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface StateSaver {
        public void save(DatabaseConnection var1) throws PlanRetrievalException;

        public void restore(DatabaseConnection var1);
    }

    protected static interface ResourceUser<T> {
        public void use(T var1) throws PlanRetrievalException, SQLException;
    }
}

