/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.SuppressUserStackTrace;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.util.JdbcUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDatabaseErrorHandler
implements DatabaseErrorHandler {
    protected final Logger LOG = Logger.getInstance(this.getClass());

    @NotNull
    public String getErrorMessage(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause, @Nullable Consumer<? super DatabaseErrorHandler.Fix> fixes) {
        if (original == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(0);
        }
        if (cause == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(1);
        }
        StringBuilder sb = new StringBuilder();
        String causeMsg = JdbcUtil.getMessage((Throwable)cause);
        String origMsg = JdbcUtil.getMessage((Throwable)original);
        if (original != cause && original instanceof SQLException && !origMsg.equals(causeMsg)) {
            BaseDatabaseErrorHandler.appendGenericMessage(original, sb);
        }
        if (cause instanceof UnsupportedOperationException) {
            sb.append(causeMsg);
        } else if (cause instanceof SQLException) {
            SQLException next;
            if (StringUtil.indexOf((CharSequence)sb, (CharSequence)causeMsg) == -1) {
                sb.append(JdbcUtil.getMessagePrefix((Throwable)cause)).append(causeMsg);
            }
            if ((next = (SQLException)ObjectUtils.doIfCast((Object)cause, SQLException.class, ex -> ex.getNextException())) != null && next != cause) {
                sb.append("\n").append(this.getErrorMessage(dataSource, next, ExceptionUtil.getRootCause((Throwable)next), fixes));
            }
        } else if (cause instanceof RemoteException) {
            sb.append(cause.toString());
        } else if (cause instanceof EOFException && original instanceof RemoteException) {
            sb.append(dataSource).append(": process exited");
        } else if (cause instanceof IOException) {
            sb.append(cause.toString());
        } else if (cause instanceof SuppressUserStackTrace || cause instanceof ExecutionException) {
            sb.append(causeMsg);
        } else if (cause instanceof JdbcEngine.UnsafeUpdateRolledBackException) {
            sb.append(cause.getMessage());
        } else if (cause instanceof OutOfMemoryError) {
            sb.append(DatabaseBundle.message((String)"error.message.remote.oomerror", (Object[])new Object[]{dataSource == null ? null : dataSource.getName()}));
        } else if (original instanceof NoClassDefFoundError) {
            sb.append(DatabaseBundle.message((String)"missing.driver.class", (Object[])new Object[]{original.getMessage()}));
            this.LOG.warn(cause);
        } else {
            sb.append(causeMsg);
            this.LOG.warn(original);
        }
        String string = sb.toString();
        if (string == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public Boolean mayRequestPassword(@NotNull SQLException e) {
        if (e == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(3);
        }
        return null;
    }

    protected static void appendGenericMessage(@NotNull Throwable e, @NotNull StringBuilder sb) {
        String message;
        if (e == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(4);
        }
        if (sb == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(5);
        }
        if (StringUtil.indexOf((CharSequence)sb, (CharSequence)(message = JdbcUtil.getMessage((Throwable)e))) == -1) {
            sb.append(JdbcUtil.getMessagePrefix((Throwable)e)).append(message).append("\n");
        }
    }

    @NotNull
    protected static String getGenericMessage(@NotNull Throwable t) {
        if (t == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(6);
        }
        StringBuilder sb = new StringBuilder();
        BaseDatabaseErrorHandler.appendGenericMessage(t, sb);
        String string = sb.toString();
        if (string == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(7);
        }
        return string;
    }

    protected static int getOffsetFromMessageImpl(@NotNull @RegExp String pattern, int groupNear, int groupLine, int groupColumn, @NotNull String message, @NotNull String queryText, @Nullable StringFinder finder) {
        Matcher matcher;
        if (pattern == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(8);
        }
        if (message == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(9);
        }
        if (queryText == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(10);
        }
        if ((matcher = Pattern.compile(pattern).matcher(message)).find()) {
            return BaseDatabaseErrorHandler.getOffsetFromMessageImpl(queryText, groupNear > 0 ? matcher.group(groupNear) : null, groupLine > 0 ? matcher.group(groupLine) : null, groupColumn > 0 ? matcher.group(groupColumn) : null, finder);
        }
        return -1;
    }

    protected static int getOffsetFromMessageImpl(@NotNull String queryText, @Nullable String near, @Nullable String strLine, @Nullable String strColumn, @Nullable StringFinder finder) {
        int offset;
        int column2;
        if (queryText == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(11);
        }
        int line = strLine == null ? -1 : StringUtil.parseInt((String)strLine, (int)-1);
        int n = column2 = strColumn == null ? -1 : StringUtil.parseInt((String)strColumn, (int)-1);
        int n2 = strLine == null || line == -1 ? (column2 < 0 ? -1 : column2 - 1) : (offset = StringUtil.lineColToOffset((CharSequence)queryText, (int)(line - 1), (int)(column2 < 0 ? 0 : column2 - 1)));
        if (line > -1 && column2 > -1) {
            return offset;
        }
        if (near == null || finder == null) {
            return offset;
        }
        int refined = finder.find(queryText, near, offset);
        return refined == -1 ? offset : refined;
    }

    protected static StringFinder byTokenFinder(@NotNull Language language, @NotNull Project project, int cropping) {
        if (language == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(12);
        }
        if (project == null) {
            BaseDatabaseErrorHandler.$$$reportNull$$$0(13);
        }
        return (query, piece, startOffset) -> {
            boolean croppedMode;
            ParserDefinition parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.findSingle((Object)language);
            if (parser == null) {
                return StringUtil.indexOfIgnoreCase((String)query, (String)piece, (int)startOffset);
            }
            Lexer lexer = parser.createLexer(project);
            lexer.start((CharSequence)query);
            boolean bl = croppedMode = piece.length() > cropping;
            while (lexer.getTokenType() != null) {
                if (lexer.getTokenStart() >= startOffset) {
                    boolean matched;
                    boolean bl2 = matched = croppedMode ? StringUtil.startsWithIgnoreCase((String)lexer.getTokenText(), (String)piece) : lexer.getTokenText().equalsIgnoreCase(piece);
                    if (matched) {
                        return lexer.getTokenStart();
                    }
                }
                lexer.advance();
            }
            return StringUtil.indexOfIgnoreCase((String)query, (String)piece, (int)startOffset);
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/BaseDatabaseErrorHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/BaseDatabaseErrorHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mayRequestPassword";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendGenericMessage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGenericMessage";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetFromMessageImpl";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "byTokenFinder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    protected static interface StringFinder {
        public int find(@NotNull String var1, @NotNull String var2, int var3);
    }
}

