/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSSplitIfAndIntention
extends JSIntention {
    @NonNls
    private static final String IF_STATEMENT_PREFIX = "if (";
    @NonNls
    private static final String INNER_IF_STATEMENT_PREFIX = ") {\n if (";
    @NonNls
    private static final String ELSE_KEYWORD = "else ";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new SplitIfAndPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        int elseLength;
        PsiElement jsElement;
        if (element == null) {
            JSSplitIfAndIntention.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = jsElement = element.getParent() instanceof JSIfStatement ? element.getParent() : element;
        assert (jsElement != null);
        assert (jsElement instanceof JSIfStatement);
        JSIfStatement ifStatement = (JSIfStatement)jsElement;
        assert (ifStatement.getCondition() instanceof JSBinaryExpression);
        JSBinaryExpression condition = (JSBinaryExpression)ifStatement.getCondition();
        String lhsText = JSSplitIfAndIntention.getConditionText(condition.getLOperand(), condition);
        String rhsText = JSSplitIfAndIntention.getConditionText(condition.getROperand(), condition);
        JSStatement thenBranch = ifStatement.getThen();
        JSStatement elseBranch = ifStatement.getElse();
        String thenText = thenBranch.getText();
        String elseText = elseBranch == null ? null : elseBranch.getText();
        int n = elseLength = elseBranch == null ? 0 : elseText.length();
        assert (condition.getOperationSign().equals(JSTokenTypes.ANDAND));
        StringBuilder statement = new StringBuilder(ifStatement.getTextLength() + elseLength + 30);
        statement.append(IF_STATEMENT_PREFIX).append(lhsText).append(INNER_IF_STATEMENT_PREFIX).append(rhsText).append(')');
        if (!(thenBranch instanceof JSBlockStatement)) {
            statement.append(' ');
        }
        statement.append(thenText);
        if (elseBranch != null) {
            statement.append(ELSE_KEYWORD);
            if (!(elseBranch instanceof JSBlockStatement)) {
                statement.append(' ');
            }
            statement.append(elseText);
        }
        statement.append('}');
        if (elseBranch != null) {
            statement.append(ELSE_KEYWORD).append(elseText);
        }
        JSRefactoringUtil.replaceStatementAndReformat((JSStatement)ifStatement, (String)statement.toString());
    }

    static String getConditionText(JSExpression operand, JSBinaryExpression condition) {
        StringBuilder innerText = new StringBuilder(JSParenthesesUtils.stripParentheses((JSExpression)operand).getText());
        PsiElement sibling = (operand == condition.getLOperand() ? condition : operand).getPrevSibling();
        while (sibling instanceof PsiWhiteSpace || sibling instanceof PsiComment) {
            innerText.insert(0, sibling.getText());
            sibling = sibling.getPrevSibling();
        }
        sibling = (operand == condition.getROperand() ? condition : operand).getNextSibling();
        while (sibling instanceof PsiWhiteSpace || sibling instanceof PsiComment) {
            innerText.append(sibling.getText());
            sibling = sibling.getNextSibling();
        }
        return StringUtil.trim((String)innerText.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitIfAndIntention", "processIntention"));
    }

    private static class SplitIfAndPredicate
    implements JSElementPredicate {
        private SplitIfAndPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            JSIfStatement ifStatement;
            JSExpression condition;
            PsiElement parent;
            if (element == null) {
                SplitIfAndPredicate.$$$reportNull$$$0(0);
            }
            if (!((parent = element.getParent()) instanceof JSIfStatement)) {
                if (element instanceof JSIfStatement) {
                    parent = element;
                } else {
                    return false;
                }
            }
            if ((condition = (ifStatement = (JSIfStatement)parent).getCondition()) == null || PsiUtilCore.hasErrorElementChild((PsiElement)condition)) {
                return false;
            }
            return condition instanceof JSBinaryExpression && ((JSBinaryExpression)condition).getOperationSign() == JSTokenTypes.ANDAND;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSSplitIfAndIntention$SplitIfAndPredicate", "satisfiedBy"));
        }
    }
}

