/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.bool;

import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.ComparisonUtils;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.bool.ComparisonPredicate;
import org.jetbrains.annotations.NotNull;

public class JSFlipComparisonIntention
extends JSMutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        JSBinaryExpression exp = (JSBinaryExpression)element;
        String operatorText = null;
        String flippedOperatorText = null;
        if (exp != null) {
            operatorText = ComparisonUtils.getOperatorText((IElementType)exp.getOperationSign());
            flippedOperatorText = ComparisonUtils.getFlippedOperatorText((IElementType)exp.getOperationSign());
        }
        if (exp == null) {
            return this.getSuffixedDisplayName("unknown", new Object[0]);
        }
        if (operatorText.equals(flippedOperatorText)) {
            return this.getSuffixedDisplayName("equals", operatorText);
        }
        return this.getSuffixedDisplayName("not-equals", operatorText, flippedOperatorText);
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new ComparisonPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSFlipComparisonIntention.$$$reportNull$$$0(0);
        }
        JSBinaryExpression exp = (JSBinaryExpression)element;
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        IElementType sign = exp.getOperationSign();
        assert (rhs != null);
        String expString = rhs.getText() + ComparisonUtils.getFlippedOperatorText((IElementType)sign) + lhs.getText();
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)expString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/bool/JSFlipComparisonIntention", "processIntention"));
    }
}

