/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.nbformat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebookSchema;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebookSchemaFactory;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MINOR_VERSION_FIELD_NAME", "", "VERSION_FIELD_NAME", "createSchema", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebookSchema;", "content", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "version", "", "minorVersion", "intellij.python.jupyter"})
public final class JupyterNotebookSchemaFactory {
    private static final Logger LOG;
    private static final String VERSION_FIELD_NAME = "nbformat";
    private static final String MINOR_VERSION_FIELD_NAME = "nbformat_minor";
    public static final JupyterNotebookSchemaFactory INSTANCE;

    @NotNull
    public final JupyterNotebookSchema createSchema(@NotNull ObjectNode content2) {
        Integer minorVersion;
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        JsonNode jsonNode = content2.get(VERSION_FIELD_NAME);
        Integer version = jsonNode != null ? Integer.valueOf(jsonNode.asInt()) : null;
        JsonNode jsonNode2 = content2.get(MINOR_VERSION_FIELD_NAME);
        Integer n = minorVersion = jsonNode2 != null ? Integer.valueOf(jsonNode2.asInt()) : null;
        if (version != null && minorVersion != null) {
            return this.createSchema(version, minorVersion);
        }
        LOG.error("Can't retrieve notebook version from the content: " + content2);
        return this.createSchema(4, 4);
    }

    private final JupyterNotebookSchema createSchema(int version, int minorVersion) {
        if (version < 4) {
            LOG.warn("Undefined notebook version encountered: " + version);
        }
        if (version == 4) {
            int n = minorVersion;
            return 0 <= n && 4 >= n ? new JupyterNotebookSchema(version, minorVersion, true) : new JupyterNotebookSchema(version, minorVersion, false, 4, null);
        }
        return new JupyterNotebookSchema(version, minorVersion, false, 4, null);
    }

    private JupyterNotebookSchemaFactory() {
    }

    static {
        JupyterNotebookSchemaFactory jupyterNotebookSchemaFactory;
        INSTANCE = jupyterNotebookSchemaFactory = new JupyterNotebookSchemaFactory();
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger;
    }
}

