/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.nbformat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterMetadataAware;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0005H\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0006\u0010\u0010\u001a\u00020\u0005J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterMetadataAwareBase;", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterMetadataAware;", "Lcom/fasterxml/jackson/databind/JsonNode;", "()V", "content", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getContent", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "cleanup", "", "createMetadata", "getKeys", "", "", "getMetadata", "key", "getOrCreateMetadata", "removeMetadata", "setMetadata", "value", "intellij.python.jupyter"})
public abstract class JupyterMetadataAwareBase
implements JupyterMetadataAware<JsonNode> {
    @NotNull
    protected abstract ObjectNode getContent();

    @NotNull
    public final ObjectNode getOrCreateMetadata() {
        ObjectNode objectNode = this.getMetadata();
        if (objectNode == null) {
            objectNode = this.createMetadata();
        }
        return objectNode;
    }

    @Nullable
    public ObjectNode getMetadata() {
        JsonNode jsonNode = this.getContent().get("metadata");
        Object object = jsonNode != null ? jsonNode.get("pycharm") : null;
        if (!(object instanceof ObjectNode)) {
            object = null;
        }
        return (ObjectNode)object;
    }

    @NotNull
    public ObjectNode createMetadata() {
        if (this.getContent().has("metadata") && this.getContent().get("metadata") instanceof ObjectNode) {
            JsonNode jsonNode = this.getContent().get("metadata");
            if (jsonNode == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            }
            ((ObjectNode)jsonNode).putObject("pycharm");
        } else {
            this.getContent().putObject("metadata").putObject("pycharm");
        }
        JsonNode jsonNode = this.getContent().get("metadata").get("pycharm");
        if (jsonNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        }
        return (ObjectNode)jsonNode;
    }

    @Override
    @NotNull
    public Set<String> getKeys() {
        Object object = this.getMetadata();
        if (object == null || (object = object.fieldNames()) == null || (object = SequencesKt.asSequence((Iterator)object)) == null || (object = SequencesKt.toSet((Sequence)object)) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @Override
    @Nullable
    public JsonNode getMetadata(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        ObjectNode objectNode = this.getMetadata();
        return objectNode != null ? objectNode.get(key) : null;
    }

    @Override
    public void removeMetadata(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        ObjectNode objectNode = this.getMetadata();
        if (objectNode != null) {
            objectNode.remove(key);
        }
        this.cleanup();
    }

    private final void cleanup() {
        JsonNode jsonNode = this.getContent().get("metadata").get("pycharm");
        if (jsonNode == null) {
            return;
        }
        JsonNode pycharmMetadata = jsonNode;
        if (pycharmMetadata.isEmpty()) {
            JsonNode jsonNode2 = this.getContent().get("metadata");
            if (jsonNode2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            }
            ((ObjectNode)jsonNode2).remove("pycharm");
        }
    }

    @Override
    public void setMetadata(@NotNull String key, @NotNull JsonNode value2) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        this.getOrCreateMetadata().set(key, value2);
    }
}

