/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.debugger;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.ServerSocket;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.JupyterBundle;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterEditorActionsKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterCellExecutionManager;
import org.jetbrains.plugins.notebooks.jupyter.connections.ui.JupyterErrorReporter;
import org.jetbrains.plugins.notebooks.jupyter.debugger.DebugConnectionNotifier;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugCellIdManager;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugProcessHandler;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterPositionConverter;
import org.jetbrains.plugins.notebooks.jupyter.debugger.OutputConsumer;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell;
import org.jetbrains.plugins.notebooks.jupyter.variables.inline.JupyterInlineCallback;
import org.jetbrains.plugins.notebooks.jupyter.variables.inline.JupyterInlinePainterKt;
import org.jetbrains.plugins.notebooks.jupyter.variables.inline.JupyterInlineService;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u001d\u001a\u00020\u0012H\u0014J\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u000bJ\u0006\u0010 \u001a\u00020\u0012J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\b\u0010#\u001a\u00020$H\u0016J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0012\u0010'\u001a\u00020\u00122\b\u0010(\u001a\u0004\u0018\u00010)H\u0016R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterDebugProcess;", "Lcom/jetbrains/python/debugger/PyDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "serverSocket", "Ljava/net/ServerSocket;", "executionConsole", "Lcom/intellij/execution/ui/ExecutionConsole;", "jupyterDebugProcessHandler", "Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterDebugProcessHandler;", "jupyterCell", "Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;", "connectionNotifier", "Lorg/jetbrains/plugins/notebooks/jupyter/debugger/DebugConnectionNotifier;", "output", "Lorg/jetbrains/plugins/notebooks/jupyter/debugger/OutputConsumer;", "afterCellExecuted", "Lkotlin/Function0;", "", "(Lcom/intellij/xdebugger/XDebugSession;Ljava/net/ServerSocket;Lcom/intellij/execution/ui/ExecutionConsole;Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterDebugProcessHandler;Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;Lorg/jetbrains/plugins/notebooks/jupyter/debugger/DebugConnectionNotifier;Lorg/jetbrains/plugins/notebooks/jupyter/debugger/OutputConsumer;Lkotlin/jvm/functions/Function0;)V", "inlineCallback", "Lorg/jetbrains/plugins/notebooks/jupyter/variables/inline/JupyterInlineCallback;", "latestExecutedCell", "getLatestExecutedCell", "()Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;", "setLatestExecutedCell", "(Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;)V", "myLocalPort", "", "afterConnect", "connect", "cell", "executeAfterCell", "getCurrentScopeOwner", "Lcom/jetbrains/python/codeInsight/controlflow/ScopeOwner;", "isSimplifiedView", "", "loadFrame", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "showWarning", "warningId", "", "Companion", "intellij.python.jupyter"})
public final class JupyterDebugProcess
extends PyDebugProcess {
    @NotNull
    private JupyterCell latestExecutedCell;
    private JupyterInlineCallback inlineCallback;
    private final int myLocalPort;
    private final JupyterCell jupyterCell;
    private final DebugConnectionNotifier connectionNotifier;
    private final OutputConsumer output;
    private final Function0<Unit> afterCellExecuted;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String PYDEV_COMMAND_PREFIX = "# pydev_util_command\n";
    public static final Companion Companion;

    @NotNull
    public final JupyterCell getLatestExecutedCell() {
        return this.latestExecutedCell;
    }

    public final void setLatestExecutedCell(@NotNull JupyterCell jupyterCell) {
        Intrinsics.checkParameterIsNotNull((Object)jupyterCell, (String)"<set-?>");
        this.latestExecutedCell = jupyterCell;
    }

    public final void connect(@NotNull JupyterCell cell) {
        Intrinsics.checkParameterIsNotNull((Object)cell, (String)"cell");
        int portToConnect = this.myLocalPort;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        JupyterCellExecutionManager.executeCode$default(JupyterCellExecutionManager.Companion.getInstance(project), JupyterDebugProcess.Companion.createPydevConnectionCommand(portToConnect), cell, false, false, (Function1)new Function1<Exception, Unit>(this){
            final /* synthetic */ JupyterDebugProcess this$0;

            public final void invoke(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                ProcessHandler processHandler2 = JupyterDebugProcess.access$doGetProcessHandler(this.this$0);
                if (processHandler2 != null) {
                    processHandler2.destroyProcess();
                }
                JupyterErrorReporter.Companion.displayAndLogError(this.this$0.getProject(), e);
            }
            {
                this.this$0 = jupyterDebugProcess;
                super(1);
            }
        }, null, true, 44, null);
    }

    @Override
    protected void afterConnect() {
        super.afterConnect();
        if (this.isConnected()) {
            ApplicationManager.getApplication().runReadAction(new Runnable(this){
                final /* synthetic */ JupyterDebugProcess this$0;

                public final void run() {
                    DebugConnectionNotifier debugConnectionNotifier = JupyterDebugProcess.access$getConnectionNotifier$p(this.this$0);
                    Project project = this.this$0.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                    JupyterCell jupyterCell = JupyterDebugProcess.access$getJupyterCell$p(this.this$0);
                    XDebugSession xDebugSession = this.this$0.getSession();
                    Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
                    debugConnectionNotifier.executeAfterConnection(project, jupyterCell, xDebugSession, JupyterDebugProcess.access$getOutput$p(this.this$0));
                }
                {
                    this.this$0 = jupyterDebugProcess;
                }
            });
        }
    }

    private final ScopeOwner getCurrentScopeOwner() {
        return (ScopeOwner)ReadAction.compute((ThrowableComputable)new ThrowableComputable<T, E>(this){
            final /* synthetic */ JupyterDebugProcess this$0;

            @Nullable
            public final ScopeOwner compute() {
                XSourcePosition xSourcePosition = JupyterDebugProcess.access$getCurrentFrameSourcePosition(this.this$0);
                if (xSourcePosition != null) {
                    PsiFile psiFile;
                    XSourcePosition xSourcePosition2 = xSourcePosition;
                    boolean bl = false;
                    boolean bl2 = false;
                    XSourcePosition position = xSourcePosition2;
                    boolean bl3 = false;
                    Project project = this.this$0.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                    XSourcePosition xSourcePosition3 = position;
                    Intrinsics.checkExpressionValueIsNotNull((Object)xSourcePosition3, (String)"position");
                    VirtualFile virtualFile2 = xSourcePosition3.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"position.file");
                    PsiFile psiFile2 = psiFile = JupyterInlinePainterKt.getJupyterPythonPsiFile(project, virtualFile2);
                    PsiElement currentElement = psiFile2 != null ? psiFile2.findElementAt(position.getOffset()) : null;
                    return ScopeUtil.getScopeOwner(currentElement);
                }
                return null;
            }
            {
                this.this$0 = jupyterDebugProcess;
            }
        });
    }

    @Override
    @Nullable
    public XValueChildrenList loadFrame() {
        XValueChildrenList frameVariables;
        block2: {
            XValueChildrenList xValueChildrenList = frameVariables = super.loadFrame();
            if (xValueChildrenList == null) break block2;
            XValueChildrenList xValueChildrenList2 = xValueChildrenList;
            boolean bl = false;
            boolean bl2 = false;
            XValueChildrenList it = xValueChildrenList2;
            boolean bl3 = false;
            ScopeOwner scopeOwner = this.getCurrentScopeOwner();
            if (scopeOwner != null) {
                ScopeOwner scopeOwner2 = scopeOwner;
                boolean bl4 = false;
                boolean bl5 = false;
                ScopeOwner scopeOwner3 = scopeOwner2;
                boolean bl6 = false;
                JupyterInlineCallback jupyterInlineCallback = this.inlineCallback;
                if (jupyterInlineCallback != null) {
                    jupyterInlineCallback.frameChanged(it, scopeOwner3);
                }
            }
        }
        return frameVariables;
    }

    public final void executeAfterCell() {
        this.afterCellExecuted.invoke();
    }

    @Override
    public boolean isSimplifiedView() {
        PyDebuggerSettings pyDebuggerSettings = PyDebuggerSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyDebuggerSettings), (String)"PyDebuggerSettings.getInstance()");
        return pyDebuggerSettings.isSimplifiedView();
    }

    @Override
    public void showWarning(@Nullable String warningId) {
        super.showWarning(warningId);
        if (Intrinsics.areEqual((Object)warningId, (Object)"jupyter")) {
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            JupyterDebugProcess.Companion.showCellEditedBetweenSessions(project);
        }
    }

    public JupyterDebugProcess(@NotNull XDebugSession session, @NotNull ServerSocket serverSocket, @NotNull ExecutionConsole executionConsole, @NotNull JupyterDebugProcessHandler jupyterDebugProcessHandler, @NotNull JupyterCell jupyterCell, @NotNull DebugConnectionNotifier connectionNotifier, @Nullable OutputConsumer output, @NotNull Function0<Unit> afterCellExecuted) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)serverSocket, (String)"serverSocket");
        Intrinsics.checkParameterIsNotNull((Object)executionConsole, (String)"executionConsole");
        Intrinsics.checkParameterIsNotNull((Object)((Object)jupyterDebugProcessHandler), (String)"jupyterDebugProcessHandler");
        Intrinsics.checkParameterIsNotNull((Object)jupyterCell, (String)"jupyterCell");
        Intrinsics.checkParameterIsNotNull((Object)connectionNotifier, (String)"connectionNotifier");
        Intrinsics.checkParameterIsNotNull(afterCellExecuted, (String)"afterCellExecuted");
        super(session, serverSocket, executionConsole, jupyterDebugProcessHandler, false);
        this.jupyterCell = jupyterCell;
        this.connectionNotifier = connectionNotifier;
        this.output = output;
        this.afterCellExecuted = afterCellExecuted;
        this.latestExecutedCell = this.jupyterCell;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.myPositionConverter = new JupyterPositionConverter(project);
        NotebookVirtualFile notebookVirtualFile = JupyterEditorActionsKt.getVirtualFile(this.jupyterCell);
        if (notebookVirtualFile != null) {
            NotebookVirtualFile notebookVirtualFile2 = notebookVirtualFile;
            boolean bl = false;
            boolean bl2 = false;
            NotebookVirtualFile file2 = notebookVirtualFile2;
            boolean bl3 = false;
            Project project2 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            this.inlineCallback = JupyterInlineService.Companion.getInstance(project2).getInlineCallback(file2);
        }
        this.myLocalPort = serverSocket.getLocalPort();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger;
    }

    public static final /* synthetic */ ProcessHandler access$doGetProcessHandler(JupyterDebugProcess $this) {
        return $this.doGetProcessHandler();
    }

    public static final /* synthetic */ DebugConnectionNotifier access$getConnectionNotifier$p(JupyterDebugProcess $this) {
        return $this.connectionNotifier;
    }

    public static final /* synthetic */ JupyterCell access$getJupyterCell$p(JupyterDebugProcess $this) {
        return $this.jupyterCell;
    }

    public static final /* synthetic */ OutputConsumer access$getOutput$p(JupyterDebugProcess $this) {
        return $this.output;
    }

    public static final /* synthetic */ XSourcePosition access$getCurrentFrameSourcePosition(JupyterDebugProcess $this) {
        return $this.getCurrentFrameSourcePosition();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\u000e\u001a\u00020\tJ\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\rJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterDebugProcess$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "PYDEV_COMMAND_PREFIX", "", "createHelpersCommand", "createPydevConnectionCommand", "portToConnect", "", "disableTracingCommand", "enableTracingCommand", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;", "setLatestCellIdCommand", "cellId", "showCellEditedBetweenSessions", "", "showCellEditedDuringSession", "validCellIdsCommand", "intellij.python.jupyter"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private final void showCellEditedBetweenSessions(Project project) {
            PyDebugProcess.NOTIFICATION_GROUP.createNotification(JupyterBundle.message("Jupyter.debugger.cell.changed.warning", new Object[0]), NotificationType.WARNING).notify(project);
        }

        public final void showCellEditedDuringSession(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            PyDebugProcess.NOTIFICATION_GROUP.createNotification(JupyterBundle.message("Jupyter.debugger.cell.changed.error", new Object[0]), NotificationType.ERROR).notify(project);
        }

        private final String createPydevConnectionCommand(int portToConnect) {
            StringBuilder command = new StringBuilder();
            command.append(this.createHelpersCommand());
            if (this.getLOG().isDebugEnabled()) {
                command.append("import os\n");
                command.append("os.environ['PYCHARM_DEBUG'] = 'True'\n");
            }
            command.append(StringsKt.trimMargin$default((String)("\n        |import pydev_jupyter_utils\n        |pydev_jupyter_utils.attach_to_debugger(" + portToConnect + ")\n        |"), null, (int)1, null));
            String string = command.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"command.toString()");
            return string;
        }

        @NotNull
        public final String createHelpersCommand() {
            StringBuilder command = new StringBuilder();
            File file2 = PythonHelpersLocator.getHelpersRoot();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"PythonHelpersLocator.getHelpersRoot()");
            String string = StringUtil.escapeCharCharacters((String)((Object)Paths.get(file2.getPath(), "pydev")).toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.escapeCharCha\u2026ath, \"pydev\").toString())");
            String helpersPath = string;
            File file3 = PythonHelpersLocator.getHelpersProRoot();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"PythonHelpersLocator.getHelpersProRoot()");
            String string2 = StringUtil.escapeCharCharacters((String)((Object)Paths.get(file3.getPath(), "jupyter_debug")).toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.escapeCharCha\u2026pyter_debug\").toString())");
            String helpersProPath = string2;
            command.append(JupyterDebugProcess.PYDEV_COMMAND_PREFIX);
            command.append(StringsKt.trimMargin$default((String)("\n        |import sys\n        |if '" + helpersPath + "' not in sys.path:\n        |    sys.path.append('" + helpersPath + "')\n        |    sys.path.append('" + helpersProPath + "')\n        |"), null, (int)1, null));
            String string3 = command.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"command.toString()");
            return string3;
        }

        @NotNull
        public final String setLatestCellIdCommand(int cellId) {
            StringBuilder command = new StringBuilder();
            command.append(JupyterDebugProcess.PYDEV_COMMAND_PREFIX);
            command.append(StringsKt.trimMargin$default((String)("\n        |import pydev_jupyter_utils\n        |pydev_jupyter_utils.set_latest_cell_id('" + cellId + "')\n        |"), null, (int)1, null));
            String string = command.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"command.toString()");
            return string;
        }

        @NotNull
        public final String enableTracingCommand(@NotNull Project project, @NotNull NotebookVirtualFile notebookFile) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)((Object)notebookFile), (String)"notebookFile");
            StringBuilder command = new StringBuilder();
            command.append(JupyterDebugProcess.PYDEV_COMMAND_PREFIX);
            command.append("import pydev_jupyter_utils\npydev_jupyter_utils.enable_tracing()\n");
            command.append(StringsKt.trimMargin$default((String)("\n        |pydev_jupyter_utils.remove_invalid_ids(" + this.validCellIdsCommand(project, notebookFile) + ")\n        |"), null, (int)1, null));
            String string = command.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"command.toString()");
            return string;
        }

        private final String validCellIdsCommand(Project project, NotebookVirtualFile notebookFile) {
            List<Integer> validCellIds = JupyterDebugCellIdManager.Companion.getInstance(project).getValidCellIds(notebookFile);
            StringBuilder validIdsList = new StringBuilder();
            validIdsList.append("[");
            Iterable $this$forEach$iv = validCellIds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                validIdsList.append("" + '\'' + it + "', ");
            }
            validIdsList.append("]");
            String string = validIdsList.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"validIdsList.toString()");
            return string;
        }

        @NotNull
        public final String disableTracingCommand() {
            StringBuilder command = new StringBuilder();
            command.append(JupyterDebugProcess.PYDEV_COMMAND_PREFIX);
            command.append("import pydev_jupyter_utils\npydev_jupyter_utils.disable_tracing()\n");
            String string = command.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"command.toString()");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

