/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sqlalchemy.uml;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.SmartList;
import com.jetbrains.ERUmlElementManager;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchemyUmlElementManager
extends ERUmlElementManager {
    @Override
    @Nullable
    protected Module getModule(DataContext context) {
        PyPackageManager packageManager;
        List<PyPackage> packages;
        Module module = (Module)LangDataKeys.MODULE.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project != null && AppEngineUtil.getAppEngineModule(project) != null) {
            return null;
        }
        Sdk sdk = PythonSdkUtil.findPythonSdk(module);
        if (sdk != null && (packages = (packageManager = PyPackageManager.getInstance(sdk)).getPackages()) != null && PyPsiPackageUtil.findPackage(packages, "SQLAlchemy") != null) {
            return module;
        }
        return null;
    }

    @Override
    protected List<Map.Entry<String, String>> getElements(PyClass aClass) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<PyTargetExpression> classAttributes = aClass.getClassAttributes();
        for (PyTargetExpression expression : classAttributes) {
            PyStringLiteralExpression name;
            String fieldName = expression.getName();
            PyExpression callee = expression.findAssignedValue();
            QualifiedName calleeName = expression.getCalleeName();
            if (!(callee instanceof PyCallExpression) || calleeName == null) continue;
            if (fieldName != null && "Column".equals(calleeName.getLastComponent())) {
                AlchemyUmlElementManager.addFieldFromColumn(result, fieldName, (PyCallExpression)callee);
                continue;
            }
            if ("Table".equals(calleeName.getLastComponent()) && "__table__".equals(fieldName)) {
                for (PyExpression argument : ((PyCallExpression)callee).getArguments()) {
                    PyStringLiteralExpression columnArgument;
                    if (!(argument instanceof PyCallExpression) || (columnArgument = ((PyCallExpression)argument).getArgument(0, PyStringLiteralExpression.class)) == null) continue;
                    fieldName = columnArgument.getStringValue();
                    PyExpression type = ((PyCallExpression)argument).getArgument(1, PyExpression.class);
                    if (type == null) continue;
                    QualifiedName qualifiedName = QualifiedName.fromDottedString((String)type.getText());
                    String typeName = qualifiedName.getLastComponent();
                    result.put(fieldName, typeName);
                }
                continue;
            }
            if (!calleeName.matches(new String[]{"relationship"}) || (name = ((PyCallExpression)callee).getArgument(0, PyStringLiteralExpression.class)) == null) continue;
            result.put(name.getStringValue(), "relationship");
        }
        return new SmartList(result.entrySet());
    }

    private static void addFieldFromColumn(@NotNull Map<String, String> result, @NotNull String fieldName, @NotNull PyCallExpression callExpression) {
        PyExpression columnArgument;
        if (result == null) {
            AlchemyUmlElementManager.$$$reportNull$$$0(0);
        }
        if (fieldName == null) {
            AlchemyUmlElementManager.$$$reportNull$$$0(1);
        }
        if (callExpression == null) {
            AlchemyUmlElementManager.$$$reportNull$$$0(2);
        }
        if ((columnArgument = callExpression.getArgument(0, PyExpression.class)) != null) {
            QualifiedName qualifiedName = QualifiedName.fromDottedString((String)columnArgument.getText());
            String typeName = qualifiedName.getLastComponent();
            result.put(fieldName, typeName);
        }
    }

    public boolean isAcceptableAsNode(Object element) {
        return element instanceof PyClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fieldName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "callExpression";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/sqlalchemy/uml/AlchemyUmlElementManager";
        objectArray[2] = "addFieldFromColumn";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

