/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.templateLanguages;

import com.google.common.collect.Lists;
import com.intellij.DynamicBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.NonDefaultProjectConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.FileContentUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.django.lang.template.DjangoTemplateFileType;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.templateLanguages.PyTemplateFileTypesPanel;
import com.jetbrains.python.templateLanguages.PyTemplatesConfigurationsModel;
import com.jetbrains.python.templateLanguages.TemplatesService;
import com.jetbrains.python.ui.PyUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TemplateLanguageConfigurable
implements SearchableConfigurable,
NonDefaultProjectConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private JPanel myMainPanel;
    private JComboBox myTemplateLanguage;
    private JPanel myFileTypesPanel;
    private PyTemplatesConfigurationsModel myTemplatesModel;
    private final TemplatesService myTemplatesService;
    private PyTemplateFileTypesPanel myPyTemplateFileTypesPanel;

    public TemplateLanguageConfigurable(Module module) {
        this.$$$setupUI$$$();
        this.myProject = module.getProject();
        this.myTemplatesService = TemplatesService.getInstance(module);
        this.myTemplateLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplateLanguageConfigurable.this.updateEnabled();
            }
        });
    }

    private void updateEnabled() {
        boolean haveTemplates = this.myTemplateLanguage.getSelectedIndex() != 0;
        UIUtil.setEnabled((Component)this.myPyTemplateFileTypesPanel, (boolean)haveTemplates, (boolean)true);
    }

    @Nls
    public String getDisplayName() {
        return PlatformUtils.isPyCharm() ? PythonProBundle.message("python.template.languages") : PythonProBundle.message("python.template.languages.python");
    }

    public String getHelpTopic() {
        return "reference.settings.template.languages";
    }

    public JComponent createComponent() {
        List<String> templateConfigurations = TemplatesService.getAllTemplateLanguages();
        this.myTemplatesModel = new PyTemplatesConfigurationsModel(templateConfigurations, this.myTemplatesService);
        this.myTemplateLanguage.setModel(this.myTemplatesModel);
        this.myPyTemplateFileTypesPanel = new PyTemplateFileTypesPanel();
        this.myFileTypesPanel.setLayout(new BorderLayout());
        this.myFileTypesPanel.add((Component)this.myPyTemplateFileTypesPanel, "Center");
        return this.myMainPanel;
    }

    public boolean isModified() {
        if (this.myTemplateLanguage.getSelectedItem() != this.myTemplatesModel.getTemplateLanguage()) {
            return true;
        }
        return this.myPyTemplateFileTypesPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        boolean needReparse = false;
        if (this.myTemplateLanguage.getSelectedItem() != this.myTemplatesModel.getTemplateLanguage()) {
            needReparse = true;
        }
        this.myTemplatesModel.apply();
        if (this.myPyTemplateFileTypesPanel.isModified()) {
            this.myTemplatesService.setTemplateFileTypes(this.myPyTemplateFileTypesPanel.getFileTypeNames());
            needReparse = true;
        }
        if (needReparse) {
            TemplateLanguageConfigurable.reparseTemplateFiles(this.myProject);
        }
    }

    public void reset() {
        this.myTemplateLanguage.setSelectedItem(this.myTemplatesModel.getTemplateLanguage());
        this.myTemplatesModel.reset();
        this.myPyTemplateFileTypesPanel.setFileTypes(this.myTemplatesService.getTemplateFileTypes());
        this.updateEnabled();
    }

    public static void reparseTemplateFiles(@NotNull Project project) {
        if (project == null) {
            TemplateLanguageConfigurable.$$$reportNull$$$0(0);
        }
        ArrayList templatesToReparse = Lists.newArrayList();
        for (VirtualFile file2 : FileEditorManager.getInstance((Project)project).getOpenFiles()) {
            if (!DjangoTemplateFileType.getPossibleExtensions().contains(file2.getExtension())) continue;
            templatesToReparse.add(file2);
        }
        FileContentUtil.reparseFiles((Project)project, (Collection)templatesToReparse, (boolean)true);
        PyUiUtil.rehighlightOpenEditors(project);
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            TemplateLanguageConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JComboBox jComboBox;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PyTemplatesBundle", TemplateLanguageConfigurable.class).getString("python.template.language.choose"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTemplateLanguage = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myFileTypesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/templateLanguages/TemplateLanguageConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/templateLanguages/TemplateLanguageConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reparseTemplateFiles";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

