/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.templateLanguages;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.jinja2.Jinja2Language;
import com.jetbrains.mako.MakoLanguage;
import com.jetbrains.pyramid.templates.ChameleonLanguage;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.templateLanguages.PyTemplateLanguageSubstitutor;
import com.jetbrains.python.templateLanguages.PythonTemplateLanguage;
import com.jetbrains.python.templateLanguages.TemplateSettingsHolder;
import com.jetbrains.python.templateLanguages.TemplatesService;
import com.jetbrains.web2py.templates.Web2PyLanguage;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TemplatesService")
public final class PyTemplatesServiceImpl
extends TemplatesService
implements PersistentStateComponent<PyTemplatesServiceImpl> {
    public static final Set<FileType> BASIC_TEMPLATE_TYPES = ContainerUtil.set((Object[])new FileType[]{HtmlFileType.INSTANCE, XHtmlFileType.INSTANCE, XmlFileType.INSTANCE});
    private static final NotNullLazyValue<PyTemplateLanguageSubstitutor> PY_TEMPLATE_LANGUAGE_SUBSTITUTOR = NotNullLazyValue.createValue(() -> new PyTemplateLanguageSubstitutor());
    private static final List<PythonTemplateLanguage> KNOWN_TEMPLATE_LANGUAGES = Arrays.asList(new PythonTemplateLanguage[]{DjangoTemplateLanguage.INSTANCE, MakoLanguage.INSTANCE, Jinja2Language.INSTANCE, Web2PyLanguage.INSTANCE, ChameleonLanguage.INSTANCE});
    public String TEMPLATE_CONFIGURATION = "None";
    public boolean TEMPLATES_IN_JAVASCRIPT = false;
    public List<String> TEMPLATE_FOLDERS = new ArrayList<String>();
    private List<String> myTemplateFileTypes = new ArrayList<String>();
    private final List<VirtualFile> myTemplateFolders = new ArrayList<VirtualFile>();
    private final List<Runnable> myLanguageSelectedListeners = new ArrayList<Runnable>();

    @NotNull
    public static List<FileType> getTemplateFileTypes(@NotNull Module module) {
        if (module == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(0);
        }
        List<String> types = PyTemplatesServiceImpl.getInstance(module).getTemplateFileTypes();
        ArrayList<FileType> fileTypes = new ArrayList<FileType>();
        for (String type : types) {
            FileType fileType = FileTypeManager.getInstance().findFileTypeByName(type);
            if (fileType == null) continue;
            fileTypes.add(fileType);
        }
        if (fileTypes.isEmpty()) {
            fileTypes.addAll(BASIC_TEMPLATE_TYPES);
        }
        ArrayList<FileType> arrayList = fileTypes;
        if (arrayList == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    static void sortTypes(FileType[] types) {
        Arrays.sort(types, (o1, o2) -> o1.getDescription().compareToIgnoreCase(o2.getDescription()));
    }

    private static void addLanguageSubstitutorByTypeName(String typeName) {
        Language language = PyTemplatesServiceImpl.getLanguageByFileType(typeName);
        if (language != null) {
            LanguageSubstitutors.getInstance().addExplicitExtension(language, PY_TEMPLATE_LANGUAGE_SUBSTITUTOR.getValue());
        }
    }

    private static Language getLanguageByFileType(@NotNull String fileTypeName) {
        FileType[] types;
        if (fileTypeName == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(2);
        }
        for (FileType fileType : types = FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
            if (!fileTypeName.equals(fileType.getName()) || !(fileType instanceof LanguageFileType)) continue;
            return ((LanguageFileType)fileType).getLanguage();
        }
        return null;
    }

    private static void removeLanguageSubstitutorByTypeName(String typeName) {
        Language language = PyTemplatesServiceImpl.getLanguageByFileType(typeName);
        if (language != null) {
            LanguageSubstitutors.getInstance().removeExplicitExtension(language, PY_TEMPLATE_LANGUAGE_SUBSTITUTOR.getValue());
        }
    }

    private void locateTemplateFolders() {
        this.myTemplateFolders.clear();
        for (String path : this.TEMPLATE_FOLDERS) {
            VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(path);
            if (virtualFile2 == null) continue;
            this.myTemplateFolders.add(virtualFile2);
        }
    }

    public PyTemplatesServiceImpl getState() {
        return this;
    }

    public void loadState(@NotNull PyTemplatesServiceImpl state2) {
        if (state2 == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(3);
        }
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
        if (state2.TEMPLATES_IN_JAVASCRIPT) {
            List<String> types = this.getTemplateFileTypes();
            types.add("JavaScript");
            this.setTemplateFileTypes(types);
            this.TEMPLATES_IN_JAVASCRIPT = false;
        }
        this.locateTemplateFolders();
    }

    @Override
    public List<String> getTemplateFileTypes() {
        return this.myTemplateFileTypes;
    }

    @Override
    public void setTemplateFileTypes(@NotNull List<String> fileTypes) {
        if (fileTypes == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(4);
        }
        THashSet oldTypes = new THashSet(this.myTemplateFileTypes);
        THashSet newTypes = new THashSet(fileTypes);
        for (String type : this.myTemplateFileTypes) {
            if (newTypes.contains(type)) continue;
            PyTemplatesServiceImpl.removeLanguageSubstitutorByTypeName(type);
        }
        for (String type : fileTypes) {
            if (oldTypes.contains(type)) continue;
            PyTemplatesServiceImpl.addLanguageSubstitutorByTypeName(type);
        }
        this.myTemplateFileTypes = fileTypes;
    }

    @Override
    public void generateTemplates(@NotNull TemplateSettingsHolder settings, @NotNull VirtualFile baseDir) {
        if (settings == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(5);
        }
        if (baseDir == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(6);
        }
        String templateLanguage = settings.getTemplateLanguage();
        String templatesFolderPath = settings.getTemplatesFolder();
        this.setTemplateLanguage(templateLanguage == null ? "None" : templateLanguage);
        if (!StringUtil.isEmptyOrSpaces((String)templatesFolderPath)) {
            try {
                templatesFolderPath = baseDir.getPath() + File.separator + templatesFolderPath;
                VfsUtil.createDirectories((String)templatesFolderPath);
                this.setTemplateFolderPaths(templatesFolderPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void installTemplateEngine(@NotNull TemplateSettingsHolder settings, @NotNull Sdk sdk, @NotNull Project project, @NotNull String prefix) {
        if (settings == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(7);
        }
        if (sdk == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(8);
        }
        if (project == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(9);
        }
        if (prefix == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(10);
        }
        String templateToInstall = settings.getTemplateLanguage();
        boolean needInstallTemplate = false;
        List<PyPackage> packages = PyPackageUtil.refreshAndGetPackagesModally(sdk);
        if (templateToInstall != null) {
            needInstallTemplate = PyPsiPackageUtil.findPackage(packages, templateToInstall) == null;
        }
        String templateBinding = null;
        if (!StringUtil.isEmptyOrSpaces((String)prefix) && templateToInstall != null) {
            templateBinding = templateToInstall.equals("Jinja2") && "pyramid_" != prefix ? prefix + "jinja" : prefix + StringUtil.toLowerCase((String)templateToInstall);
        }
        boolean needInstallBinding = false;
        if (templateBinding != null) {
            needInstallBinding = PyPsiPackageUtil.findPackage(packages, templateBinding) == null;
        }
        PyPackageManager packageManager = PyPackageManager.getInstance(sdk);
        if (needInstallBinding && TemplatesService.ALL_TEMPLATE_BINDINGS.contains(templateBinding)) {
            PyTemplatesServiceImpl.installPackage(packageManager, project, templateBinding);
        }
        if (needInstallTemplate) {
            PyTemplatesServiceImpl.installPackage(packageManager, project, templateToInstall);
        }
    }

    private static void installPackage(final PyPackageManager packageManager, Project project, final String packageToInstall) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, PythonProBundle.message("python.template.installing.progress", packageToInstall), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText(PythonProBundle.message("python.template.installing.title", packageToInstall));
                try {
                    packageManager.install(packageToInstall);
                    packageManager.refresh();
                }
                catch (ExecutionException e) {
                    ApplicationManager.getApplication().invokeLater(() -> PackagesNotificationPanel.showError((String)("Install " + packageToInstall + " failed"), (PackageManagementService.ErrorDescription)PackageManagementService.ErrorDescription.fromMessage((String)e.toString())));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/templateLanguages/PyTemplatesServiceImpl$1", "run"));
            }
        });
    }

    @Override
    @Transient
    @NotNull
    public List<VirtualFile> getTemplateFolders() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (VirtualFile templateFolder : this.myTemplateFolders) {
            if (!templateFolder.isValid()) continue;
            result.add(templateFolder);
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Override
    @Transient
    public void setTemplateFolders(VirtualFile ... roots) {
        this.myTemplateFolders.clear();
        Collections.addAll(this.myTemplateFolders, roots);
        this.TEMPLATE_FOLDERS.clear();
        for (VirtualFile root : roots) {
            this.TEMPLATE_FOLDERS.add(root.getPath());
        }
    }

    @Override
    public void addLanguageSelectedListener(Runnable listener2) {
        this.myLanguageSelectedListeners.add(listener2);
    }

    @Override
    public void removeLanguageSelectedListener(Runnable listener2) {
        this.myLanguageSelectedListeners.remove(listener2);
    }

    @Override
    public void setTemplateFolderPaths(String ... paths) {
        this.TEMPLATE_FOLDERS.clear();
        Collections.addAll(this.TEMPLATE_FOLDERS, paths);
        this.locateTemplateFolders();
    }

    @Override
    @Transient
    public String getTemplateLanguage() {
        return this.TEMPLATE_CONFIGURATION;
    }

    @Override
    @Transient
    public void setTemplateLanguage(String templateLanguage) {
        this.TEMPLATE_CONFIGURATION = templateLanguage;
        for (Runnable listener2 : this.myLanguageSelectedListeners) {
            listener2.run();
        }
    }

    @Override
    public List<PythonTemplateLanguage> getKnownTemplateLanguages() {
        return Collections.unmodifiableList(KNOWN_TEMPLATE_LANGUAGES);
    }

    @Override
    @Transient
    @Nullable
    public Language getSelectedTemplateLanguage() {
        String languageFromConfig = this.TEMPLATE_CONFIGURATION;
        for (PythonTemplateLanguage templateLanguage : KNOWN_TEMPLATE_LANGUAGES) {
            if (!templateLanguage.getTemplateLanguageName().equals(languageFromConfig)) continue;
            return templateLanguage;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/templateLanguages/PyTemplatesServiceImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/templateLanguages/PyTemplatesServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateFileTypes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateFileTypes";
                break;
            }
            case 1: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageByFileType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTemplateFileTypes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateTemplates";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "installTemplateEngine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

