/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.scientific.figures;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.docking.DragSession;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabLabel;
import com.jetbrains.python.scientific.PyScientificBundle;
import com.jetbrains.python.scientific.figures.DockableContentFigureFactory;
import com.jetbrains.python.scientific.figures.Figure;
import com.jetbrains.python.scientific.figures.WithDockableContent;
import com.jetbrains.python.scientific.figures.base.FigureUtil;
import com.jetbrains.python.scientific.figures.image.ImageDockableContentFigureFactory;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class PyPlotToolWindow
extends JPanel
implements DumbAware,
Disposable {
    private static final Logger LOG = Logger.getInstance(PyPlotToolWindow.class);
    private static final int PREVIEW_SIZE = 80;
    private final JBTabs myTabs;
    private final Project myProject;
    private final Map<TabInfo, Object> mySearchKeyByTabInfo = new HashMap<TabInfo, Object>();
    private final List<DockableContentFigureFactory> myDockableContentFigureFactories = new ArrayList<DockableContentFigureFactory>();
    private int myPlotIndex = 0;
    private MyDockContainer myDockContainer;

    public static PyPlotToolWindow getInstance(Project project) {
        return (PyPlotToolWindow)ServiceManager.getService((Project)project, PyPlotToolWindow.class);
    }

    public PyPlotToolWindow(Project project) {
        super(new BorderLayout());
        this.myProject = project;
        this.myTabs = new MyTabs(this.myProject);
        this.myTabs.getPresentation().setTabsPosition(JBTabsPosition.right);
        this.myTabs.setPopupGroup((ActionGroup)new DefaultActionGroup(new AnAction[]{new SaveAsFileAction(), new CloseAllPlotsAction()}), "unknown", true);
        this.myTabs.getPresentation().setTabDraggingEnabled(true);
        this.myTabs.addListener(new TabsListener(){

            public void tabRemoved(@NotNull TabInfo tabInfo) {
                if (tabInfo == null) {
                    1.$$$reportNull$$$0(0);
                }
                PyPlotToolWindow.this.disposeTab(tabInfo);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabInfo", "com/jetbrains/python/scientific/figures/PyPlotToolWindow$1", "tabRemoved"));
            }
        });
        this.myTabs.getPresentation().setEmptyText(PyScientificBundle.message("plots.empty.window", new Object[0]));
        this.add(this.myTabs.getComponent());
        this.addDockableContentFigureFactory(new ImageDockableContentFigureFactory(this.myProject));
    }

    public void init(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            PyPlotToolWindow.$$$reportNull$$$0(0);
        }
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content2 = contentFactory.createContent((JComponent)this, PyScientificBundle.message("plots", new Object[0]), false);
        content2.setCloseable(false);
        toolWindow.getContentManager().addContent(content2);
        if (this.myDockContainer == null) {
            this.myDockContainer = new MyDockContainer(toolWindow);
            DockManager.getInstance((Project)this.myProject).register((DockContainer)this.myDockContainer, toolWindow.getDisposable());
        }
    }

    public void addDockableContentFigureFactory(DockableContentFigureFactory factory) {
        this.myDockableContentFigureFactories.add(factory);
    }

    public int getLastPlotIndex() {
        return this.myPlotIndex;
    }

    public void addFigure(@NotNull Figure figure) {
        if (figure == null) {
            PyPlotToolWindow.$$$reportNull$$$0(1);
        }
        TabInfo info = figure.getTabInfo();
        Object searchKey = figure.hasSearchKey() ? figure.getSearchKey() : null;
        this.mySearchKeyByTabInfo.put(info, searchKey);
        info.setTabLabelActions((ActionGroup)new DefaultActionGroup(new AnAction[]{new ClosePlotAction(info)}), "unknown");
        if (figure instanceof WithDockableContent) {
            info.setDragOutDelegate((TabInfo.DragOutDelegate)new MyDragOutDelegate((WithDockableContent)((Object)figure)));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            TabInfo toUpdate = null;
            if (searchKey != null) {
                toUpdate = this.findTabInfo(searchKey);
            }
            if (toUpdate == null) {
                this.myTabs.addTab(info);
                ++this.myPlotIndex;
            } else {
                int tabIndex = this.myTabs.getIndexOf(toUpdate);
                this.myTabs.removeTab(toUpdate);
                this.myTabs.addTab(info, tabIndex);
            }
            this.myTabs.select(info, false);
        });
    }

    private TabInfo findTabInfo(Object searchKey) {
        for (Map.Entry<TabInfo, Object> entry : this.mySearchKeyByTabInfo.entrySet()) {
            Object tabInfoSearchKey = entry.getValue();
            if (tabInfoSearchKey == null || !tabInfoSearchKey.equals(searchKey)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void dispose() {
        HashSet<TabInfo> infos = new HashSet<TabInfo>(this.mySearchKeyByTabInfo.keySet());
        for (TabInfo info : infos) {
            this.disposeTab(info);
        }
    }

    private void disposeTab(TabInfo tabInfo) {
        this.mySearchKeyByTabInfo.remove(tabInfo);
        JComponent component = tabInfo.getComponent();
        if (component instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)component));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "figure";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/scientific/figures/PyPlotToolWindow";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addFigure";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyDockContainer
    implements DockContainer {
        private final ToolWindow myToolWindow;

        private MyDockContainer(ToolWindow toolWindow) {
            this.myToolWindow = toolWindow;
        }

        @NotNull
        public RelativeRectangle getAcceptArea() {
            return new RelativeRectangle(this.myToolWindow.getComponent());
        }

        @NotNull
        public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content2, RelativePoint point) {
            if (content2 == null) {
                MyDockContainer.$$$reportNull$$$0(0);
            }
            DockContainer.ContentResponse contentResponse = this.findApplicableFigureFactory(content2) != null ? DockContainer.ContentResponse.ACCEPT_MOVE : DockContainer.ContentResponse.DENY;
            if (contentResponse == null) {
                MyDockContainer.$$$reportNull$$$0(1);
            }
            return contentResponse;
        }

        public JComponent getContainerComponent() {
            return this.myToolWindow.getComponent();
        }

        public void add(@NotNull DockableContent content2, RelativePoint dropTarget) {
            if (content2 == null) {
                MyDockContainer.$$$reportNull$$$0(2);
            }
            Figure figure = this.findApplicableFigureFactory(content2).createFigure(content2);
            PyPlotToolWindow.this.addFigure(figure);
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isDisposeWhenEmpty() {
            return false;
        }

        private DockableContentFigureFactory findApplicableFigureFactory(DockableContent content2) {
            return PyPlotToolWindow.this.myDockableContentFigureFactories.stream().filter(factory -> factory.isApplicable(content2)).findFirst().orElse(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/scientific/figures/PyPlotToolWindow$MyDockContainer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/scientific/figures/PyPlotToolWindow$MyDockContainer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getContentResponse";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyDragOutDelegate
    implements TabInfo.DragOutDelegate {
        private final WithDockableContent myContentFactory;
        private DragSession mySession;

        private MyDragOutDelegate(WithDockableContent contentFactory) {
            this.myContentFactory = contentFactory;
        }

        public void dragOutStarted(@NotNull MouseEvent mouseEvent, @NotNull TabInfo info) {
            if (mouseEvent == null) {
                MyDragOutDelegate.$$$reportNull$$$0(0);
            }
            if (info == null) {
                MyDragOutDelegate.$$$reportNull$$$0(1);
            }
            TabInfo previousSelection = info.getPreviousSelection();
            info.setHidden(true);
            if (previousSelection != null) {
                PyPlotToolWindow.this.myTabs.select(previousSelection, true);
            }
            this.mySession = this.getDockManager().createDragSession(mouseEvent, this.myContentFactory.createDockableContent());
        }

        private DockManager getDockManager() {
            return DockManager.getInstance((Project)PyPlotToolWindow.this.myProject);
        }

        public void processDragOut(@NotNull MouseEvent event2, @NotNull TabInfo source2) {
            if (event2 == null) {
                MyDragOutDelegate.$$$reportNull$$$0(2);
            }
            if (source2 == null) {
                MyDragOutDelegate.$$$reportNull$$$0(3);
            }
            this.mySession.process(event2);
        }

        public void dragOutFinished(@NotNull MouseEvent event2, TabInfo source2) {
            if (event2 == null) {
                MyDragOutDelegate.$$$reportNull$$$0(4);
            }
            PyPlotToolWindow.this.myTabs.removeTab(source2);
            this.mySession.process(event2);
            this.mySession = null;
        }

        public void dragOutCancelled(TabInfo source2) {
            source2.setHidden(false);
            if (this.mySession != null) {
                this.mySession.cancel();
            }
            this.mySession = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mouseEvent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/scientific/figures/PyPlotToolWindow$MyDragOutDelegate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dragOutStarted";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDragOut";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dragOutFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SaveAsFileAction
    extends AnAction {
        private SaveAsFileAction() {
            super(PyScientificBundle.message("plots.save.as.file", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SaveAsFileAction.$$$reportNull$$$0(0);
            }
            TabInfo info = PyPlotToolWindow.this.myTabs.getSelectedInfo();
            Project project = e.getProject();
            if (info != null && project != null) {
                byte[] bytes = FigureUtil.componentToByteArray(info.getComponent());
                if (bytes == null) {
                    LOG.error("Can't obtain image content");
                    return;
                }
                FileSaverDescriptor descriptor2 = new FileSaverDescriptor(PyScientificBundle.message("plots.select.file.to.save.plot", new Object[0]), "", new String[]{"png"});
                FileSaverDialog chooser = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, project);
                VirtualFileWrapper fileWrapper = chooser.save(project.getBaseDir(), "myplot");
                try {
                    if (fileWrapper != null) {
                        File ioFile = fileWrapper.getFile();
                        Files.write(Paths.get(ioFile.getPath(), new String[0]), bytes, new OpenOption[0]);
                    }
                }
                catch (IOException e1) {
                    LOG.warn("Failed to save image " + e1.getMessage());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/scientific/figures/PyPlotToolWindow$SaveAsFileAction", "actionPerformed"));
        }
    }

    private class CloseAllPlotsAction
    extends AnAction {
        private CloseAllPlotsAction() {
            super(PyScientificBundle.message("plots.close.all.plots.action", new Object[0]), PyScientificBundle.message("plots.close.all.plot.description", new Object[0]), null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAllPlotsAction.$$$reportNull$$$0(0);
            }
            PyPlotToolWindow.this.myTabs.removeAllTabs();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/scientific/figures/PyPlotToolWindow$CloseAllPlotsAction", "actionPerformed"));
        }
    }

    private class ClosePlotAction
    extends AnAction {
        private final TabInfo myInfo;

        private ClosePlotAction(TabInfo info) {
            super(PyScientificBundle.message("plots.close.plot", new Object[0]), PyScientificBundle.message("plots.close.selected.plot", new Object[0]), AllIcons.Actions.Close);
            this.myInfo = info;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClosePlotAction.$$$reportNull$$$0(0);
            }
            PyPlotToolWindow.this.myTabs.removeTab(this.myInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/scientific/figures/PyPlotToolWindow$ClosePlotAction", "actionPerformed"));
        }
    }

    private static class MyTabLabel
    extends TabLabel {
        private MyTabLabel(JBTabsImpl tabs, TabInfo info) {
            super(tabs, info);
            JComponent label = this.getLabelComponent();
            if (label instanceof SimpleColoredComponent) {
                ((SimpleColoredComponent)label).setIconOnTheRight(true);
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(JBUIScale.scale((int)100), JBUIScale.scale((int)80));
        }
    }

    private static class MyTabs
    extends JBEditorTabs {
        private MyTabs(Project project) {
            super(project, null, (Disposable)project);
        }

        protected TabLabel createTabLabel(TabInfo info) {
            return new MyTabLabel((JBTabsImpl)this, info);
        }
    }
}

