/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.scientific.cells;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.actionSystem.ActionPromoter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PyCellUtil;
import com.jetbrains.python.actions.PyExecuteSelectionAction;
import com.jetbrains.python.console.PyCodeExecutor;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.scientific.PySciProjectComponent;
import com.jetbrains.python.scientific.PyScientificBundle;
import com.jetbrains.python.scientific.cells.PyCellExecutionHandler;
import com.jetbrains.python.scientific.cells.PyCellExecutionManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExecuteCellAction
extends DumbAwareAction {
    private static final String EXECUTE_CELL_IN_CONSOLE = "Execute Cell in Console";
    private final PyCellExecutionManager executionManager = new PyCellExecutionManager();

    public PyExecuteCellAction() {
        super(EXECUTE_CELL_IN_CONSOLE, null, null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement element;
        String cellText2;
        if (e == null) {
            PyExecuteCellAction.$$$reportNull$$$0(0);
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (editor2 != null && file2 != null && this.showConsoleAndExecuteCode(e, cellText2 = PyExecuteCellAction.getCellText(element = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)editor2.getCaretModel().getOffset(), PsiElement.class, (boolean)false)))) {
            PyExecuteCellAction.moveCaretToNextCell(editor2, element);
        }
    }

    private static void moveCaretToNextCell(Editor editor2, PsiElement element) {
        PsiElement el = PyCellUtil.findNextCell(element);
        if (el != null) {
            editor2.getCaretModel().moveToOffset(el.getTextOffset());
        }
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
    }

    private boolean showConsoleAndExecuteCode(@NotNull AnActionEvent e, @NotNull String cellText2) {
        if (e == null) {
            PyExecuteCellAction.$$$reportNull$$$0(1);
        }
        if (cellText2 == null) {
            PyExecuteCellAction.$$$reportNull$$$0(2);
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        Project project = e.getProject();
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        Ref res = Ref.create((Object)false);
        PyExecuteSelectionAction.findCodeExecutor(e.getDataContext(), (Consumer<PyCodeExecutor>)((Consumer)codeExecutor -> res.set((Object)this.executeInConsole((PyCodeExecutor)codeExecutor, cellText2, editor2))), editor2, project, false);
        return (Boolean)res.get();
    }

    @NotNull
    private static String getCellText(@Nullable PsiElement element) {
        if (element != null) {
            element = PyCellUtil.getCellStart(element);
            String string = PyCellUtil.getCodeInCell(element);
            if (string == null) {
                PyExecuteCellAction.$$$reportNull$$$0(3);
            }
            return string;
        }
        return "";
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PyExecuteCellAction.$$$reportNull$$$0(4);
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Presentation presentation = e.getPresentation();
        boolean enabled = false;
        if (file2 != null && PyExecuteSelectionAction.isPython(editor2) && PySciProjectComponent.getInstance(file2.getProject()).shouldUseSciView()) {
            PsiElement element = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)editor2.getCaretModel().getOffset(), PsiElement.class, (boolean)false);
            String text2 = PyExecuteCellAction.getCellText(element);
            enabled = !StringUtil.isEmpty((String)text2);
        }
        presentation.setEnabledAndVisible(enabled);
    }

    private boolean executeInConsole(@NotNull PyCodeExecutor codeExecutor, final @NotNull String cellText2, Editor editor2) {
        if (codeExecutor == null) {
            PyExecuteCellAction.$$$reportNull$$$0(5);
        }
        if (cellText2 == null) {
            PyExecuteCellAction.$$$reportNull$$$0(6);
        }
        if (codeExecutor instanceof PythonConsoleView) {
            final PythonConsoleView consoleView = (PythonConsoleView)codeExecutor;
            final PyCellExecutionHandler executionHandler = this.executionManager.getHandler(consoleView);
            if (executionHandler == null) {
                UIUtil.invokeLaterIfNeeded(() -> HintManager.getInstance().showErrorHint(editor2, "Previous execution is still running", (short)1));
                return false;
            }
            Task.Backgroundable task2 = new Task.Backgroundable(consoleView.getProject(), PyScientificBundle.message("execute.code.in.console", new Object[0]), true){

                public void run(@NotNull ProgressIndicator progressIndicator) {
                    if (progressIndicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!progressIndicator.isCanceled()) {
                        executionHandler.execute(cellText2, progressIndicator);
                    }
                    PyExecuteCellAction.this.executionManager.freeConsole(consoleView);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/jetbrains/python/scientific/cells/PyExecuteCellAction$1", "run"));
                }
            };
            ProgressManager.getInstance().run((Task)task2);
            return true;
        }
        throw new RuntimeException("Wrong code executor type! This shouldn't happen in production.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/scientific/cells/PyExecuteCellAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/scientific/cells/PyExecuteCellAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showConsoleAndExecuteCode";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeInConsole";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CellActionPromoter
    implements ActionPromoter {
        public List<AnAction> promote(List<AnAction> actions, DataContext context) {
            for (AnAction a : actions) {
                if (!(a instanceof PyExecuteCellAction)) continue;
                return Lists.newArrayList((Object[])new AnAction[]{a});
            }
            return Lists.newArrayList();
        }
    }
}

