/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.vcsUtil.VcsUtil;
import com.jetbrains.extensions.ModuleExtKt;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.remote.PyProjectSynchronizerProvider;
import com.jetbrains.python.remote.PySyncDirection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public final class NewFilesProcessor {
    private NewFilesProcessor() {
    }

    @NotNull
    public static String processNewFiles(@NotNull Module module, @NotNull String files) {
        if (module == null) {
            NewFilesProcessor.$$$reportNull$$$0(0);
        }
        if (files == null) {
            NewFilesProcessor.$$$reportNull$$$0(1);
        }
        Sdk sdk = ModuleExtKt.getSdk(module);
        assert (sdk != null) : String.format("Sdk can't be null on module %s", module);
        PyProjectSynchronizer synchronizer = PyProjectSynchronizerProvider.getSynchronizer(sdk);
        String[] fileNames = ArrayUtilRt.toStringArray((Collection)StringUtil.split((String)files, (String)","));
        if (fileNames.length == 0) {
            return "";
        }
        if (synchronizer != null) {
            synchronizer.syncProject(module, PySyncDirection.REMOTE_TO_LOCAL, success -> {
                if (!success.booleanValue()) {
                    return;
                }
                String[] localFileNames = (String[])Arrays.stream(fileNames).map(remoteName -> synchronizer.mapFilePath(module.getProject(), PySyncDirection.REMOTE_TO_LOCAL, (String)remoteName)).filter(localFileName -> localFileName != null).toArray(String[]::new);
                NewFilesProcessor.addToVcsIfNeeded(module, localFileNames);
            }, fileNames);
        } else {
            NewFilesProcessor.addToVcsIfNeeded(module, fileNames);
        }
        String string = String.format("Following files were affected \n %s", StringUtil.join((String[])fileNames, (String)"\n"));
        if (string == null) {
            NewFilesProcessor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static void addToVcsIfNeeded(@NotNull Module module, String ... localFileNames) {
        if (module == null) {
            NewFilesProcessor.$$$reportNull$$$0(3);
        }
        if (localFileNames == null) {
            NewFilesProcessor.$$$reportNull$$$0(4);
        }
        LocalFileSystem fs = LocalFileSystem.getInstance();
        fs.refresh(false);
        Project project = module.getProject();
        Arrays.stream(localFileNames).map(o -> fs.findFileByPath(o)).filter(o -> o != null).forEach(file2 -> {
            AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (VirtualFile)file2);
            if (vcs == null) {
                return;
            }
            CheckinEnvironment environment = vcs.getCheckinEnvironment();
            if (environment != null) {
                environment.scheduleUnversionedFilesForAddition(Collections.singletonList(file2));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/NewFilesProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFileNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/NewFilesProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processNewFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processNewFiles";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addToVcsIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

