/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.Maps;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.python.PythonCodeStyleService;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.module.PyModuleService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonLanguageLevelPusher
implements FilePropertyPusher<LanguageLevel> {
    public static final Key<LanguageLevel> PYTHON_LANGUAGE_LEVEL = Key.create((String)"PYTHON_LANGUAGE_LEVEL");
    public static final Map<LanguageLevel, LanguageLevel> COMPATIBLE_LEVELS;
    private final Map<Module, Sdk> myModuleSdks = ContainerUtil.createWeakMap();
    private static final FileAttribute PERSISTENCE;

    private static void addCompatiblePair(Map<LanguageLevel, LanguageLevel> levels, LanguageLevel l1, LanguageLevel l2) {
        levels.put(l1, l2);
        levels.put(l2, l1);
    }

    public static void pushLanguageLevel(@NotNull Project project) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(0);
        }
        PushedFilePropertiesUpdater.getInstance((Project)project).pushAll(new FilePropertyPusher[]{new PythonLanguageLevelPusher()});
    }

    public void initExtra(@NotNull Project project, @NotNull MessageBus bus) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(1);
        }
        if (bus == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(2);
        }
        Map<Module, Sdk> moduleSdks = PythonLanguageLevelPusher.getPythonModuleSdks(project);
        Set distinctSdks = (Set)StreamEx.ofValues(moduleSdks).nonNull().collect(Collectors.toCollection(LinkedHashSet::new));
        this.myModuleSdks.putAll(moduleSdks);
        PyUtil.invalidateLanguageLevelCache(project);
        this.updateSdkLanguageLevels(project, distinctSdks);
        project.putUserData(PYTHON_LANGUAGE_LEVEL, (Object)PyUtil.guessLanguageLevel(project));
    }

    @NotNull
    public Key<LanguageLevel> getFileDataKey() {
        Key<LanguageLevel> key = LanguageLevel.KEY;
        if (key == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(3);
        }
        return key;
    }

    public boolean pushDirectoriesOnly() {
        return true;
    }

    @NotNull
    public LanguageLevel getDefaultValue() {
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(4);
        }
        return languageLevel;
    }

    @Nullable
    public LanguageLevel getImmediateValue(@NotNull Project project, @Nullable VirtualFile file2) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(5);
        }
        return PythonLanguageLevelPusher.getFileLanguageLevel(project, file2);
    }

    @Nullable
    public static LanguageLevel getFileLanguageLevel(@NotNull Project project, @Nullable VirtualFile file2) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && LanguageLevel.FORCE_LANGUAGE_LEVEL != null) {
            return LanguageLevel.FORCE_LANGUAGE_LEVEL;
        }
        if (file2 == null) {
            return null;
        }
        Sdk sdk = PythonLanguageLevelPusher.getFileSdk(project, file2);
        if (sdk != null) {
            return PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk);
        }
        return PyUtil.guessLanguageLevelWithCaching(project);
    }

    @Nullable
    private static Sdk getFileSdk(@NotNull Project project, @NotNull VirtualFile file2) {
        Module module;
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(8);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)project)) != null) {
            Sdk sdk = PythonSdkUtil.findPythonSdk(module);
            if (sdk != null) {
                return sdk;
            }
            return null;
        }
        return PythonLanguageLevelPusher.findSdkForFileOutsideTheProject(project, file2);
    }

    @Nullable
    private static Sdk findSdkForFileOutsideTheProject(Project project, VirtualFile file2) {
        if (file2 != null) {
            List orderEntries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(file2);
            for (OrderEntry orderEntry : orderEntries) {
                if (!(orderEntry instanceof JdkOrderEntry)) continue;
                return ((JdkOrderEntry)orderEntry).getJdk();
            }
        }
        return null;
    }

    @NotNull
    public LanguageLevel getImmediateValue(@NotNull Module module) {
        if (module == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(9);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && LanguageLevel.FORCE_LANGUAGE_LEVEL != null) {
            LanguageLevel languageLevel = LanguageLevel.FORCE_LANGUAGE_LEVEL;
            if (languageLevel == null) {
                PythonLanguageLevelPusher.$$$reportNull$$$0(10);
            }
            return languageLevel;
        }
        Sdk sdk = PythonSdkUtil.findPythonSdk(module);
        LanguageLevel languageLevel = PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk);
        if (languageLevel == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(11);
        }
        return languageLevel;
    }

    public boolean acceptsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(12);
        }
        return false;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(13);
        }
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(14);
        }
        return true;
    }

    private static boolean areLanguageLevelsCompatible(LanguageLevel oldLevel, LanguageLevel newLevel) {
        return oldLevel != null && newLevel != null && COMPATIBLE_LEVELS.get((Object)oldLevel) == newLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull LanguageLevel level) throws IOException {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(15);
        }
        if (fileOrDir == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(16);
        }
        if (level == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(17);
        }
        DataInputStream iStream = PERSISTENCE.readAttribute(fileOrDir);
        LanguageLevel oldLanguageLevel = null;
        if (iStream != null) {
            try {
                int oldLevelOrdinal = DataInputOutputUtil.readINT((DataInput)iStream);
                if (oldLevelOrdinal == level.ordinal()) {
                    return;
                }
                oldLanguageLevel = Arrays.stream(LanguageLevel.values()).filter(it -> it.ordinal() == oldLevelOrdinal).findFirst().orElse(null);
            }
            finally {
                iStream.close();
            }
        }
        try (DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);){
            DataInputOutputUtil.writeINT((DataOutput)oStream, (int)level.ordinal());
        }
        if (!PythonLanguageLevelPusher.areLanguageLevelsCompatible(oldLanguageLevel, level) || !ProjectFileIndex.getInstance((Project)project).isInContent(fileOrDir)) {
            PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, PythonLanguageLevelPusher::isPythonFile);
        }
        for (VirtualFile child : fileOrDir.getChildren()) {
            if (child.isDirectory() || !PythonLanguageLevelPusher.isPythonFile(child)) continue;
            PythonLanguageLevelPusher.clearSdkPathCache(child);
        }
    }

    private static boolean isPythonFile(VirtualFile child) {
        return ((Object)((Object)PythonFileType.INSTANCE)).equals(FileTypeRegistry.getInstance().getFileTypeByFileName(child.getNameSequence()));
    }

    private static void clearSdkPathCache(@NotNull VirtualFile child) {
        Project[] projects;
        if (child == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(18);
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            Sdk sdk = PythonLanguageLevelPusher.getFileSdk(project, child);
            if (sdk == null) continue;
            PythonSdkPathCache pathCache = PythonSdkPathCache.getInstance(project, sdk);
            pathCache.clearCache();
        }
    }

    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(19);
        }
        Map<Module, Sdk> moduleSdks = PythonLanguageLevelPusher.getPythonModuleSdks(project);
        Set distinctSdks = (Set)StreamEx.ofValues(moduleSdks).nonNull().collect(Collectors.toCollection(LinkedHashSet::new));
        boolean needToReparseOpenFiles = StreamEx.of(moduleSdks.entrySet()).anyMatch(entry -> {
            Module module = (Module)entry.getKey();
            Sdk newSdk = (Sdk)entry.getValue();
            Sdk oldSdk = this.myModuleSdks.get(module);
            return this.myModuleSdks.containsKey(module) && newSdk != oldSdk;
        });
        this.myModuleSdks.putAll(moduleSdks);
        PyUtil.invalidateLanguageLevelCache(project);
        this.updateSdkLanguageLevels(project, distinctSdks);
        if (needToReparseOpenFiles) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project.isDisposed()) {
                    return;
                }
                PythonCodeStyleService.getInstance().reparseOpenEditorFiles(project);
            });
        }
    }

    @NotNull
    private static Map<Module, Sdk> getPythonModuleSdks(@NotNull Project project) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(20);
        }
        LinkedHashMap<Module, Sdk> result = new LinkedHashMap<Module, Sdk>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!PythonLanguageLevelPusher.isPythonModule(module)) continue;
            result.put(module, PythonSdkUtil.findPythonSdk(module));
        }
        LinkedHashMap<Module, Sdk> linkedHashMap = result;
        if (linkedHashMap == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(21);
        }
        return linkedHashMap;
    }

    private static boolean isPythonModule(@NotNull Module module) {
        if (module == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(22);
        }
        return PyModuleService.getInstance().isPythonModule(module);
    }

    private void updateSdkLanguageLevels(final @NotNull Project project, final @NotNull Set<Sdk> sdks) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(23);
        }
        if (sdks == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(24);
        }
        if (sdks.isEmpty()) {
            return;
        }
        DumbService dumbService = DumbService.getInstance((Project)project);
        final DumbModeTask task2 = new DumbModeTask(){

            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                List tasks = (List)ReadAction.compute(() -> PythonLanguageLevelPusher.this.getRootUpdateTasks(project, sdks));
                PushedFilePropertiesUpdater.getInstance((Project)project).runConcurrentlyIfPossible(tasks);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$1", "performInDumbMode"));
            }
        };
        project.getMessageBus().connect((Disposable)task2).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event2) {
                if (event2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                DumbService.getInstance((Project)project).cancelTask(task2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$2", "rootsChanged"));
            }
        });
        dumbService.queueTask(task2);
    }

    private List<Runnable> getRootUpdateTasks(@NotNull Project project, @NotNull Set<Sdk> sdks) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(25);
        }
        if (sdks == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(26);
        }
        ArrayList<Runnable> results = new ArrayList<Runnable>();
        for (Sdk sdk : sdks) {
            LanguageLevel languageLevel = PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk);
            for (VirtualFile root : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!root.isValid() || PyTypeShed.INSTANCE.isInside(root)) continue;
                VirtualFile parent = root.getParent();
                boolean shouldSuppressSizeLimit = parent != null && parent.getName().equals("python_stubs");
                results.add(new UpdateRootTask(project, root, languageLevel, shouldSuppressSizeLimit));
            }
        }
        return results;
    }

    public static void setForcedLanguageLevel(Project project, @Nullable LanguageLevel languageLevel) {
        LanguageLevel.FORCE_LANGUAGE_LEVEL = languageLevel;
        PythonLanguageLevelPusher.pushLanguageLevel(project);
    }

    public void flushLanguageLevelCache() {
        this.myModuleSdks.clear();
    }

    static {
        EnumMap compatLevels = Maps.newEnumMap(LanguageLevel.class);
        PythonLanguageLevelPusher.addCompatiblePair(compatLevels, LanguageLevel.PYTHON26, LanguageLevel.PYTHON27);
        PythonLanguageLevelPusher.addCompatiblePair(compatLevels, LanguageLevel.PYTHON33, LanguageLevel.PYTHON34);
        COMPATIBLE_LEVELS = Maps.immutableEnumMap((Map)compatLevels);
        PERSISTENCE = new FileAttribute("python_language_level_persistence", 2, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDataKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediateValue";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonModuleSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pushLanguageLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initExtra";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 21: {
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileLanguageLevel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileSdk";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "persistAttribute";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "clearSdkPathCache";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "afterRootsChanged";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPythonModuleSdks";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isPythonModule";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "updateSdkLanguageLevels";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getRootUpdateTasks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class UpdateRootTask
    implements Runnable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final LanguageLevel myLanguageLevel;
        private final boolean myShouldSuppressSizeLimit;

        UpdateRootTask(@NotNull Project project, @NotNull VirtualFile root, LanguageLevel languageLevel, boolean shouldSuppressSizeLimit) {
            if (project == null) {
                UpdateRootTask.$$$reportNull$$$0(0);
            }
            if (root == null) {
                UpdateRootTask.$$$reportNull$$$0(1);
            }
            if (languageLevel == null) {
                UpdateRootTask.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myRoot = root;
            this.myLanguageLevel = languageLevel;
            this.myShouldSuppressSizeLimit = shouldSuppressSizeLimit;
        }

        @Override
        public void run() {
            if (this.myProject.isDisposed() || !((Boolean)ReadAction.compute(() -> this.myRoot.isValid())).booleanValue()) {
                return;
            }
            final PushedFilePropertiesUpdater propertiesUpdater = PushedFilePropertiesUpdater.getInstance((Project)this.myProject);
            VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myRoot, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return (Boolean)ReadAction.compute(() -> {
                        if (PyModuleService.getInstance().isFileIgnored(file2)) {
                            return false;
                        }
                        if (file2.isDirectory()) {
                            propertiesUpdater.findAndUpdateValue(file2, (FilePropertyPusher)PythonLanguageLevelPusher.this, (Object)UpdateRootTask.this.myLanguageLevel);
                        }
                        if (UpdateRootTask.this.myShouldSuppressSizeLimit) {
                            SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)file2);
                        }
                        return true;
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$UpdateRootTask$1", "visitFile"));
                }
            });
        }

        public String toString() {
            return "UpdateRootTask{myRoot=" + this.myRoot + ", myLanguageLevel=" + (Object)((Object)this.myLanguageLevel) + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "languageLevel";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$UpdateRootTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

