/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.python.profiler.ProfilerSessionVirtualFileImpl;
import com.jetbrains.python.profiler.ProfilerViewKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002\u00a8\u0006\u000b"}, d2={"findSources", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "profileStats", "Lcom/intellij/openapi/util/UserDataHolder;", "filename", "", "originalVirtualFile", "file", "intellij.python.profiler"})
public final class VirtualFilesKt {
    @NotNull
    public static final VirtualFile originalVirtualFile(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (file2 instanceof ProfilerSessionVirtualFileImpl && ((ProfilerSessionVirtualFileImpl)file2).getOriginalFile() != null) {
            VirtualFile virtualFile2 = ((ProfilerSessionVirtualFileImpl)file2).getOriginalFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.originalFile");
            return virtualFile2;
        }
        return file2;
    }

    @NotNull
    public static final Collection<VirtualFile> findSources(@NotNull Project project, @NotNull UserDataHolder profileStats, @NotNull String filename) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)profileStats, (String)"profileStats");
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        String filePath = ProfilerViewKt.tryRemap(filename, profileStats);
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (virtualFile2 != null) {
            return CollectionsKt.listOf((Object)virtualFile2);
        }
        boolean $i$f$runReadAction = false;
        Object object = ApplicationManager.getApplication().runReadAction(new Computable<T>(project, filename){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ String $filename$inlined;
            {
                this.$project$inlined = project;
                this.$filename$inlined = string;
            }

            public final T compute() {
                boolean bl = false;
                Collection collection = FilenameIndex.getVirtualFilesByName((Project)this.$project$inlined, (String)this.$filename$inlined, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.$project$inlined));
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"FilenameIndex.getVirtual\u2026hScope.allScope(project))");
                return (T)collection;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"runReadAction { Filename\u2026cope.allScope(project)) }");
        return (Collection)object;
    }
}

