/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRemoveAssignmentQuickFix;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyNoneFunctionAssignmentInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyNoneFunctionAssignmentInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyNoneFunctionAssignmentInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyNoneFunctionAssignmentInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private final Map<PyFunction, Boolean> myHasInheritors;

        private Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (session == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super(holder, session);
            this.myHasInheritors = new HashMap<PyFunction, Boolean>();
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            PyExpression value2 = node.getAssignedValue();
            if (value2 instanceof PyCallExpression) {
                PyType type = this.myTypeEvalContext.getType(value2);
                PyCallExpression call = (PyCallExpression)value2;
                PyExpression callee = call.getCallee();
                if (type instanceof PyNoneType && callee != null) {
                    Condition ignoredCallable = callable -> this.myTypeEvalContext.getReturnType((PyCallable)callable) != PyNoneType.INSTANCE || PythonSdkUtil.isElementInSkeletons((PsiElement)callable) || callable instanceof PyFunction && this.hasInheritors((PyFunction)callable);
                    List<PyCallable> callables = call.multiResolveCalleeFunction(this.getResolveContext());
                    if (!callables.isEmpty() && !ContainerUtil.exists(callables, (Condition)ignoredCallable)) {
                        this.registerProblem((PsiElement)node, PyBundle.message("INSP.none.function.assignment", callee.getName()), new PyRemoveAssignmentQuickFix());
                    }
                }
            }
        }

        private boolean hasInheritors(@NotNull PyFunction function) {
            Boolean cached;
            if (function == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((cached = this.myHasInheritors.get(function)) != null) {
                return cached;
            }
            boolean result = PyOverridingMethodsSearch.search(function, true).findFirst() != null;
            this.myHasInheritors.put(function, result);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyNoneFunctionAssignmentInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasInheritors";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

