/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.coverage;

import com.intellij.coverage.CoverageDataManagerImpl;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageHelper;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.remote.RemoteProcessControl;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.django.run.DjangoServerRunConfiguration;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.coverage.PyCoverageEnabledConfiguration;
import com.jetbrains.python.coverage.PyCoverageOptionsProvider;
import com.jetbrains.python.coverage.PyCoverageRunner;
import com.jetbrains.python.coverage.PyCoverageUtil;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.remote.PyCredentialsContribution;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.remote.PythonRemoteInterpreterPluginNotAvailableException;
import com.jetbrains.python.remote.PythonSshInterpreterManager;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonRunConfigurationExtension;
import com.jetbrains.python.sdk.CredentialsTypeExChecker;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonCoverageRunConfigurationExtension
extends PythonRunConfigurationExtension {
    private static final Logger LOG = Logger.getInstance((String)PythonCoverageRunConfigurationExtension.class.getName());
    private static final String ID = "PythonCoverageRunConfigurationExtension";
    public static final String RUN_COVERAGE = "PYCHARM_RUN_COVERAGE";
    private static final String BUNDLED_COVERAGE_PATH = "BUNDLED_COVERAGE_PATH";
    private static final String CREATE_TEMP_COVERAGE_FILE = "CREATE_TEMP_COVERAGE_FILE";
    private static final String COLLECTING_COVERAGE_DATA_TITLE = "Collecting Coverage Data";
    private static final String ERROR_COLLECTING_COVERAGE_DATA_TITLE = "Error Collecting Coverage Data";

    @NotNull
    public String getSerializationId() {
        return ID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void attachToProcess(final @NotNull AbstractPythonRunConfiguration configuration, final @NotNull ProcessHandler handler, RunnerSettings runnerSettings) {
        if (configuration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(1);
        }
        if (PythonSdkUtil.isRemote(configuration.getSdk()) && !new CredentialsTypeExChecker(){

            @Override
            protected boolean checkLanguageContribution(PyCredentialsContribution languageContribution) {
                return languageContribution.isSpecificCoverageAttach();
            }
        }.check(configuration.getSdk())) {
            final PythonSshInterpreterManager manager = PythonSshInterpreterManager.Factory.getInstance();
            if (manager == null) throw new PythonRemoteInterpreterPluginNotAvailableException();
            CoverageHelper.resetCoverageSuit((RunConfigurationBase)configuration);
            if (!(runnerSettings instanceof CoverageRunnerData)) return;
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event2) {
                    if (event2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    RemoteProcessControl remoteProcessHandler = (RemoteProcessControl)handler;
                    Sdk sdk = configuration.getSdk();
                    PyRemoteSdkAdditionalData data = (PyRemoteSdkAdditionalData)sdk.getSdkAdditionalData();
                    try {
                        PyRemoteSdkCredentials credentials = data.getRemoteSdkCredentials(false);
                        ((PyCoverageRunner)CoverageRunner.getInstance(PyCoverageRunner.class)).setPathMapper(remoteProcessHandler.getMappingSettings());
                        Project project = configuration.getProject();
                        PythonCoverageRunConfigurationExtension.runProcessWithProgressAsynchronously(project, PythonCoverageRunConfigurationExtension.COLLECTING_COVERAGE_DATA_TITLE, () -> {
                            try {
                                manager.copyFromRemote(project, credentials, remoteProcessHandler.getFileMappings());
                                CoverageDataManagerImpl.processGatheredCoverage((RunConfigurationBase)configuration);
                            }
                            catch (Exception e) {
                                PythonCoverageRunConfigurationExtension.showErrorDialogAndWait(e, PythonCoverageRunConfigurationExtension.ERROR_COLLECTING_COVERAGE_DATA_TITLE);
                            }
                        });
                    }
                    catch (Exception e) {
                        PythonCoverageRunConfigurationExtension.showErrorDialogAndWait(e, PythonCoverageRunConfigurationExtension.ERROR_COLLECTING_COVERAGE_DATA_TITLE);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/coverage/PythonCoverageRunConfigurationExtension$2", "processTerminated"));
                }
            });
            return;
        } else {
            CoverageHelper.attachToProcess((RunConfigurationBase)configuration, (ProcessHandler)handler, (RunnerSettings)runnerSettings);
        }
    }

    private static void runProcessWithProgressAsynchronously(final @NotNull Project project, @NotNull String title, final @NotNull Runnable runnable) {
        if (project == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(2);
        }
        if (title == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(3);
        }
        if (runnable == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(4);
        }
        Task.Backgroundable task2 = new Task.Backgroundable(project, title){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                runnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/coverage/PythonCoverageRunConfigurationExtension$3", "run"));
            }
        };
        ApplicationManager.getApplication().invokeAndWait(() -> {
            BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(task2);
            indicator.setIndeterminate(false);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)indicator);
        });
    }

    private static void showErrorDialogAndWait(@NotNull Exception e, @NotNull String title) {
        if (e == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(5);
        }
        if (title == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(6);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> Messages.showErrorDialog((String)e.getMessage(), (String)title));
    }

    protected void readExternal(@NotNull AbstractPythonRunConfiguration runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(7);
        }
        if (element == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(8);
        }
        CoverageHelper.doReadExternal((RunConfigurationBase)runConfiguration, (Element)element);
    }

    protected void writeExternal(@NotNull AbstractPythonRunConfiguration runConfiguration, @NotNull Element element) {
        if (runConfiguration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(9);
        }
        if (element == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(10);
        }
        CoverageHelper.doWriteExternal((RunConfigurationBase)runConfiguration, (Element)element);
    }

    protected String getEditorTitle() {
        return CoverageEngine.getEditorTitle();
    }

    public boolean isApplicableFor(@NotNull AbstractPythonRunConfiguration configuration) {
        if (configuration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(11);
        }
        return !(configuration instanceof DjangoServerRunConfiguration);
    }

    public boolean isEnabledFor(@NotNull AbstractPythonRunConfiguration applicableConfiguration, RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(12);
        }
        return runnerSettings == null || runnerSettings instanceof CoverageRunnerData;
    }

    protected void patchCommandLine(@NotNull AbstractPythonRunConfiguration configuration, RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) throws ExecutionException {
        if (configuration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(13);
        }
        if (cmdLine == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(14);
        }
        if (runnerId == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(15);
        }
        if (!(runnerSettings instanceof CoverageRunnerData)) {
            return;
        }
        PyCoverageEnabledConfiguration covEnabledConfig = PyCoverageEnabledConfiguration.getFrom((ModuleBasedConfiguration)configuration);
        assert (covEnabledConfig != null);
        if ("PythonCover".equals(runnerId)) {
            PyCoverageUtil.addCoverageFileEnv(cmdLine, covEnabledConfig.getCoverageFilePath());
            PyCoverageUtil.addRunCoverageEnv(cmdLine);
            if (PythonCoverageRunConfigurationExtension.useBundledCoverage(configuration)) {
                PythonHelper.COVERAGEPY.addToPythonPath(cmdLine.getEnvironment());
            } else {
                cmdLine.getEnvironment().put(BUNDLED_COVERAGE_PATH, PythonHelper.COVERAGEPY.getPythonPathEntry());
                if (!PythonCoverageRunConfigurationExtension.isCoverageAvailable(configuration.getModule(), configuration.getInterpreterPath())) {
                    throw new CoverageNotImportableException(configuration.getProject(), configuration.getSdk());
                }
            }
            PyDebugRunner.disableBuiltinBreakpoint(configuration.getSdk(), cmdLine.getEnvironment());
            ParamsGroup group2 = cmdLine.getParametersList().getParamsGroup("Coverage");
            PythonHelper.COVERAGE.addToGroup(group2, cmdLine);
            group2.addParameter("run");
            if (PyCoverageOptionsProvider.getInstance(configuration.getProject()).getBranchCoverage()) {
                group2.addParameter("--branch");
            }
            group2.addParameter("--omit=\"" + PythonHelpersLocator.getHelpersRoot().getAbsolutePath() + "*\"");
            if (new CredentialsTypeExChecker(){

                @Override
                protected boolean checkLanguageContribution(PyCredentialsContribution languageContribution) {
                    return languageContribution.isSpecificCoveragePatch();
                }
            }.check(configuration.getSdk())) {
                String coverageFilePath = covEnabledConfig.getCoverageFilePath();
                PathMappingSettings mappings = PythonCoverageRunConfigurationExtension.createCoverageFileMappings(coverageFilePath);
                cmdLine.putUserData(PythonRemoteInterpreterManager.ADDITIONAL_MAPPINGS, (Object)mappings);
                PyCoverageUtil.addCoverageFileEnv(cmdLine, mappings.convertToRemote(coverageFilePath));
            } else if (PythonSdkUtil.isRemote(configuration.getSdk())) {
                cmdLine.getEnvironment().put(CREATE_TEMP_COVERAGE_FILE, "1");
            }
        }
    }

    private static PathMappingSettings createCoverageFileMappings(String coverageFilePath) {
        PathMappingSettings mappingSettings = new PathMappingSettings();
        mappingSettings.add(new PathMappingSettings.PathMapping(new File(coverageFilePath).getParent(), "/opt/.pycharm_coverage"));
        return mappingSettings;
    }

    private static void enableBundled(Project project) {
        PyCoverageOptionsProvider.getInstance(project).setUseBundledCoveragePy(true);
    }

    private static void installCoverage(Project project, Sdk sdk) {
        PyPackageManagerUI ui2 = new PyPackageManagerUI(project, sdk, new PyPackageManagerUI.Listener(){

            @Override
            public void started() {
            }

            @Override
            public void finished(List<ExecutionException> exceptions) {
            }
        });
        ui2.install(Collections.singletonList(PyRequirementsKt.pyRequirement("coverage")), Collections.emptyList());
    }

    private static boolean useBundledCoverage(AbstractPythonRunConfiguration configuration) {
        return PyCoverageOptionsProvider.getInstance(configuration.getProject()).isUseBundledCoveragePy();
    }

    public void validateConfiguration(@NotNull AbstractPythonRunConfiguration configuration, boolean isExecution) throws Exception {
        if (configuration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(16);
        }
    }

    private static boolean isCoverageAvailable(@Nullable Module module, @Nullable String sdkHome) {
        Sdk pythonSdk2 = PythonSdkUtil.findSdkByPath(sdkHome);
        if (pythonSdk2 == null || module == null) {
            return false;
        }
        PyQualifiedNameResolveContext context = PyResolveImportUtil.fromSdk(module.getProject(), pythonSdk2);
        List<PsiElement> results = PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromDottedString((String)"coverage"), context);
        return !results.isEmpty();
    }

    protected void extendCreatedConfiguration(@NotNull AbstractPythonRunConfiguration configuration, @NotNull Location location) {
        if (configuration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(17);
        }
        if (location == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(18);
        }
    }

    protected void extendTemplateConfiguration(@NotNull AbstractPythonRunConfiguration configuration) {
        PyCoverageEnabledConfiguration conf;
        if (configuration == null) {
            PythonCoverageRunConfigurationExtension.$$$reportNull$$$0(19);
        }
        LOG.assertTrue((conf = PyCoverageEnabledConfiguration.getFrom((ModuleBasedConfiguration)configuration)) != null);
        conf.setTrackTestFolders(true);
        conf.setCoverageRunner(CoverageRunner.getInstance(PyCoverageRunner.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/coverage/PythonCoverageRunConfigurationExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "attachToProcess";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorDialogAndWait";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledFor";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "patchCommandLine";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "validateConfiguration";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "extendCreatedConfiguration";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "extendTemplateConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CoverageNotImportableException
    extends ExecutionException
    implements HyperlinkListener {
        private static final String INSTALL = "INSTALL";
        private static final String ENABLE = "ENABLE";
        private final Project myProject;
        private final Sdk mySdk;

        private CoverageNotImportableException(Project project, Sdk sdk) {
            super("Coverage is not importable in this environment. " + (PyPackageUtil.packageManagementEnabled(sdk) ? "Please <a href=\"INSTALL\">install coverage.py</a>" : "Please install coverage.py") + " to selected interpreter or <a href=\"" + ENABLE + "\">enable</a> 'Use bundled coverage' in Settings | Coverage");
            this.myProject = project;
            this.mySdk = sdk;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event2) {
            if (event2.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (INSTALL.equals(event2.getDescription())) {
                    PythonCoverageRunConfigurationExtension.installCoverage(this.myProject, this.mySdk);
                } else if (ENABLE.equals(event2.getDescription())) {
                    PythonCoverageRunConfigurationExtension.enableBundled(this.myProject);
                }
            }
        }
    }
}

