/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.jetbrains.mako.MakoTokenTypes;
import com.jetbrains.mako.validation.MakoAnnotator;
import com.jetbrains.python.PythonProBundle;
import org.jetbrains.annotations.NotNull;

public class MakoCommentAnnotator
extends MakoAnnotator {
    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            MakoCommentAnnotator.$$$reportNull$$$0(0);
        }
        super.visitComment(comment);
        if (comment.getTokenType() != MakoTokenTypes.COMMENT) {
            return;
        }
        if (comment.getText().startsWith("<%doc>") && !comment.getText().endsWith("</%doc>")) {
            int start = comment.getTextOffset() + comment.getText().trim().length() - 1;
            int end = start + 1;
            this.getHolder().newAnnotation(HighlightSeverity.ERROR, PythonProBundle.message("maco.unclosed.comment")).range(new TextRange(start, end)).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/jetbrains/mako/validation/MakoCommentAnnotator", "visitComment"));
    }
}

