/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.flask.codeInsight.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.flask.codeInsight.FlaskTemplateManager;
import com.jetbrains.flask.codeInsight.WerkzeugRoutingRule;
import com.jetbrains.flask.codeInsight.references.FlaskRouteParameterReference;
import com.jetbrains.flask.codeInsight.references.FlaskViewMethodReference;
import com.jetbrains.flask.configuration.FlaskConfigurationKt;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.templateLanguages.PyTemplateFileReferenceSet;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class FlaskReferenceProvider
extends PsiReferenceProvider {
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Module module;
        if (element == null) {
            FlaskReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            FlaskReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null || !FlaskConfigurationKt.getFlaskConfiguration(module).isFlaskEnabled(true)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                FlaskReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PyStringLiteralExpression stringLiteral = (PyStringLiteralExpression)element;
        if (FlaskTemplateManager.isTemplateReference(stringLiteral)) {
            FileReference[] fileReferenceArray = new PyTemplateFileReferenceSet(stringLiteral).getAllReferences();
            if (fileReferenceArray == null) {
                FlaskReferenceProvider.$$$reportNull$$$0(3);
            }
            return fileReferenceArray;
        }
        if (FlaskTemplateManager.isFirstCallArgument(stringLiteral, "url_for", "helpers.py")) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new FlaskViewMethodReference(stringLiteral)};
            if (psiReferenceArray == null) {
                FlaskReferenceProvider.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        if (FlaskReferenceProvider.isRouteDecoratorArgument(stringLiteral)) {
            WerkzeugRoutingRule rule = WerkzeugRoutingRule.parse(stringLiteral);
            ArrayList<FlaskRouteParameterReference> refs = new ArrayList<FlaskRouteParameterReference>();
            for (WerkzeugRoutingRule.Parameter parameter : rule.parameters) {
                refs.add(new FlaskRouteParameterReference(stringLiteral, parameter));
            }
            PsiReference[] psiReferenceArray = refs.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                FlaskReferenceProvider.$$$reportNull$$$0(5);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            FlaskReferenceProvider.$$$reportNull$$$0(6);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean isRouteDecoratorArgument(PyStringLiteralExpression literal) {
        PyExpression[] arguments;
        PyDecorator decorator = (PyDecorator)PsiTreeUtil.getParentOfType((PsiElement)literal, PyDecorator.class);
        return decorator != null && FlaskViewMethodReference.isRouteDecorator(decorator) && (arguments = decorator.getArguments()).length > 0 && literal == arguments[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/flask/codeInsight/references/FlaskReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/flask/codeInsight/references/FlaskReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

