/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.testRunner;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.extensions.python.PyClassExtKt;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTestUtil {
    private DjangoTestUtil() {
    }

    public static List<PyClass> getTestCaseClassesFromFile(PyFile file2) {
        TypeEvalContext context = TypeEvalContext.userInitiated(file2.getProject(), null);
        return ContainerUtil.filter(file2.getTopLevelClasses(), o -> PyClassExtKt.inherits(o, context, "django.test.testcases.TestCase"));
    }

    public static boolean isDjangoTestCaseClass(@NotNull PyClass cls) {
        if (cls == null) {
            DjangoTestUtil.$$$reportNull$$$0(0);
        }
        TypeEvalContext context = TypeEvalContext.userInitiated(cls.getProject(), null);
        return PyClassExtKt.inherits(cls, context, "django.test.testcases.SimpleTestCase");
    }

    @Nullable
    public static String getAppNameForLocation(Module module, PsiElement element) {
        String name;
        boolean needFullTestsPath;
        PsiFileSystemItem file2;
        if (module == null || element == null) {
            return null;
        }
        DjangoFacet djangoFacet = DjangoFacet.getInstance(module);
        if (djangoFacet == null) {
            return null;
        }
        Object object = file2 = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
        if (file2 == null) {
            return null;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        String testRunner = DjangoSettingsPy.getTestRunner(module);
        boolean isSuiteTestRunner = testRunner != null && (testRunner.contains("django_nose.NoseTestSuiteRunner") || testRunner.contains("django.test.simple.DjangoTestSuiteRunner"));
        boolean bl = needFullTestsPath = !isSuiteTestRunner || testRunner.contains("discover_runner.DiscoverRunner") || testRunner.contains("django_nose.NoseTestSuiteRunner");
        if (needFullTestsPath && (name = DjangoTestUtil.getDotPathByElement(element)) != null) {
            return name;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().getContentRootForFile(vFile);
        ArrayList<String> files = new ArrayList<String>();
        VirtualFile projectRoot = ((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getProjectRootFolderFile();
        while (vFile != null && !Comparing.equal((Object)vFile, (Object)contentRoot) && !Comparing.equal((Object)vFile, (Object)projectRoot)) {
            if (needFullTestsPath) {
                files.add(0, vFile.getNameWithoutExtension());
            }
            if (DjangoTestUtil.isAppRoot(vFile) && !needFullTestsPath) {
                return vFile.getName();
            }
            vFile = vFile.getParent();
        }
        return needFullTestsPath ? StringUtil.join(files, (String)".") : null;
    }

    @Nullable
    private static String getDotPathByElement(@NotNull PsiElement element) {
        PsiDirectory root;
        if (element == null) {
            DjangoTestUtil.$$$reportNull$$$0(1);
        }
        if ((root = DjangoUtil.getProjectRoot(element)) == null) {
            return null;
        }
        VirtualFile mainFolder = root.getVirtualFile();
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile elementFile = containingFile.getVirtualFile();
        if (!VfsUtilCore.isAncestor((VirtualFile)mainFolder, (VirtualFile)elementFile, (boolean)false)) {
            return null;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)elementFile, (VirtualFile)mainFolder, (char)'.');
        if (relativePath == null) {
            return null;
        }
        return relativePath.endsWith(".py") ? relativePath.substring(0, relativePath.length() - ".py".length()) : relativePath;
    }

    private static boolean isAppRoot(VirtualFile vFile) {
        VirtualFile[] children2;
        if (!vFile.isDirectory()) {
            return false;
        }
        for (VirtualFile child : children2 = vFile.getChildren()) {
            if (!child.getName().startsWith("models") && !child.getName().startsWith("views")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String buildTargetFromLocation(Module module, String appName, @Nullable PsiElement element) {
        if (appName == null) {
            return null;
        }
        String testRunner = DjangoSettingsPy.getTestRunner(module);
        String separator = testRunner != null && testRunner.contains("django_nose.NoseTestSuiteRunner") ? ":" : ".";
        PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        if (containingClass != null) {
            PyFunction containingFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class});
            if (containingFunction != null) {
                String name = appName + separator;
                name = name + containingClass.getName() + "." + containingFunction.getName();
                return name;
            }
            String name = appName + separator;
            name = name + containingClass.getName();
            return name;
        }
        return appName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/testRunner/DjangoTestUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isDjangoTestCaseClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDotPathByElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

