/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ref;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.jetbrains.django.ref.DjangoItemFilter;
import com.jetbrains.django.ref.DjangoItemReference;
import com.jetbrains.django.ref.DjangoReferenceUtil;
import com.jetbrains.django.ref.ViewMethodReferenceProvider;
import com.jetbrains.django.util.DjangoStringUtil;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.psi.resolve.RootVisitor;
import com.jetbrains.python.psi.resolve.RootVisitorHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoItemReferenceSet {
    private static final char DOT = '.';
    @NotNull
    private PsiElement myElement;
    @Nullable
    private String myPrefix;
    private boolean myShouldResolveDjangoRoot;
    private DjangoItemReference[] myReferences;
    private final String myText;
    private final int myStartInElement;
    private final DjangoItemFilter myFilter;

    DjangoItemReferenceSet(@NotNull PsiElement element, DjangoItemFilter filter) {
        if (element == null) {
            DjangoItemReferenceSet.$$$reportNull$$$0(0);
        }
        this.myPrefix = null;
        this.myElement = element;
        TextRange range = DjangoStringUtil.getTextRange(element);
        this.myText = range.substring(element.getText());
        this.myStartInElement = range.getStartOffset();
        this.setReferences(this.parse(this.myText, this.myStartInElement));
        this.myFilter = filter;
    }

    public String getText() {
        return this.myText;
    }

    public int getStartInElement() {
        return this.myStartInElement;
    }

    private DjangoItemReference[] parse(String str, int startInElement) {
        int nextDot;
        ArrayList referencesList = Lists.newArrayList();
        int curDot = -1;
        while (curDot + 1 < str.length() && Character.isWhitespace(str.charAt(curDot + 1))) {
            ++curDot;
        }
        if (curDot + 1 < str.length() && str.charAt(curDot + 1) == '.') {
            ++curDot;
        }
        int index = 0;
        do {
            String subreferenceText = (nextDot = str.indexOf(46, curDot + 1)) > 0 ? str.substring(curDot + 1, nextDot) : str.substring(curDot + 1);
            DjangoItemReference ref = this.createDjangoReference(new TextRange(startInElement + curDot + 1, startInElement + (nextDot > 0 ? nextDot : str.length())), index++, subreferenceText, nextDot < 0);
            referencesList.add(ref);
        } while ((curDot = nextDot) >= 0);
        return referencesList.toArray(new DjangoItemReference[0]);
    }

    protected DjangoItemReference createDjangoReference(TextRange range, int index, String subreferenceText, boolean isLast) {
        return new DjangoItemReference(this, range, index, subreferenceText);
    }

    private void setReferences(DjangoItemReference[] references2) {
        this.myReferences = references2;
    }

    void setElement(PsiElement element) {
        this.myElement = element;
    }

    public List<PsiReference> getAllReferencesAsList() {
        return Lists.newArrayList((Object[])this.getAllReferences());
    }

    public PsiReference[] getAllReferences() {
        return this.myReferences;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getDefaultContexts() {
        final HashSet result = Sets.newHashSet();
        PsiDirectory djangoRoot = DjangoReferenceUtil.getDjangoRoot(this.getElement());
        if (djangoRoot != null) {
            result.add(djangoRoot);
            result.add(djangoRoot.getParent());
        }
        RootVisitor rootVisitor = new RootVisitor(){

            @Override
            public boolean visitRoot(VirtualFile root, Module module, Sdk sdk, boolean isModuleSource) {
                if (root.isValid() && !PyUserSkeletonsUtil.isUnderUserSkeletonsDirectory(root)) {
                    result.add(FileReferenceHelper.getPsiFileSystemItem((PsiManager)DjangoItemReferenceSet.this.getElement().getManager(), (VirtualFile)root));
                }
                return true;
            }
        };
        RootVisitorHost.visitRoots(this.getElement(), rootVisitor);
        HashSet hashSet = result;
        if (hashSet == null) {
            DjangoItemReferenceSet.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    public DjangoItemReference getReference(int index) {
        return this.myReferences[index];
    }

    public int getReferenceCount() {
        return this.myReferences.length;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public DjangoItemFilter getFilter() {
        return this.myFilter;
    }

    @Nullable
    public String getPrefix() {
        return this.myPrefix;
    }

    public void setPrefix(@Nullable String prefix) {
        this.myPrefix = prefix;
    }

    public String withPrefix(String text2) {
        String prefix = this.getPrefix();
        return ViewMethodReferenceProvider.withPrefix(text2, prefix);
    }

    public boolean shouldResolveDjangoRoot() {
        return this.myShouldResolveDjangoRoot;
    }

    public void setShouldResolveDjangoRoot(boolean shouldResolveDjangoRoot) {
        this.myShouldResolveDjangoRoot = shouldResolveDjangoRoot;
    }

    public static DjangoItemReferenceSet createPackagesReferenceSet(PsiElement element) {
        return new DjangoItemReferenceSet(element, DjangoItemFilter.PACKAGES);
    }

    public static DjangoItemReferenceSet createFilesReferenceSet(PsiElement element) {
        return new DjangoItemReferenceSet(element, DjangoItemFilter.FILES);
    }

    public static DjangoItemReferenceSet createFunctionsReferenceSet(PsiElement element) {
        return new DjangoItemReferenceSet(element, DjangoItemFilter.FUNCTIONS);
    }

    public static DjangoItemReferenceSet createClassesReferenceSet(PsiElement element) {
        return new DjangoItemReferenceSet(element, DjangoItemFilter.CLASSES);
    }

    public static DjangoItemReferenceSet createClassesAndFunctionsReferenceSet(PsiElement element) {
        return new DjangoItemReferenceSet(element, DjangoItemFilter.CLASSES_AND_FUNCTIONS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/ref/DjangoItemReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/ref/DjangoItemReferenceSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

