/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.inspection;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.psi.XmlPsiBundle;
import com.jetbrains.django.lang.template.psi.impl.DjangoTagElementImpl;
import com.jetbrains.django.lang.template.tags.DjangoBlockTag;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.django.util.DjangoTemplateUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoStructureXmlFilter
extends HighlightErrorFilter {
    public static final String[] STRUCTURE_TAGS = new String[]{"if", "ifequal", "ifnotequal", "ifchanged"};

    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        PsiElement el;
        if (element == null) {
            DjangoStructureXmlFilter.$$$reportNull$$$0(0);
        }
        if (DjangoStructureXmlFilter.isXmlTagIsNotClosedError(element)) {
            XmlTag notClosedTag = (XmlTag)element.getParent();
            PsiElement el2 = DjangoPsiUtil.findContainingElementInBaseLanguage((PsiElement)notClosedTag);
            if (el2 != null) {
                while (el2 != null && !DjangoTemplateUtil.isDjangoTag(el2, STRUCTURE_TAGS)) {
                    el2 = el2.getPrevSibling();
                }
                if (el2 instanceof DjangoTagElementImpl) {
                    String name = DjangoTemplateUtil.getTagName((DjangoTagElementImpl)el2);
                    while (el2 != null) {
                        XmlTag tagInElse;
                        PsiElement xmlElement;
                        if (DjangoTemplateUtil.isDjangoTag(el2, "end" + name) && (xmlElement = DjangoPsiUtil.findContainingElementInTemplateDataLanguage(el2)) != null && (tagInElse = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)xmlElement, XmlTag.class)) != null && tagInElse.getName().equals(notClosedTag.getName()) && DjangoStructureXmlFilter.isClosedCorrectly(tagInElse)) {
                            return false;
                        }
                        el2 = el2.getNextSibling();
                    }
                }
            }
        } else if (DjangoStructureXmlFilter.isUnexpectedToken(element) && (el = DjangoPsiUtil.findContainingElementInBaseLanguage(element.getNavigationElement())) != null) {
            XmlTag tag = this.findBlockTagAndResolveToIt(el, Sets.newHashSet());
            return tag == null;
        }
        return true;
    }

    private static boolean isUnexpectedToken(@NotNull PsiErrorElement element) {
        if (element == null) {
            DjangoStructureXmlFilter.$$$reportNull$$$0(1);
        }
        String description = element.getErrorDescription();
        return description.contains(XmlPsiBundle.message((String)"xml.parsing.unexpected.tokens", (Object[])new Object[0]));
    }

    private static boolean isClosedCorrectly(XmlTag tag) {
        Collection errors = PsiTreeUtil.collectElementsOfType((PsiElement)tag, (Class[])new Class[]{PsiErrorElement.class});
        for (PsiErrorElement error : errors) {
            if (!DjangoStructureXmlFilter.isXmlTagIsNotClosedError(error)) continue;
            return false;
        }
        return true;
    }

    private static boolean isXmlTagIsNotClosedError(@Nullable PsiErrorElement element) {
        if (element == null) {
            return false;
        }
        String text2 = element.getErrorDescription();
        return text2.startsWith("Element") && text2.endsWith("is not closed") && element.getParent() instanceof XmlTag;
    }

    @Nullable
    private XmlTag findBlockTagAndResolveToIt(PsiElement tag, Set<DjangoBlockTag> blocksSet) {
        DjangoBlockTag block = DjangoPsiUtil.findOpeningBlock(tag);
        if (block != null) {
            return this.findXmlTagFromBlockDeclaration(block, blocksSet);
        }
        return null;
    }

    @Nullable
    private XmlTag findXmlTagFromBlockDeclaration(DjangoBlockTag block, Set<DjangoBlockTag> blocksSet) {
        PsiElement injection;
        PsiElement el;
        if (blocksSet.contains((Object)block)) {
            return null;
        }
        blocksSet.add(block);
        PsiReference ref = block.getReference();
        if (ref != null && (el = ref.resolve()) != null && (injection = DjangoPsiUtil.findContainingElementInTemplateDataLanguage(el)) != null) {
            XmlTag result = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)injection, XmlTag.class);
            if (result != null) {
                return result;
            }
            return this.findBlockTagAndResolveToIt(DjangoPsiUtil.prevFromTag(el), blocksSet);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/jetbrains/django/lang/template/inspection/DjangoStructureXmlFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldHighlightErrorElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnexpectedToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

