/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.lang.template.DjangoTemplateCloseTagHandlingVisitor;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import com.jetbrains.django.lang.template.psi.DjangoTagName;
import com.jetbrains.django.lang.template.psi.DjangoTemplateElementTypes;
import com.jetbrains.django.lang.template.psi.impl.DjangoElementImpl;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplateFoldingBuilder
implements FoldingBuilder {
    private static final String TRAILER = "... %}";

    @Nullable
    private static String getNameOf(ASTNode node) {
        if (node != null) {
            if (node.getElementType() == DjangoTemplateElementTypes.XML_TAG) {
                PsiElement name_element;
                PsiElement wrapper_elt;
                ASTNode name_node = node.findChildByType(DjangoTemplateElementTypes.TAG_NAME);
                if (name_node == null && (wrapper_elt = PsiTreeUtil.getChildOfType((PsiElement)node.getPsi(), DjangoElementImpl.class)) != null) {
                    name_node = wrapper_elt.getNode().findChildByType(DjangoTemplateElementTypes.TAG_NAME);
                }
                if (name_node != null && (name_element = name_node.getPsi()) != null) {
                    return ((DjangoTagName)name_element).getTagName();
                }
            } else if (DjangoTemplateTokenTypes.BLOCK_COMMENT_TOKENS.contains(node.getElementType())) {
                return "comment";
            }
        }
        return null;
    }

    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        PsiElement root_element;
        if (node == null) {
            DjangoTemplateFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            DjangoTemplateFoldingBuilder.$$$reportNull$$$0(1);
        }
        if ((root_element = node.getPsi()) != null && node.getElementType() == DjangoTemplateElementTypes.DJANGO_TEMPLATE_FILE) {
            final LinkedList result = new LinkedList();
            DjangoTemplateCloseTagHandlingVisitor visitor2 = new DjangoTemplateCloseTagHandlingVisitor(){

                @Override
                protected void handleTagClosed(@NotNull DjangoTagName openTag, @NotNull DjangoTagName closeTag) {
                    if (openTag == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (closeTag == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ASTNode node = 1.getTagElement(openTag).getNode();
                    ASTNode seeker = 1.getTagElement(closeTag).getNode();
                    TextRange range = new TextRange(node.getStartOffset(), seeker.getStartOffset() + seeker.getTextLength());
                    result.add(new FoldingDescriptor(node, range));
                }

                public void visitComment(@NotNull PsiComment comment) {
                    if (comment == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (DjangoTemplateTokenTypes.BLOCK_COMMENT_TOKENS.contains(comment.getNode().getElementType()) && !StringUtil.isEmpty((String)comment.getText()) && comment.getTextRange().getLength() > 1) {
                        result.add(new FoldingDescriptor(comment.getNode(), comment.getTextRange()));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "openTag";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "closeTag";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "comment";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/django/lang/template/editor/DjangoTemplateFoldingBuilder$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleTagClosed";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitComment";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            root_element.acceptChildren((PsiElementVisitor)visitor2);
            FoldingDescriptor[] foldingDescriptorArray = result.toArray(FoldingDescriptor.EMPTY);
            if (foldingDescriptorArray == null) {
                DjangoTemplateFoldingBuilder.$$$reportNull$$$0(2);
            }
            return foldingDescriptorArray;
        }
        if (FoldingDescriptor.EMPTY == null) {
            DjangoTemplateFoldingBuilder.$$$reportNull$$$0(3);
        }
        return FoldingDescriptor.EMPTY;
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        Document doc;
        if (node == null) {
            DjangoTemplateFoldingBuilder.$$$reportNull$$$0(4);
        }
        String text2 = node.getText();
        String name = DjangoTemplateFoldingBuilder.getNameOf(node);
        if (name == null) {
            name = "?";
        }
        int minimal_length = 3 + name.length();
        int cut_position = text2.length() - 2;
        PsiElement elt = node.getPsi();
        if (elt != null && elt.isValid() && (doc = elt.getContainingFile().getViewProvider().getDocument()) != null) {
            int offset = elt.getTextOffset();
            int line_no = doc.getLineNumber(offset);
            int line_offset = offset - doc.getLineStartOffset(line_no);
            Project project = elt.getProject();
            int margin = CodeStyle.getProjectOrDefaultSettings((Project)project).getRightMargin((Language)DjangoTemplateLanguage.INSTANCE);
            int cut_length = line_offset + text2.length() + TRAILER.length() - margin;
            if (cut_length > 0) {
                cut_position = cut_position - cut_length + 2;
            }
            if (cut_position < minimal_length) {
                cut_position = minimal_length;
            }
        }
        if (cut_position <= text2.length()) {
            return text2.substring(0, cut_position) + TRAILER;
        }
        return null;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            DjangoTemplateFoldingBuilder.$$$reportNull$$$0(5);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/editor/DjangoTemplateFoldingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/editor/DjangoTemplateFoldingBuilder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

