/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SofterReference;
import com.intellij.util.messages.MessageBus;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.DjangoTemplateManager;
import com.jetbrains.django.model.TemplateParametersEvaluator;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.extensions.python.PyCallExpressionExtKt;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoWebUrlEvaluator {
    private final Map<PsiElement, SofterReference<String>> myCache = Maps.newHashMap();
    private final Set<VirtualFile> myUsedFilesSet = Sets.newHashSet();

    public DjangoWebUrlEvaluator(MessageBus messageBus) {
        messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (!DjangoWebUrlEvaluator.this.myUsedFilesSet.contains(vFileEvent.getFile())) continue;
                    DjangoWebUrlEvaluator.this.clearCache();
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/jetbrains/django/lang/template/DjangoWebUrlEvaluator$1", "after"));
            }
        });
    }

    private void clearCache() {
        this.myCache.clear();
        this.myUsedFilesSet.clear();
    }

    public static DjangoWebUrlEvaluator getInstance(Project project) {
        return (DjangoWebUrlEvaluator)ServiceManager.getService((Project)project, DjangoWebUrlEvaluator.class);
    }

    private List<NavigatablePsiElement> computeUrlReferences(PsiElement element) {
        NavigatablePsiElement ex;
        ArrayList urlReferences = Lists.newArrayList();
        if (element instanceof PsiFile && (ex = this.getReferenceFromUrlsToTemplate((PsiFile)element)) != null) {
            urlReferences.add(ex);
        }
        if (!urlReferences.isEmpty()) {
            PyExpression refFromUrl;
            while (!DjangoWebUrlEvaluator.isRootConf(DjangoPsiUtil.getFile((PsiElement)urlReferences.get(urlReferences.size() - 1))) && (refFromUrl = this.searchForReferenceInAllUrlsFiles((PsiNamedElement)DjangoPsiUtil.getFile((PsiElement)urlReferences.get(urlReferences.size() - 1)))) != null) {
                urlReferences.add(refFromUrl);
            }
        }
        return urlReferences;
    }

    private static boolean isRootConf(@NotNull PsiFile file2) {
        Module module;
        if (file2 == null) {
            DjangoWebUrlEvaluator.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2)) == null) {
            return true;
        }
        String rootConfExpr = DjangoSettingsPy.getRootUrlconf(module);
        if (rootConfExpr != null) {
            PsiFile rootUrl = DjangoPsiUtil.findFileInRoots(rootConfExpr, (PsiElement)file2);
            return rootUrl != null && DjangoWebUrlEvaluator.fileEquals(file2, rootUrl);
        }
        return true;
    }

    private static boolean fileEquals(PsiFile file2, PsiFile rootUrl) {
        if (file2 != null && rootUrl != null && file2.getVirtualFile() != null && rootUrl.getVirtualFile() != null) {
            return rootUrl.getVirtualFile().getPath().equals(file2.getVirtualFile().getPath());
        }
        return false;
    }

    @Nullable
    public String getRelativePath(PsiElement element) {
        if (!DjangoFacet.isPresent(ModuleUtilCore.findModuleForPsiElement((PsiElement)element))) {
            return null;
        }
        SofterReference<String> resultRef = this.myCache.get(element);
        if (resultRef != null && resultRef.get() != null) {
            return (String)resultRef.get();
        }
        List<NavigatablePsiElement> list = this.computeUrlReferences(element);
        if (list == null || list.size() == 0) {
            return null;
        }
        String path = DjangoWebUrlEvaluator.getRelativePath(0, list);
        if (path == null) {
            return null;
        }
        this.myCache.put(element, (SofterReference<String>)new SofterReference((Object)path));
        return path;
    }

    @Nullable
    private static String getRelativePath(int i, @NotNull List<NavigatablePsiElement> list) {
        if (list == null) {
            DjangoWebUrlEvaluator.$$$reportNull$$$0(1);
        }
        if (i < list.size()) {
            String regexp = DjangoWebUrlEvaluator.getWebPath(DjangoWebUrlEvaluator.getUrlPatternRegexp(list.get(i)));
            String result = DjangoWebUrlEvaluator.getRelativePath(i + 1, list);
            if (regexp != null && result != null) {
                return result + regexp;
            }
            return null;
        }
        return "";
    }

    @Nullable
    public String getDjangoUrlPath(PsiElement element, int port) {
        return DjangoWebUrlEvaluator.getDjangoUrl(this.getRelativePath(element), port);
    }

    @Nullable
    private NavigatablePsiElement getReferenceFromUrlsToTemplate(PsiFile file2) {
        TypeEvalContext context = TypeEvalContext.userInitiated(file2.getProject(), file2);
        Set<NavigatablePsiElement> references2 = DjangoTemplateManager.getTemplateReferences(file2, null, context);
        for (NavigatablePsiElement expr : references2) {
            NavigatablePsiElement el = this.getReferenceFromUrls(expr);
            if (el == null) continue;
            this.myUsedFilesSet.add(expr.getContainingFile().getVirtualFile());
            return el;
        }
        return null;
    }

    @Nullable
    private NavigatablePsiElement getReferenceFromUrls(NavigatablePsiElement expr) {
        PyClass clazz;
        String fileName;
        if (expr.getContainingFile() != null && "urls.py".equals(fileName = expr.getContainingFile().getName())) {
            PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expr, PyCallExpression.class);
            if (call != null && call.getCallee() != null && !PyCallExpressionExtKt.isCalleeName(call, DjangoFQNamesProvider.URL_PATTERNS_FUNCTION, DjangoFQNamesProvider.URL_OR_RE_PATH_FUNCTION)) {
                return call;
            }
            return expr;
        }
        PyFunction func = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expr, PyFunction.class);
        if (func != null) {
            return this.searchForReferenceInAllUrlsFiles(func);
        }
        if (TemplateParametersEvaluator.isTemplateNameInViewClass(expr) && (clazz = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)expr, PyClass.class)) != null) {
            return this.searchForReferenceInAllUrlsFiles((PsiNamedElement)clazz);
        }
        return null;
    }

    @Nullable
    private PyExpression searchForReferenceInAllUrlsFiles(PsiNamedElement element) {
        HashSet urlFiles = Sets.newHashSet();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        DjangoModelApi modelApi = DjangoModelApi.create(module).getSuccessOrNull();
        if (modelApi == null) {
            return null;
        }
        modelApi.collectAllUrlsFromCache(urlFiles);
        Ref expr = Ref.create();
        ReferencesSearch.search((PsiElement)element, (SearchScope)GlobalSearchScope.filesScope((Project)element.getProject(), (Collection)Collections2.transform((Collection)urlFiles, input -> input != null ? input.getVirtualFile() : null))).forEach(reference -> {
            PsiElement referenceElement;
            PsiElement el;
            if (reference != null && PsiTreeUtil.getParentOfType((PsiElement)(el = reference.resolve()), PyImportStatementBase.class) == null && (referenceElement = reference.getElement()) instanceof PyExpression) {
                this.myUsedFilesSet.add(referenceElement.getContainingFile().getVirtualFile());
                expr.set((Object)((PyExpression)referenceElement));
                return true;
            }
            return false;
        });
        return (PyExpression)expr.get();
    }

    @Nullable
    private static PyExpression getUrlPatternRegexp(NavigatablePsiElement expr) {
        PyCallExpression urlCall = DjangoPsiUtil.getUrlCall((PsiElement)expr);
        if (urlCall != null) {
            return urlCall.getArguments()[0];
        }
        PyTupleExpression tuple = DjangoPsiUtil.getTuple((PsiElement)expr);
        if (tuple != null) {
            return tuple.getElements()[0];
        }
        return null;
    }

    @Nullable
    private static String getWebPath(@Nullable PyExpression expr) {
        String value2 = PyStringLiteralUtil.getStringValue((PsiElement)expr);
        if (value2 != null) {
            value2 = value2.replace("$", "").replace("^", "");
            value2 = StringUtil.trimStart((String)value2, (String)"/");
        }
        return value2;
    }

    @Nullable
    static String getDjangoUrl(@Nullable String path, int port) {
        if (path == null) {
            return null;
        }
        return "http://localhost:" + port + "/" + path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/django/lang/template/DjangoWebUrlEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isRootConf";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

