/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.django.codeInsight.DjangoClassMembersProvider;
import com.jetbrains.django.codeInsight.RelationMethodInfo;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DjangoOrmInspection
extends PyInspection {
    private static final Key<Set<PyCallExpression>> ALREADY_CHECKED_KEY = Key.create((String)"DjangoOrmInspection.checkedFunctions");

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            DjangoOrmInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            DjangoOrmInspection.$$$reportNull$$$0(1);
        }
        session.putUserData(ALREADY_CHECKED_KEY, new HashSet());
        PyFile file2 = PyUtil.as(holder.getFile(), PyFile.class);
        if (file2 == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                DjangoOrmInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        if (DjangoModelApi.notDjangoModule((PsiElement)file2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                DjangoOrmInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        return new DjangoOrmInspectionVisitor(holder, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/DjangoOrmInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/DjangoOrmInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DjangoOrmInspectionVisitor
    extends PyInspectionVisitor {
        @NotNull
        private final ProblemsHolder myHolder;

        private DjangoOrmInspectionVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (holder == null) {
                DjangoOrmInspectionVisitor.$$$reportNull$$$0(0);
            }
            if (session == null) {
                DjangoOrmInspectionVisitor.$$$reportNull$$$0(1);
            }
            super(holder, session);
            this.myHolder = holder;
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            if (this.isAlreadyChecked(node)) {
                return;
            }
            PyQualifiedExpression function = PyUtil.as(node.getCallee(), PyQualifiedExpression.class);
            if (function == null) {
                return;
            }
            String functionName = function.getName();
            if (functionName == null) {
                return;
            }
            if (!DjangoClassMembersProvider.isMethodMayBeRelated(functionName)) {
                return;
            }
            PyExpression functionQualifier = function.getQualifier();
            if (functionQualifier == null) {
                return;
            }
            PyType classType = TypeEvalContext.deepCodeInsight(functionQualifier.getProject()).getType(functionQualifier);
            if (classType == null) {
                return;
            }
            RelationMethodInfo methodInfo = DjangoClassMembersProvider.getRelatedMethodsInfo(classType);
            if (methodInfo == null) {
                return;
            }
            String error = null;
            if (methodInfo.getDisabledDueToM2MMethods().contains(functionName)) {
                error = DjangoBundle.message("inspection.django-orm-inspection.disabled-m2m-interm", functionName);
            }
            if (methodInfo.getNonExistenceDueToFKNotNullMethods().contains(functionName)) {
                error = DjangoBundle.message("inspection.django-orm-inspection.non-existence-due-to-foreign-key-not-null-method", functionName);
            }
            if (error != null) {
                this.myHolder.registerProblem((PsiElement)function, error, new LocalQuickFix[0]);
                return;
            }
            super.visitPyCallExpression(node);
        }

        private boolean isAlreadyChecked(@NotNull PyCallExpression node) {
            if (node == null) {
                DjangoOrmInspectionVisitor.$$$reportNull$$$0(2);
            }
            Set data = (Set)this.getSession().getUserData(ALREADY_CHECKED_KEY);
            assert (data != null) : "Data is null, set it first";
            boolean result = data.contains(node);
            if (!result) {
                data.add(node);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/lang/DjangoOrmInspection$DjangoOrmInspectionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAlreadyChecked";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

