/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.commandInterface.console;

import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Consumer;
import com.jetbrains.commandInterface.commandLine.CommandLineLanguage;
import com.jetbrains.commandInterface.commandLine.psi.CommandLineFile;
import com.jetbrains.commandInterface.console.CommandModeConsumer;
import com.jetbrains.commandInterface.console.CommandsInfo;
import com.jetbrains.commandInterface.console.ProcessModeConsumer;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.toolWindowWithActions.ConsoleWithProcess;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.border.MatteBorder;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CommandConsole
extends LanguageConsoleImpl
implements Consumer<String>,
Condition<LanguageConsoleView>,
ConsoleWithProcess {
    static final int BORDER_SIZE_PX = 3;
    @Nullable
    private final CommandsInfo myCommandsInfo;
    @NotNull
    private final Module myModule;
    @Nullable
    private Consumer<String> myCurrentConsumer;
    @NotNull
    private final Object myConsumerSemaphore;
    @NotNull
    private final Collection<Runnable> myStateChangeListeners;
    @Nullable
    private volatile ProcessHandler myProcessHandler;

    private CommandConsole(@NotNull Module module, @NotNull String title, @Nullable CommandsInfo commandsInfo) {
        if (module == null) {
            CommandConsole.$$$reportNull$$$0(0);
        }
        if (title == null) {
            CommandConsole.$$$reportNull$$$0(1);
        }
        super(new LanguageConsoleImpl.Helper(module.getProject(), (VirtualFile)new LightVirtualFile(title, (Language)CommandLineLanguage.INSTANCE, (CharSequence)"")){

            public void setupEditor(@NotNull EditorEx editor2) {
                if (editor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.setupEditor(editor2);
                EditorSettings editorSettings = editor2.getSettings();
                editorSettings.setAdditionalLinesCount(0);
                editorSettings.setAdditionalColumnsCount(0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/commandInterface/console/CommandConsole$1", "setupEditor"));
            }
        });
        this.myConsumerSemaphore = new Object();
        this.myStateChangeListeners = new ArrayList<Runnable>();
        this.myCommandsInfo = commandsInfo;
        this.myModule = module;
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        Function1<String, String> outputFilter;
        if (text2 == null) {
            CommandConsole.$$$reportNull$$$0(2);
        }
        if (contentType == null) {
            CommandConsole.$$$reportNull$$$0(3);
        }
        if (this.myCommandsInfo != null && (outputFilter = this.myCommandsInfo.getOutputFilter()) != null) {
            text2 = (String)outputFilter.invoke((Object)text2);
        }
        super.print(text2, contentType);
    }

    @NotNull
    static CommandConsole createConsole(@NotNull Module module, @NotNull String title, @Nullable CommandsInfo commandsInfo) {
        if (module == null) {
            CommandConsole.$$$reportNull$$$0(4);
        }
        if (title == null) {
            CommandConsole.$$$reportNull$$$0(5);
        }
        CommandConsole console = new CommandConsole(module, title, commandsInfo);
        console.setEditable(true);
        LanguageConsoleBuilder.registerExecuteAction((LanguageConsoleView)console, (Consumer)console, (String)title, (String)title, (Condition)console);
        console.switchToCommandMode();
        console.getComponent();
        console.getConsoleEditor().getSettings().setAdditionalLinesCount(2);
        Disposer.register((Disposable)module.getProject(), (Disposable)console);
        console.addMessageFilter((Filter)new UrlFilter());
        CommandConsole commandConsole = console;
        if (commandConsole == null) {
            CommandConsole.$$$reportNull$$$0(6);
        }
        return commandConsole;
    }

    private static void configureLeftBorder(boolean enable, EditorEx ... editors) {
        if (editors == null) {
            CommandConsole.$$$reportNull$$$0(7);
        }
        for (EditorEx editor2 : editors) {
            Color backgroundColor = editor2.getBackgroundColor();
            int thickness = enable ? 3 : 0;
            MatteBorder border = BorderFactory.createMatteBorder(0, thickness, 0, 0, backgroundColor);
            editor2.getComponent().setBorder(border);
        }
    }

    public void attachToProcess(ProcessHandler processHandler2) {
        super.attachToProcess(processHandler2);
        processHandler2.addProcessListener((ProcessListener)new MyProcessListener());
    }

    private void switchToCommandMode() {
        this.myProcessHandler = null;
        this.setPrompt(this.getTitle() + " > ");
        ApplicationManager.getApplication().invokeAndWait(() -> {
            this.notifyStateChangeListeners();
            CommandConsole.configureLeftBorder(true, this.getConsoleEditor(), this.getHistoryViewer());
            this.setLanguage(CommandLineLanguage.INSTANCE);
            CommandLineFile file2 = PyUtil.as(this.getFile(), CommandLineFile.class);
            this.resetConsumer(null);
            if (file2 == null || this.myCommandsInfo == null) {
                return;
            }
            file2.setCommands(this.myCommandsInfo.getCommands());
            CommandConsole console = this;
            this.resetConsumer(new CommandModeConsumer(this.myCommandsInfo.getCommands(), this.myModule, console, this.myCommandsInfo.getUnknownCommandsExecutor()));
        }, ModalityState.NON_MODAL);
    }

    private void switchToProcessMode(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            CommandConsole.$$$reportNull$$$0(8);
        }
        this.myProcessHandler = processHandler2;
        ApplicationManager.getApplication().invokeAndWait(() -> {
            CommandConsole.configureLeftBorder(false, this.getConsoleEditor());
            this.notifyStateChangeListeners();
            this.resetConsumer(new ProcessModeConsumer(processHandler2));
            this.setLanguage((Language)PlainTextLanguage.INSTANCE);
            this.setPrompt("");
        }, ModalityState.NON_MODAL);
    }

    private void notifyStateChangeListeners() {
        for (Runnable listener2 : this.myStateChangeListeners) {
            listener2.run();
        }
    }

    @Override
    @Nullable
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetConsumer(@Nullable Consumer<String> newConsumer) {
        Object object = this.myConsumerSemaphore;
        synchronized (object) {
            this.myCurrentConsumer = newConsumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean value(LanguageConsoleView t) {
        Object object = this.myConsumerSemaphore;
        synchronized (object) {
            return this.myCurrentConsumer != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(String t) {
        Object object = this.myConsumerSemaphore;
        synchronized (object) {
            if (this.myCurrentConsumer != null) {
                this.myCurrentConsumer.consume((Object)t);
            }
        }
    }

    void addStateChangeListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            CommandConsole.$$$reportNull$$$0(9);
        }
        this.myStateChangeListeners.add(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/commandInterface/console/CommandConsole";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/commandInterface/console/CommandConsole";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configureLeftBorder";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "switchToProcessMode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addStateChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyProcessListener
    extends ProcessAdapter {
        private MyProcessListener() {
        }

        public void processTerminated(@NotNull ProcessEvent event2) {
            if (event2 == null) {
                MyProcessListener.$$$reportNull$$$0(0);
            }
            super.processTerminated(event2);
            CommandConsole.this.switchToCommandMode();
        }

        public void startNotified(@NotNull ProcessEvent event2) {
            if (event2 == null) {
                MyProcessListener.$$$reportNull$$$0(1);
            }
            super.startNotified(event2);
            CommandConsole.this.switchToProcessMode(event2.getProcessHandler());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/jetbrains/commandInterface/console/CommandConsole$MyProcessListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startNotified";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

