/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.run;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.appengine.run.AppEngineServerRunConfiguration;
import com.jetbrains.appengine.ui.AppEngineBundle;
import com.jetbrains.django.run.BrowserUrlPanel;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PyCommonOptionsFormFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class AppEngineServerRunConfigurationEditor
extends SettingsEditor<AppEngineServerRunConfiguration>
implements PanelWithAnchor {
    private JPanel myPanel;
    private JTextField myPort;
    private JPanel myBrowserUrlPanelHolder;
    private JPanel myCommonOptionsFormPlaceholder;
    private JTextField myAdditionalOptionsField;
    private JTextField myHostTextField;
    private JBLabel myAdditionalOptionsLabel;
    private final BrowserUrlPanel myBrowserUrlPanel;
    private final AbstractPyCommonOptionsForm myCommonOptionsForm;
    private JComponent anchor;

    public AppEngineServerRunConfigurationEditor(AppEngineServerRunConfiguration config) {
        this.$$$setupUI$$$();
        this.myCommonOptionsForm = PyCommonOptionsFormFactory.getInstance().createForm(config.getCommonOptionsFormData());
        this.myCommonOptionsFormPlaceholder.add((Component)this.myCommonOptionsForm.getMainPanel(), "Center");
        this.myBrowserUrlPanel = new BrowserUrlPanel(){

            @Override
            protected String getHost() {
                return AppEngineServerRunConfigurationEditor.this.myHostTextField.getText();
            }

            @Override
            protected String getPort() {
                String port = AppEngineServerRunConfigurationEditor.this.myPort.getText();
                return StringUtil.isEmptyOrSpaces((String)port) ? "8080" : port;
            }
        };
        this.myBrowserUrlPanelHolder.add((Component)this.myBrowserUrlPanel, "Center");
        this.myBrowserUrlPanel.watch(this.myHostTextField, this.myPort);
        this.setAnchor(this.myCommonOptionsForm.getAnchor());
    }

    protected void resetEditorFrom(@NotNull AppEngineServerRunConfiguration s) {
        if (s == null) {
            AppEngineServerRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        AbstractPythonRunConfiguration.copyParams(s, this.myCommonOptionsForm);
        Integer port = s.getPort();
        this.myPort.setText(port != null ? Integer.toString(port) : "");
        this.myHostTextField.setText(s.getHost());
        this.myBrowserUrlPanel.setBrowserUrl(s.getBrowserUrl());
        this.myAdditionalOptionsField.setText(s.getAdditionalOptions());
        this.myBrowserUrlPanel.setLaunchJavascriptDebugger(s.isLaunchJavascriptDebugger());
    }

    protected void applyEditorTo(@NotNull AppEngineServerRunConfiguration s) throws ConfigurationException {
        if (s == null) {
            AppEngineServerRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        AbstractPythonRunConfiguration.copyParams(this.myCommonOptionsForm, s);
        Integer port = null;
        String strPort = this.myPort.getText();
        if (!StringUtil.isEmpty((String)strPort)) {
            try {
                port = Integer.parseInt(strPort);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(AppEngineBundle.message("port-error", new Object[0]));
            }
        }
        s.setPort(port);
        s.setHost(this.myHostTextField.getText());
        s.setBrowserUrl(this.myBrowserUrlPanel.getBrowserUrl());
        s.setAdditionalOptions(this.myAdditionalOptionsField.getText());
        s.setLaunchJavascriptDebugger(this.myBrowserUrlPanel.isLaunchJavascriptDebugger());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            AppEngineServerRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myCommonOptionsForm.setAnchor(anchor);
        this.myAdditionalOptionsLabel.setAnchor(anchor);
        this.myBrowserUrlPanel.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel2;
        JTextField jTextField3;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/AppEngineBundle", AppEngineServerRunConfigurationEditor.class).getString("python.app.engine.server.run.config.port"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPort = jTextField3 = new JTextField();
        jPanel3.add((Component)jTextField3, new GridConstraints(0, 3, 1, 1, 4, 0, 0, 0, null, new Dimension(75, -1), null));
        this.myBrowserUrlPanelHolder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myHostTextField = jTextField2 = new JTextField();
        jTextField2.setColumns(20);
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAdditionalOptionsField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(1, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCommonOptionsFormPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(4, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAdditionalOptionsLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/AppEngineBundle", AppEngineServerRunConfigurationEditor.class).getString("python.app.engine.server.run.config.additional.options"));
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/AppEngineBundle", AppEngineServerRunConfigurationEditor.class).getString("python.app.engine.server.run.config.host"));
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/appengine/run/AppEngineServerRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/appengine/run/AppEngineServerRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

