/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.facet;

import com.intellij.DynamicBundle;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.appengine.facet.AppEngineWizardSettingsHolder;
import com.jetbrains.appengine.ui.AppEngineBundle;
import com.jetbrains.appengine.util.AppEngineUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class AppEngineWizardSettingsPanel
extends JPanel {
    private JPanel myPanel;
    private JTextField myApplicationId;
    private TextFieldWithBrowseButton myAppEngineSdkFolder;
    private boolean myIdModified = false;
    private static final Pattern APP_ID_PATTERN = Pattern.compile("[a-z0-9][a-z0-9\\-]+");

    public AppEngineWizardSettingsPanel() {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.add((Component)this.myPanel, "Center");
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myAppEngineSdkFolder.addBrowseFolderListener(AppEngineBundle.message("select-sdk-folder-title", new Object[0]), null, null, descriptor2);
        this.myApplicationId.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AppEngineWizardSettingsPanel.this.myIdModified = true;
            }
        });
    }

    public void setApplicationId(String id) {
        if (this.myApplicationId.getText().equals(id)) {
            this.myIdModified = false;
        }
        if (!this.myIdModified) {
            this.myApplicationId.setText(id);
        }
    }

    public void saveSettings(AppEngineWizardSettingsHolder holder) {
        String path = this.myAppEngineSdkFolder.getText();
        if (AppEngineUtil.isGoogleCloudSdkFolder(path)) {
            path = AppEngineUtil.getAppEngineComponent(path);
        }
        holder.setAppEngineSdkFolder(path);
        holder.setApplicationId(this.myApplicationId.getText());
    }

    public void registerValidators(FacetValidatorsManager validatorsManager) {
        AppEngineWizardSettingsPanel.validateOnTextChange(validatorsManager, this.myApplicationId);
        AppEngineWizardSettingsPanel.validateOnTextChange(validatorsManager, this.myAppEngineSdkFolder.getTextField());
    }

    private static void validateOnTextChange(final FacetValidatorsManager validatorsManager, JTextField textField) {
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                validatorsManager.validate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/appengine/facet/AppEngineWizardSettingsPanel$2", "textChanged"));
            }
        });
    }

    public String getApplicationId() {
        return this.myApplicationId.getText();
    }

    public String getAppEngineSdkFolder() {
        return this.myAppEngineSdkFolder.getText();
    }

    public void addAppEngineSdkFolderListener(DocumentListener documentListener2) {
        this.myAppEngineSdkFolder.getTextField().getDocument().addDocumentListener(documentListener2);
    }

    public void setAppEngineSdkFolder(String appEngineSdkFolder) {
        this.myAppEngineSdkFolder.setText(appEngineSdkFolder);
    }

    public ValidationResult getValidationResult() {
        ValidationResult sdkValidationResult = AppEngineUtil.validateSdk(this.getAppEngineSdkFolder());
        if (sdkValidationResult != ValidationResult.OK) {
            return sdkValidationResult;
        }
        if (!APP_ID_PATTERN.matcher(this.getApplicationId()).matches()) {
            return new ValidationResult(AppEngineBundle.message("facet-wizard-error.bad-app-name", new Object[0]));
        }
        return ValidationResult.OK;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/AppEngineBundle", AppEngineWizardSettingsPanel.class).getString("python.app.engine.wizard.app.id"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/AppEngineBundle", AppEngineWizardSettingsPanel.class).getString("python.app.engine.wizard.sdk.dir"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myApplicationId = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAppEngineSdkFolder = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

