/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.facet;

import com.intellij.DynamicBundle;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.appengine.facet.AppEngineWizardSettingsHolder;
import com.jetbrains.appengine.facet.AppEngineWizardSettingsPanel;
import com.jetbrains.django.facet.DjangoProjectCreateWizardPanel;
import com.jetbrains.python.templateLanguages.TemplateLanguagePanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public class AppEngineNewProjectPanel
extends JPanel {
    private final AppEngineWizardSettingsPanel myAppEngineWizardSettingsPanel;
    @NonNls
    public static final String DJANGO = "Django";
    @NonNls
    public static final String FLASK = "Flask";
    private JPanel myPanel;
    private JPanel myAppEnginePanel;
    private JCheckBox myEnableThirdPartyLibraries;
    private ComboBox myThirdPartySupport;
    private JPanel myThirdPartyPanel;
    private final DjangoProjectCreateWizardPanel myDjangoPanel;
    private final TemplateLanguagePanel myFlaskPanel;
    private String currentThirdPartyPanel;

    public AppEngineNewProjectPanel(String name) {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.add((Component)this.myPanel, "Center");
        this.myAppEngineWizardSettingsPanel = new AppEngineWizardSettingsPanel();
        this.myAppEngineWizardSettingsPanel.setAppEngineSdkFolder(AppEngineWizardSettingsHolder.getDefaultAppEngineSdkFolder());
        this.myAppEngineWizardSettingsPanel.setApplicationId(name);
        this.myAppEnginePanel.add(this.myAppEngineWizardSettingsPanel);
        this.myThirdPartySupport.addItem((Object)DJANGO);
        this.myThirdPartySupport.addItem((Object)FLASK);
        this.myThirdPartyPanel.setVisible(false);
        this.myThirdPartySupport.setEnabled(false);
        this.myThirdPartySupport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppEngineNewProjectPanel.this.updateThirdPartyPanel();
            }
        });
        this.myDjangoPanel = new DjangoProjectCreateWizardPanel();
        this.myDjangoPanel.setProjectName(name);
        this.myFlaskPanel = new TemplateLanguagePanel((Collection<String>)ContainerUtil.immutableList((Object[])new String[]{"None", DJANGO, "Mako", "Jinja2"}));
        this.myFlaskPanel.setTemplateLanguage("Jinja2");
        this.myThirdPartyPanel.add((Component)this.myFlaskPanel, FLASK);
        this.myThirdPartyPanel.add((Component)this.myDjangoPanel, DJANGO);
        this.myEnableThirdPartyLibraries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppEngineNewProjectPanel.this.updateThirdPartyPanel();
            }
        });
    }

    private void updateThirdPartyPanel() {
        this.myThirdPartyPanel.setVisible(this.myEnableThirdPartyLibraries.isSelected());
        this.myThirdPartySupport.setEnabled(this.myEnableThirdPartyLibraries.isSelected());
        CardLayout layout = (CardLayout)this.myThirdPartyPanel.getLayout();
        String library = this.thirdPartyLibrary();
        if (DJANGO.equals(library)) {
            this.currentThirdPartyPanel = DJANGO;
            layout.show(this.myThirdPartyPanel, DJANGO);
        } else if (FLASK.equals(library)) {
            this.currentThirdPartyPanel = FLASK;
            layout.show(this.myThirdPartyPanel, FLASK);
        }
    }

    public void saveSettings(AppEngineWizardSettingsHolder holder) {
        this.myAppEngineWizardSettingsPanel.saveSettings(holder);
        if (this.myEnableThirdPartyLibraries.isSelected()) {
            holder.setThirdPartyLib(this.thirdPartyLibrary());
            if (DJANGO.equals(this.thirdPartyLibrary())) {
                this.myDjangoPanel.saveSettings(holder);
            } else if (FLASK.equals(this.thirdPartyLibrary())) {
                this.myFlaskPanel.saveSettings(holder);
            }
        }
    }

    public String thirdPartyLibrary() {
        Object selectedItem = this.myThirdPartySupport.getSelectedItem();
        return this.myEnableThirdPartyLibraries.isSelected() ? (String)selectedItem : null;
    }

    public AppEngineWizardSettingsPanel getAppEngineWizardSettingsPanel() {
        return this.myAppEngineWizardSettingsPanel;
    }

    public void registerValidators(final FacetValidatorsManager validatorsManager) {
        this.myAppEngineWizardSettingsPanel.registerValidators(validatorsManager);
        this.myFlaskPanel.registerValidators(validatorsManager);
        this.myDjangoPanel.registerValidators(validatorsManager);
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppEngineNewProjectPanel.this.updateThirdPartyPanel();
                validatorsManager.validate();
            }
        };
        this.myEnableThirdPartyLibraries.addActionListener(listener2);
        this.myThirdPartySupport.addActionListener(listener2);
    }

    public TemplateLanguagePanel getTemplatesPanel() {
        if (DJANGO.equals(this.currentThirdPartyPanel)) {
            return this.myDjangoPanel.getTemplatesPanel();
        }
        if (FLASK.equals(this.currentThirdPartyPanel)) {
            return this.myFlaskPanel;
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        ComboBox comboBox;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myAppEnginePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myEnableThirdPartyLibraries = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/AppEngineBundle", AppEngineNewProjectPanel.class).getString("python.app.engine.enable.third.party.libs"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myThirdPartySupport = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myThirdPartyPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

