/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.utils;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.Utils;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.GraphUtil;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.UIUtil;
import java.awt.Cursor;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class UmlUtils {
    private UmlUtils() {
    }

    public static Point getNodeCoordinatesOnScreen(Node node, Graph2DView view) {
        return Utils.getNodeCoordinatesOnScreen((Node)node, (Graph2DView)view);
    }

    public static void updateAfterCategoryChange(DiagramBuilder builder) {
        builder.updateGraph();
        GraphUtil.doLayout((GraphBuilder)((GraphBuilder)builder));
        if (DiagramConfiguration.getConfiguration().fitContentAfterLayout) {
            builder.getGraphBuilder().fitContent();
        }
        builder.getGraphBuilder().updateView();
    }

    public static Point getPointBeneathHeader(Point p, DiagramBuilder builder) {
        return new Point(p.x, p.y + (int)(24.0 * builder.getView().getZoom()));
    }

    public static void refreshDataModelInSmartMode(@Nullable DiagramBuilder builder) {
        if (builder == null || Disposer.isDisposed((Disposable)builder)) {
            return;
        }
        DiagramDataModel model = builder.getDataModel();
        JComponent viewComponent = builder.getView().getJComponent();
        Cursor oldCursor = viewComponent.getCursor();
        viewComponent.setCursor(Cursor.getPredefinedCursor(3));
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                DumbService.getInstance((Project)builder.getProject()).runReadActionInSmartMode(() -> {
                    if (Disposer.isDisposed((Disposable)builder)) {
                        return;
                    }
                    model.refreshDataModel();
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (Disposer.isDisposed((Disposable)builder)) {
                            return;
                        }
                        builder.updateGraph();
                        builder.getGraphBuilder().fitContent();
                    });
                });
            }
            finally {
                UIUtil.invokeLaterIfNeeded(() -> viewComponent.setCursor(oldCursor));
            }
        });
    }
}

