/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.project.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.Utils;
import com.intellij.diagram.actions.DiagramNodeIntentionAction;
import com.intellij.diagram.actions.PopupCallback;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.components.JBList;
import com.intellij.uml.project.ModuleItem;
import com.intellij.uml.project.ModulesUmlDataModel;
import com.intellij.uml.utils.DiagramJavaBundle;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JLabel;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public class ShowModuleUsagesAction
extends DiagramNodeIntentionAction<ModuleItem>
implements ShortcutProvider {
    public ShowModuleUsagesAction() {
        super("Show Usages", null, AllIcons.Actions.Find);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        AnAction action = ActionManager.getInstance().getAction("FindUsages");
        return action == null ? null : action.getShortcutSet();
    }

    public boolean isAvailable(DiagramNode<ModuleItem> node) {
        return true;
    }

    public void perform(DiagramNode<ModuleItem> node, DiagramBuilder builder) {
        ModuleItem selectedValue = (ModuleItem)node.getIdentifyingElement();
        ModulesUmlDataModel model = (ModulesUmlDataModel)builder.getDataModel();
        LibraryProjectStructureElement structureElement = selectedValue.isLibrary() ? new LibraryProjectStructureElement(model.getContext(), selectedValue.getLibrary()) : new ModuleProjectStructureElement(model.getContext(), selectedValue.getModule());
        Object[] usages = model.getContext().getDaemonAnalyzer().getUsages((ProjectStructureElement)structureElement).toArray(new ProjectStructureElementUsage[0]);
        Arrays.sort(usages, Comparator.comparing(ProjectStructureElementUsage::getPresentableName, String.CASE_INSENSITIVE_ORDER));
        JBList list = new JBList(usages);
        list.installCellRenderer(dom -> {
            ProjectStructureElementUsage usage = (ProjectStructureElementUsage)dom;
            ProjectStructureElement element = usage.getContainingElement();
            JLabel label = new JLabel(element.getPresentableText(), usage.getIcon(), 2);
            if (element instanceof ModuleProjectStructureElement) {
                label.setText(((ModuleProjectStructureElement)element).getModule().getName());
            }
            return label;
        });
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(DiagramJavaBundle.message("popup.title.usages.of.0", selectedValue.getName())).setFilteringEnabled(item -> ((ProjectStructureElementUsage)item).getPresentableName()).setItemChoosenCallback(DiagramAction.createCallback((DiagramBuilder)builder, (PopupCallback)new PopupCallback.Adapter(() -> {
            for (ProjectStructureElementUsage usage : list.getSelectedValuesList()) {
                ProjectStructureElement element = usage.getContainingElement();
                DiagramNode<ModuleItem> n = null;
                if (element instanceof ModuleProjectStructureElement) {
                    n = model.addElement(new ModuleItem(((ModuleProjectStructureElement)element).getModule()));
                } else if (element instanceof LibraryProjectStructureElement) {
                    n = model.addElement(new ModuleItem(((LibraryProjectStructureElement)element).getLibrary(), model.getProject()));
                }
                if (n == null) continue;
                builder.createDraggedNode(n, n.getTooltip(), DiagramUtils.getBestPositionForNode((DiagramBuilder)builder));
            }
            builder.update(true, true);
        }, "Add elements to diagram"))).createPopup();
        Utils.showPopupBeneathNode((JBPopup)popup, (Node)builder.getNode(node), (Graph2DView)builder.getView());
    }
}

