/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import a.g.lb;
import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.NoMatchFoundException;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.inspection.StructuralSearchProfileActionProvider;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceCommand;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationCellRenderer;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.ConfigurationUtil;
import com.intellij.structuralsearch.plugin.ui.FileTypeInfo;
import com.intellij.structuralsearch.plugin.ui.FileTypeSelector;
import com.intellij.structuralsearch.plugin.ui.LinkComboBox;
import com.intellij.structuralsearch.plugin.ui.ScopePanel;
import com.intellij.structuralsearch.plugin.ui.SearchCommand;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SelectTemplateDialog;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchTemplateBuilder;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterPanel;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.NullableConsumer;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.textCompletion.TextCompletionUtil;
import com.intellij.util.ui.TextTransferable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchDialog
extends DialogWrapper
implements ProjectManagerListener,
DocumentListener {
    @NonNls
    private static final String r = "#com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog";
    @NonNls
    private static final String t = "#com.intellij.structuralsearch.plugin.ui.StructuralReplaceDialog";
    @NonNls
    private static final String c = "structural.search.recursive";
    @NonNls
    private static final String u = "structural.search.match.case";
    @NonNls
    private static final String v = "structural.search.shorten.fqn";
    @NonNls
    private static final String f = "structural.search.reformat";
    @NonNls
    private static final String m = "structural.search.use.static.import";
    @NonNls
    private static final String j = "structural.search.filters.visible";
    public static final Key<StructuralSearchDialog> STRUCTURAL_SEARCH_DIALOG;
    public static final Key<String> STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID;
    public static final Key<Runnable> STRUCTURAL_SEARCH_ERROR_CALLBACK;
    private static final Key<Configuration> p;
    private final SearchContext g;
    Editor myEditor;
    boolean myReplace;
    Configuration myConfiguration;
    @NonNls
    LanguageFileType myFileType;
    Language myDialect;
    PatternContext myPatternContext;
    final List<RangeHighlighter> myRangeHighlighters;
    private final DocumentListener b;
    private final Alarm s;
    private boolean l;
    private final boolean i;
    private boolean q;
    JCheckBox myRecursive;
    private JCheckBox h;
    private JCheckBox e;
    private JCheckBox a;
    private JCheckBox k;
    FileTypeSelector myFileTypesComboBox;
    ActionToolbarImpl myOptionsToolbar;
    EditorTextField mySearchCriteriaEdit;
    EditorTextField myReplaceCriteriaEdit;
    OnePixelSplitter mySearchEditorPanel;
    FilterPanel myFilterPanel;
    private LinkComboBox o;
    private ScopePanel d;
    private JCheckBox n;
    JComponent myReplacePanel;
    Balloon myBalloon;
    private static final long w;

    public StructuralSearchDialog(SearchContext searchContext, boolean replace) {
        this(searchContext, replace, false);
    }

    public StructuralSearchDialog(@NotNull SearchContext searchContext, boolean replace, boolean editConfigOnly) {
        long l2 = w ^ 0x3C66661944F7L;
        if (searchContext == null) {
            StructuralSearchDialog.a(0);
        }
        super(searchContext.getProject(), true);
        this.myFileType = StructuralSearchUtil.getDefaultFileType();
        this.myDialect = null;
        this.myPatternContext = null;
        this.myRangeHighlighters = new SmartList();
        this.b = new DocumentListener(){
            final Runnable runnable = () -> ReadAction.nonBlocking(() -> StructuralSearchDialog.this.addMatchHighlights()).withDocumentsCommitted(StructuralSearchDialog.this.m()).expireWith(StructuralSearchDialog.this.getDisposable()).coalesceBy(new Object[]{this}).submit((Executor)AppExecutorUtil.getAppExecutorService());
            private static final long a = lb.a(-1612193647867597663L, 7751053512034581301L, MethodHandles.lookup().lookupClass()).a(268163949187699L);

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.a(0);
                }
                if (StructuralSearchDialog.this.s.isDisposed()) {
                    return;
                }
                StructuralSearchDialog.this.s.cancelRequest(this.runnable);
                StructuralSearchDialog.this.s.addRequest(this.runnable, 100);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x60E7C361F9C6L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$1", "documentChanged"));
            }
        };
        this.myBalloon = null;
        if (!editConfigOnly) {
            this.setModal(false);
            this.setOKButtonText(FindBundle.message((String)"find.dialog.find.button", (Object[])new Object[0]));
        }
        this.myReplace = replace;
        this.i = editConfigOnly;
        this.g = searchContext;
        this.myEditor = searchContext.getEditor();
        this.c();
        FileEditorManagerListener fileEditorManagerListener = new FileEditorManagerListener(){
            FileEditor myNewEditor;
            final Runnable runnable = () -> {
                StructuralSearchDialog.this.o();
                StructuralSearchDialog.this.removeMatchHighlights();
                if (this.myNewEditor instanceof TextEditor) {
                    StructuralSearchDialog.this.myEditor = ((TextEditor)this.myNewEditor).getEditor();
                    StructuralSearchDialog.this.addMatchHighlights();
                    StructuralSearchDialog.this.c();
                } else {
                    StructuralSearchDialog.this.myEditor = null;
                }
            };
            private static final long a = lb.a(1238529688377626965L, 5295087072070888629L, MethodHandles.lookup().lookupClass()).a(155747119810084L);

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    2.a(0);
                }
                if (StructuralSearchDialog.this.s.isDisposed()) {
                    return;
                }
                StructuralSearchDialog.this.s.cancelRequest(this.runnable);
                this.myNewEditor = event.getNewEditor();
                StructuralSearchDialog.this.s.addRequest(this.runnable, 100);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x41A1BBBAEE8AL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$2", "selectionChanged"));
            }
        };
        this.m().getMessageBus().connect(this.getDisposable()).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)fileEditorManagerListener);
        this.myConfiguration = this.a((Configuration)null);
        this.setTitle(this.getDefaultTitle());
        this.init();
        this.s = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        ProjectManager.getInstance().addProjectManagerListener(this.m(), (ProjectManagerListener)this);
    }

    private void c() {
        if (this.myEditor != null) {
            this.myEditor.getDocument().addDocumentListener(this.b);
        }
    }

    private void o() {
        if (this.myEditor != null) {
            this.myEditor.getDocument().removeDocumentListener(this.b);
        }
    }

    public void setUseLastConfiguration(boolean useLastConfiguration) {
        this.l = useLastConfiguration;
    }

    private EditorTextField a(boolean bl2) {
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        assert (structuralSearchProfile != null);
        Document document = UIUtil.createDocument(this.m(), this.myFileType, this.myDialect, this.myPatternContext, "", structuralSearchProfile);
        document.addDocumentListener((DocumentListener)this, this.myDisposable);
        document.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)(this.myPatternContext == null ? "" : this.myPatternContext.getId()));
        MyEditorTextField myEditorTextField = new MyEditorTextField(document, bl2);
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        myEditorTextField.setFont(editorColorsScheme.getFont(EditorFontType.PLAIN));
        myEditorTextField.setPreferredSize(new Dimension(550, 150));
        myEditorTextField.setMinimumSize(new Dimension(200, 50));
        return myEditorTextField;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            StructuralSearchDialog.a(1);
        }
        this.initiateValidation();
    }

    void initiateValidation() {
        if (this.s.isDisposed()) {
            return;
        }
        this.s.cancelAllRequests();
        this.s.addRequest(() -> {
            boolean bl2 = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                try {
                    CompiledPattern compiledPattern = this.j();
                    this.h();
                    JRootPane jRootPane = this.getRootPane();
                    if (jRootPane == null) {
                        return;
                    }
                    this.i();
                    if (compiledPattern != null) {
                        this.addMatchHighlights();
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        this.a(this.myConfiguration.getMatchOptions());
                        this.getOKAction().setEnabled(compiledPattern != null);
                    }, ModalityState.stateForComponent((Component)jRootPane));
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw processCanceledException;
                }
                catch (RuntimeException runtimeException) {
                    Logger.getInstance(StructuralSearchDialog.class).error((Throwable)runtimeException);
                }
            });
            if (!bl2) {
                this.initiateValidation();
            }
        }, 100);
    }

    private void i() {
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        CompiledPattern compiledPattern = PatternCompiler.compilePattern(this.m(), matchOptions, false, false);
        ApplicationManager.getApplication().invokeLater(() -> {
            long l2 = w ^ 0x3F3B3625AB14L;
            if (compiledPattern != null) {
                SubstitutionShortInfoHandler.updateEditorInlays(this.mySearchCriteriaEdit.getEditor());
                if (this.myReplace) {
                    SubstitutionShortInfoHandler.updateEditorInlays(this.myReplaceCriteriaEdit.getEditor());
                }
                this.myFilterPanel.setCompiledPattern(compiledPattern);
            }
            if (!this.myFilterPanel.isInitialized()) {
                this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint("__context__", this.myConfiguration));
            }
            this.myFilterPanel.setValid(compiledPattern != null);
        }, ModalityState.stateForComponent((Component)this.myFilterPanel.getComponent()));
    }

    private Configuration a(Configuration configuration) {
        if (this.myReplace) {
            return configuration == null ? new ReplaceConfiguration(StructuralSearchDialog.getUserDefined(), StructuralSearchDialog.getUserDefined()) : new ReplaceConfiguration(configuration);
        }
        return configuration == null ? new SearchConfiguration(StructuralSearchDialog.getUserDefined(), StructuralSearchDialog.getUserDefined()) : new SearchConfiguration(configuration);
    }

    private void k() {
        Object object;
        Object object2;
        Editor editor = this.myEditor;
        if (editor != null && (object2 = (object = editor.getSelectionModel()).getSelectedText()) != null) {
            if (this.loadConfiguration((String)object2)) {
                return;
            }
            String string = ((String)object2).trim();
            this.a(string.trim(), this.mySearchCriteriaEdit);
            if (this.myReplace) {
                this.a(string, this.myReplaceCriteriaEdit);
            }
            this.d.setScopesFromContext();
            ApplicationManager.getApplication().invokeLater(() -> this.e());
            return;
        }
        object = (Configuration)this.m().getUserData(p);
        if (object != null) {
            this.loadConfiguration((Configuration)object);
        } else {
            object2 = ConfigurationManager.getInstance(this.m()).getMostRecentConfiguration();
            if (object2 != null) {
                this.loadConfiguration((Configuration)object2);
            }
        }
    }

    private void a(String string, EditorTextField editorTextField) {
        long l2 = w ^ 0x23350220D587L;
        editorTextField.setText(string);
        editorTextField.selectAll();
        Project project = this.m();
        Document document = editorTextField.getDocument();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.commitDocument(document);
        PsiFile psiFile = psiDocumentManager.getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)"Adjust line indent", (String)"Structural Search", () -> CodeStyleManager.getInstance((Project)project).adjustLineIndent(psiFile, new TextRange(0, document.getTextLength())), (PsiFile[])new PsiFile[]{psiFile});
    }

    private void b() {
        if (this.myReplace) {
            new ReplaceCommand(this.myConfiguration, this.g).startSearching();
        } else {
            new SearchCommand(this.myConfiguration, this.g).startSearching();
        }
    }

    @NotNull
    String getDefaultTitle() {
        long l2 = w ^ 0x46B819FAB2C8L;
        String string = this.myReplace ? SSRBundle.message("structural.replace.title", new Object[0]) : SSRBundle.message("structural.search.title", new Object[0]);
        if (string == null) {
            StructuralSearchDialog.a(2);
        }
        return string;
    }

    protected JComponent createCenterPanel() {
        long l2 = w ^ 0x335B6EA96856L;
        this.mySearchEditorPanel = new OnePixelSplitter(false, 1.0f);
        this.mySearchEditorPanel.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
        this.mySearchCriteriaEdit = this.a(false);
        this.mySearchEditorPanel.setFirstComponent((JComponent)this.mySearchCriteriaEdit);
        JPanel jPanel = new JPanel(new BorderLayout());
        Color color = UIManager.getColor("Borders.ContrastBorderColor");
        jPanel.setBorder(IdeBorderFactory.createBorder((Color)color));
        jPanel.add((Component)this.mySearchEditorPanel, "Center");
        this.myReplacePanel = this.a();
        this.myReplacePanel.setVisible(this.myReplace);
        this.d = new ScopePanel(this.m(), this.myDisposable);
        if (!this.i) {
            this.d.setRecentDirectories(FindInProjectSettings.getInstance((Project)this.m()).getRecentDirectories());
            this.d.setScopeConsumer((NullableConsumer<? super SearchScope>)((NullableConsumer)searchScope -> this.initiateValidation()));
        } else {
            this.d.setVisible(false);
        }
        this.myFilterPanel = new FilterPanel(this.m(), StructuralSearchUtil.getProfileByFileType(this.myFileType), this.getDisposable());
        this.myFilterPanel.setConstraintChangedCallback(() -> this.initiateValidation());
        this.myFilterPanel.getComponent().setMinimumSize(new Dimension(300, 50));
        this.mySearchEditorPanel.setSecondComponent(this.myFilterPanel.getComponent());
        JLabel jLabel = new JLabel(SSRBundle.message("search.target.label", new Object[0]));
        this.o = new LinkComboBox(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.o.setItemConsumer((NullableConsumer<? super String>)((NullableConsumer)string -> {
            MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
            for (String string2 : matchOptions.getVariableConstraintNames()) {
                matchOptions.getVariableConstraint(string2).setPartOfSearchResults(string2.equals(string));
            }
            this.initiateValidation();
        }));
        JPanel jPanel2 = new JPanel(null);
        GroupLayout groupLayout = new GroupLayout(jPanel2);
        jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addComponent(jPanel).addComponent(this.myReplacePanel).addComponent(this.d).addGroup(groupLayout.createSequentialGroup().addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent((Component)((Object)this.o), -2, -1, -2)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addComponent(jPanel).addGap(8).addComponent(this.myReplacePanel).addComponent(this.d, -2, -1, -2).addGap(16).addGroup(groupLayout.createParallelGroup().addComponent(jLabel).addComponent((Component)((Object)this.o), -2, -1, -2)));
        return jPanel2;
    }

    private JComponent a() {
        long l2 = w ^ 0x1A0F74E8FB68L;
        JLabel jLabel = new JLabel(SSRBundle.message("replacement.template.label", new Object[0]));
        this.e = new JCheckBox(SSRBundle.message("shorten.fully.qualified.names.checkbox", new Object[0]));
        this.a = new JCheckBox(SSRBundle.message("reformat.checkbox", new Object[0]));
        this.k = new JCheckBox(SSRBundle.message("use.static.import.checkbox", new Object[0]));
        OnePixelSplitter onePixelSplitter = new OnePixelSplitter(false, 1.0f);
        onePixelSplitter.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
        this.myReplaceCriteriaEdit = this.a(true);
        onePixelSplitter.setFirstComponent((JComponent)this.myReplaceCriteriaEdit);
        JPanel jPanel = new JPanel(new BorderLayout());
        Color color = UIManager.getColor("Borders.ContrastBorderColor");
        jPanel.setBorder(IdeBorderFactory.createBorder((Color)color));
        jPanel.add((Component)onePixelSplitter, "Center");
        JPanel jPanel2 = new JPanel(null);
        GroupLayout groupLayout = new GroupLayout(jPanel2);
        jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 28, 28).addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, Integer.MAX_VALUE).addComponent(this.e).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.a).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.k)).addComponent(jPanel));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(this.e).addComponent(this.a).addComponent(this.k)).addGap(4).addComponent(jPanel));
        return jPanel2;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        Object object;
        long l2 = w ^ 0x79435E51D231L;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(new AnAction[]{new DumbAwareAction(SSRBundle.messagePointer("history.button", new Object[0]), SSRBundle.messagePointer("history.button.description", new Object[0]), AllIcons.Actions.SearchWithHistory){
            private static final long a = lb.a(-5474350528191406454L, 3542301050027199515L, MethodHandles.lookup().lookupClass()).a(189541076664351L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                Object object;
                if (e10 == null) {
                    3.a(0);
                }
                if (!((object = e10.getInputEvent().getSource()) instanceof Component)) {
                    return;
                }
                JBPopupFactory.getInstance().createPopupChooserBuilder(ConfigurationManager.getInstance(StructuralSearchDialog.this.m()).getHistoryConfigurations()).setRenderer((ListCellRenderer)((Object)new ConfigurationCellRenderer())).setItemChosenCallback(configuration -> StructuralSearchDialog.this.loadConfiguration((Configuration)configuration)).setSelectionMode(0).createPopup().showUnderneathOf((Component)object);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x2C76F64AED15L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$3", "actionPerformed"));
            }
        }});
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbarImpl actionToolbarImpl = (ActionToolbarImpl)actionManager.createActionToolbar("EditorToolbar", (ActionGroup)defaultActionGroup, true);
        actionToolbarImpl.setLayoutPolicy(0);
        JLabel jLabel = new JLabel(SSRBundle.message("search.template", new Object[0]));
        UIUtil.installCompleteMatchInfo(jLabel, () -> this.myConfiguration, string -> this.showFilterPanel((String)string));
        this.myRecursive = new JCheckBox(SSRBundle.message("recursive.matching.checkbox", new Object[0]), true);
        this.myRecursive.setVisible(!this.myReplace);
        this.myRecursive.addActionListener(actionEvent -> this.initiateValidation());
        this.h = new JCheckBox(FindBundle.message((String)"find.popup.case.sensitive", (Object[])new Object[0]), true);
        this.h.addActionListener(actionEvent -> this.initiateValidation());
        this.myFileType = UIUtil.detectFileType(this.g);
        this.myDialect = this.myFileType.getLanguage();
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        if (structuralSearchProfile != null && !(object = structuralSearchProfile.getPatternContexts()).isEmpty()) {
            this.myPatternContext = object.get(0);
        }
        this.myFileTypesComboBox = new FileTypeSelector();
        this.myFileTypesComboBox.setMinimumAndPreferredWidth(200);
        this.myFileTypesComboBox.setSelectedItem(this.myFileType, this.myDialect, this.myPatternContext);
        this.myFileTypesComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e10) {
                if (e10.getStateChange() == 1) {
                    FileTypeInfo fileTypeInfo = StructuralSearchDialog.this.myFileTypesComboBox.getSelectedItem();
                    if (fileTypeInfo == null) {
                        return;
                    }
                    StructuralSearchDialog.this.myFileType = fileTypeInfo.getFileType();
                    StructuralSearchDialog.this.myDialect = fileTypeInfo.getDialect();
                    StructuralSearchDialog.this.myPatternContext = fileTypeInfo.getContext();
                    String string = StructuralSearchDialog.this.myPatternContext == null ? "" : StructuralSearchDialog.this.myPatternContext.getId();
                    StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
                    assert (structuralSearchProfile != null);
                    Document document = UIUtil.createDocument(StructuralSearchDialog.this.m(), StructuralSearchDialog.this.myFileType, StructuralSearchDialog.this.myDialect, StructuralSearchDialog.this.myPatternContext, StructuralSearchDialog.this.mySearchCriteriaEdit.getText(), structuralSearchProfile);
                    document.addDocumentListener((DocumentListener)StructuralSearchDialog.this, StructuralSearchDialog.this.myDisposable);
                    StructuralSearchDialog.this.mySearchCriteriaEdit.setNewDocumentAndFileType((FileType)StructuralSearchDialog.this.myFileType, document);
                    document.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)string);
                    Document document2 = UIUtil.createDocument(StructuralSearchDialog.this.m(), StructuralSearchDialog.this.myFileType, StructuralSearchDialog.this.myDialect, StructuralSearchDialog.this.myPatternContext, StructuralSearchDialog.this.myReplaceCriteriaEdit.getText(), structuralSearchProfile);
                    document2.addDocumentListener((DocumentListener)StructuralSearchDialog.this, StructuralSearchDialog.this.myDisposable);
                    StructuralSearchDialog.this.myReplaceCriteriaEdit.setNewDocumentAndFileType((FileType)StructuralSearchDialog.this.myFileType, document2);
                    document2.putUserData(STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)string);
                    StructuralSearchDialog.this.myFilterPanel.setProfile(structuralSearchProfile);
                    StructuralSearchDialog.this.initiateValidation();
                }
            }
        });
        object = new JLabel(SSRBundle.message("search.dialog.file.type.label", new Object[0]));
        ((JLabel)object).setLabelFor((Component)((Object)this.myFileTypesComboBox));
        DefaultActionGroup defaultActionGroup2 = new DefaultActionGroup();
        defaultActionGroup2.add((AnAction)new DumbAwareAction(SSRBundle.message("save.template.text.button", new Object[0])){
            private static final long a = lb.a(-7459838347167356797L, -8905747285182629557L, MethodHandles.lookup().lookupClass()).a(270925994637596L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    5.a(0);
                }
                ConfigurationManager.getInstance(StructuralSearchDialog.this.m()).showSaveTemplateAsDialog(StructuralSearchDialog.this.getConfiguration());
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x720F76580E84L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$5", "actionPerformed"));
            }
        });
        if (Registry.is((String)"ssr.separate.inspections")) {
            defaultActionGroup2.add((AnAction)new DumbAwareAction(SSRBundle.message("save.inspection.action.text", new Object[0])){
                private static final long a = lb.a(9030820305659361390L, 2011175698468555080L, MethodHandles.lookup().lookupClass()).a(272322527878143L);

                public void actionPerformed(@NotNull AnActionEvent e10) {
                    Project project;
                    if (e10 == null) {
                        6.a(0);
                    }
                    if ((project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)((Object)StructuralSearchDialog.this.myFileTypesComboBox)))) == null) {
                        return;
                    }
                    InspectionProfileImpl inspectionProfileImpl = InspectionProfileManager.getInstance((Project)project).getCurrentProfile();
                    StructuralSearchProfileActionProvider.createNewInspection(StructuralSearchDialog.this.getConfiguration(), inspectionProfileImpl, project);
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x362759D5CB76L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$6", "actionPerformed"));
                }
            });
        }
        defaultActionGroup2.addSeparator();
        defaultActionGroup2.addAll(new AnAction[]{new CopyConfigurationAction(this), new PasteConfigurationAction(this), new DumbAwareAction(SSRBundle.message("copy.existing.template.button", new Object[0])){
            private static final long a = lb.a(-5845243468658576851L, -8006330390970783560L, MethodHandles.lookup().lookupClass()).a(231754312999870L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                SelectTemplateDialog selectTemplateDialog;
                if (e10 == null) {
                    7.a(0);
                }
                if (!(selectTemplateDialog = new SelectTemplateDialog(StructuralSearchDialog.this.m(), false, StructuralSearchDialog.this.myReplace)).showAndGet()) {
                    return;
                }
                Configuration[] configurationArray = selectTemplateDialog.getSelectedConfigurations();
                if (configurationArray.length == 1) {
                    StructuralSearchDialog.this.loadConfiguration(configurationArray[0]);
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x2E7E30FF6094L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$7", "actionPerformed"));
            }
        }, Separator.getInstance(), new SwitchAction()});
        defaultActionGroup2.setPopup(true);
        Presentation presentation = defaultActionGroup2.getTemplatePresentation();
        presentation.setIcon(AllIcons.General.Settings);
        presentation.setText(SSRBundle.message("tools.button", new Object[0]));
        DumbAwareToggleAction dumbAwareToggleAction = new DumbAwareToggleAction(SSRBundle.message("filter.button", new Object[0]), SSRBundle.message("filter.button.description", new Object[0]), AllIcons.General.Filter){
            private static final long a = lb.a(1747201228085653465L, 7566383163257607123L, MethodHandles.lookup().lookupClass()).a(210827948499438L);

            public boolean isSelected(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    8.a(0);
                }
                return StructuralSearchDialog.this.isFilterPanelVisible();
            }

            public void setSelected(@NotNull AnActionEvent e10, boolean state) {
                if (e10 == null) {
                    8.a(1);
                }
                StructuralSearchDialog.this.setFilterPanelVisible(state);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x2DB3493D7099L;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$8";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        DefaultActionGroup defaultActionGroup3 = new DefaultActionGroup(new AnAction[]{dumbAwareToggleAction, defaultActionGroup2});
        this.myOptionsToolbar = (ActionToolbarImpl)actionManager.createActionToolbar("EditorToolbar", (ActionGroup)defaultActionGroup3, true);
        this.myOptionsToolbar.setLayoutPolicy(0);
        this.myOptionsToolbar.setForceMinimumSize(true);
        JPanel jPanel = new JPanel(null);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setHonorsVisibility(true);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent((Component)actionToolbarImpl, -2, -1, -2).addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, Integer.MAX_VALUE).addComponent(this.myRecursive).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent(this.h).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 15, 15).addComponent((Component)object).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 5, 5).addComponent((Component)((Object)this.myFileTypesComboBox), 125, -1, -2).addComponent((Component)this.myOptionsToolbar, -2, -1, -2));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)actionToolbarImpl).addComponent(jLabel).addComponent(this.myRecursive).addComponent(this.h).addComponent((Component)object).addComponent((Component)((Object)this.myFileTypesComboBox)).addComponent((Component)this.myOptionsToolbar));
        return jPanel;
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        long l2 = w ^ 0x2322FFD62BA7L;
        if (this.i) {
            return null;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.n = new JCheckBox(SSRBundle.message("open.in.new.tab.checkbox", new Object[0]));
        this.n.setSelected(FindSettings.getInstance().isShowResultsInSeparateView());
        jPanel.add((Component)this.n, "East");
        return jPanel;
    }

    private Project m() {
        return this.g.getProject();
    }

    @Nullable
    public Point getInitialLocation() {
        Cloneable cloneable;
        long l2 = w ^ 0x54DFCF2528D7L;
        DimensionService dimensionService = DimensionService.getInstance();
        Dimension dimension = dimensionService.getSize(this.myReplace ? t : r, this.m());
        if (dimension != null) {
            this.setSize(dimension.width, this.i ? dimension.height - this.d.getPreferredSize().height : dimension.height);
        } else {
            this.pack();
            cloneable = dimensionService.getSize(this.myReplace ? r : t, this.m());
            if (cloneable != null) {
                this.setSize(cloneable.width, this.getSize().height);
            }
        }
        if (this.i) {
            return super.getInitialLocation();
        }
        cloneable = dimensionService.getLocation(r, this.m());
        return cloneable == null ? super.getInitialLocation() : cloneable;
    }

    public void show() {
        long l2 = w ^ 0x2C1A6B0D80C8L;
        StructuralSearchPlugin.getInstance(this.m()).setDialog(this);
        if (!this.l) {
            this.k();
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        this.setFilterPanelVisible(propertiesComponent.getBoolean(j, true));
        super.show();
    }

    private void e() {
        long l2 = w ^ 0x35475809116CL;
        if (!Registry.is((String)"ssr.template.from.selection.builder")) {
            return;
        }
        Document document = this.mySearchCriteriaEdit.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.m()).getPsiFile(document);
        assert (psiFile != null);
        TemplateBuilder templateBuilder = new StructuralSearchTemplateBuilder(psiFile).buildTemplate();
        WriteCommandAction.runWriteCommandAction((Project)this.m(), (String)"Live search template builder", (String)"Structural Search", () -> templateBuilder.run(Objects.requireNonNull(this.mySearchCriteriaEdit.getEditor()), true), (PsiFile[])new PsiFile[0]);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchCriteriaEdit;
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.removeMatchHighlights();
    }

    protected void doOKAction() {
        FindSettings findSettings;
        long l2 = w ^ 0x49139EF290D4L;
        this.q = true;
        this.removeMatchHighlights();
        CompiledPattern compiledPattern = this.j();
        this.q = false;
        if (compiledPattern == null) {
            return;
        }
        this.s.cancelAllRequests();
        this.myConfiguration.removeUnusedVariables();
        super.doOKAction();
        if (this.i) {
            return;
        }
        SearchScope searchScope = this.d.getScope();
        if (searchScope instanceof GlobalSearchScopesCore.DirectoryScope) {
            findSettings = (GlobalSearchScopesCore.DirectoryScope)searchScope;
            FindInProjectSettings.getInstance((Project)this.m()).addDirectory(findSettings.getDirectory().getPresentableUrl());
        }
        findSettings = FindSettings.getInstance();
        findSettings.setShowResultsInSeparateView(this.n.isSelected());
        try {
            ConfigurationManager.getInstance(this.m()).addHistoryConfiguration(this.myConfiguration);
            this.b();
        }
        catch (MalformedPatternException malformedPatternException) {
            this.reportMessage(SSRBundle.message("this.pattern.is.malformed.message", malformedPatternException.getMessage()), true, (JComponent)this.mySearchCriteriaEdit);
        }
    }

    public Configuration getConfiguration() {
        this.g();
        return this.myConfiguration.copy();
    }

    private CompiledPattern j() {
        long l2 = w ^ 0x30D4BFE1B750L;
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        Project project = this.m();
        try {
            CompiledPattern compiledPattern = PatternCompiler.compilePattern(project, matchOptions, true, !this.i);
            this.reportMessage(null, false, (JComponent)this.mySearchCriteriaEdit);
            return compiledPattern;
        }
        catch (MalformedPatternException malformedPatternException) {
            String string;
            this.removeMatchHighlights();
            String string2 = StringUtil.isEmpty((String)matchOptions.getSearchPattern()) ? null : (string = SSRBundle.message("this.pattern.is.malformed.message", malformedPatternException.getMessage() != null ? malformedPatternException.getMessage() : ""));
            if (!malformedPatternException.isErrorElement || !Registry.is((String)"ssr.in.editor.problem.highlighting")) {
                this.reportMessage(string, true, (JComponent)this.mySearchCriteriaEdit);
            }
            return null;
        }
        catch (UnsupportedPatternException unsupportedPatternException) {
            this.removeMatchHighlights();
            this.reportMessage(SSRBundle.message("this.pattern.is.unsupported.message", unsupportedPatternException.getMessage()), true, (JComponent)this.mySearchCriteriaEdit);
            return null;
        }
        catch (NoMatchFoundException noMatchFoundException) {
            this.removeMatchHighlights();
            this.reportMessage(noMatchFoundException.getMessage(), false, this.d);
            return null;
        }
    }

    private void h() {
        block4: {
            long l2 = w ^ 0x1CEC2A3145F4L;
            if (!this.myReplace) {
                return;
            }
            try {
                Replacer.checkReplacementPattern(this.m(), this.myConfiguration.getReplaceOptions());
                this.reportMessage(null, false, (JComponent)this.myReplaceCriteriaEdit);
            }
            catch (UnsupportedPatternException unsupportedPatternException) {
                this.reportMessage(SSRBundle.message("unsupported.replacement.pattern.message", unsupportedPatternException.getMessage()), true, (JComponent)this.myReplaceCriteriaEdit);
            }
            catch (MalformedPatternException malformedPatternException) {
                if (malformedPatternException.isErrorElement && Registry.is((String)"ssr.in.editor.problem.highlighting")) break block4;
                this.reportMessage(SSRBundle.message("malformed.replacement.pattern.message", malformedPatternException.getMessage()), true, (JComponent)this.myReplaceCriteriaEdit);
            }
        }
    }

    void removeMatchHighlights() {
        if (this.i) {
            return;
        }
        Editor editor = this.myEditor;
        if (editor == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project = this.m();
            if (project.isDisposed()) {
                return;
            }
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
            for (RangeHighlighter rangeHighlighter : this.myRangeHighlighters) {
                highlightManager.removeSegmentHighlighter(editor, rangeHighlighter);
            }
            WindowManager.getInstance().getStatusBar(project).setInfo("");
            this.myRangeHighlighters.clear();
        });
    }

    void addMatchHighlights() {
        long l2 = w ^ 0x5AE002730D41L;
        if (this.i) {
            return;
        }
        Project project = this.m();
        Editor editor = this.myEditor;
        if (editor == null) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return;
        }
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        matchOptions.setScope((SearchScope)new LocalSearchScope((PsiElement)psiFile, IdeBundle.message((String)"scope.current.file", (Object[])new Object[0])));
        CollectingMatchResultSink collectingMatchResultSink = new CollectingMatchResultSink();
        try {
            new Matcher(project, matchOptions).findMatches(collectingMatchResultSink);
            List<MatchResult> list2 = collectingMatchResultSink.getMatches();
            this.removeMatchHighlights();
            this.a(list2, editor, psiFile, list2.size() + " results found in current file");
        }
        catch (StructuralSearchException structuralSearchException) {
            this.reportMessage(structuralSearchException.getMessage().replace("a3cd264774bf4efb9ab609b250c5165c", ""), true, (JComponent)this.mySearchCriteriaEdit);
            this.removeMatchHighlights();
        }
    }

    private void a(@NotNull List<MatchResult> list2, @NotNull Editor editor, @NotNull PsiFile psiFile, @Nullable String string) {
        if (list2 == null) {
            StructuralSearchDialog.a(3);
        }
        if (editor == null) {
            StructuralSearchDialog.a(4);
        }
        if (psiFile == null) {
            StructuralSearchDialog.a(5);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            long l2 = w ^ 0x3DA424E80818L;
            Project project = this.m();
            if (project.isDisposed()) {
                return;
            }
            if (!list2.isEmpty()) {
                EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
                TextAttributes textAttributes = editorColorsScheme.getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
                HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
                for (MatchResult matchResult : list2) {
                    PsiElement psiElement = matchResult.getMatch();
                    if (psiElement == null || psiElement.getContainingFile() != psiFile) continue;
                    int n2 = -1;
                    int n3 = -1;
                    if ("__multi_line__".equals(matchResult.getName())) {
                        for (MatchResult matchResult2 : matchResult.getChildren()) {
                            int n4;
                            TextRange textRange = matchResult2.getMatch().getTextRange();
                            int n5 = textRange.getStartOffset();
                            if (n2 == -1 || n2 > n5) {
                                n2 = n5;
                            }
                            if (n3 >= (n4 = textRange.getEndOffset())) continue;
                            n3 = n4;
                        }
                    } else {
                        TextRange textRange = psiElement.getTextRange();
                        n2 = textRange.getStartOffset();
                        n3 = textRange.getEndOffset();
                    }
                    highlightManager.addRangeHighlight(editor, n2, n3, textAttributes, false, this.myRangeHighlighters);
                }
                HighlightHandlerBase.setupFindModel((Project)project);
            }
            WindowManager.getInstance().getStatusBar(project).setInfo(string);
        });
    }

    void reportMessage(@Nullable String message, boolean error, @NotNull JComponent component) {
        if (component == null) {
            StructuralSearchDialog.a(6);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            long l2 = w ^ 0x4ADDA94FC3CCL;
            if (this.myBalloon != null) {
                this.myBalloon.hide();
            }
            component.putClientProperty("JComponent.outline", !error || message == null ? null : "error");
            component.repaint();
            if (message == null) {
                return;
            }
            this.myBalloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, error ? MessageType.ERROR : MessageType.WARNING, null).setHideOnFrameResize(false).createBalloon();
            if (component != this.d) {
                this.myBalloon.show(new RelativePoint((Component)component, new Point(component.getWidth() / 2, component.getHeight())), Balloon.Position.below);
            } else {
                this.myBalloon.show(new RelativePoint((Component)component, new Point(component.getWidth() / 2, 0)), Balloon.Position.above);
            }
            this.myBalloon.showInCenterOf(component);
            Disposer.register((Disposable)this.myDisposable, (Disposable)this.myBalloon);
        }, ModalityState.stateForComponent((Component)component));
    }

    void securityCheck() {
        long l2 = w ^ 0x4130A1B8DC43L;
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        int n2 = 0;
        for (String object : matchOptions.getVariableConstraintNames()) {
            MatchVariableConstraint matchVariableConstraint = matchOptions.getVariableConstraint(object);
            if (matchVariableConstraint.getScriptCodeConstraint().length() <= 2) continue;
            ++n2;
        }
        ReplaceOptions replaceOptions = this.myConfiguration.getReplaceOptions();
        if (replaceOptions != null) {
            for (ReplacementVariableDefinition replacementVariableDefinition : replaceOptions.getVariableDefinitions()) {
                if (replacementVariableDefinition.getScriptCodeConstraint().length() <= 2) continue;
                ++n2;
            }
        }
        if (n2 > 0) {
            UIUtil.SSR_NOTIFICATION_GROUP.createNotification(NotificationType.WARNING).setTitle(SSRBundle.message("import.template.script.warning.title", new Object[0])).setContent(SSRBundle.message("import.template.script.warning", ApplicationNamesInfo.getInstance().getFullProductName(), n2)).notify(this.g.getProject());
        }
    }

    public void showFilterPanel(String variableName) {
        this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(variableName, this.myConfiguration));
        this.setFilterPanelVisible(true);
        this.myConfiguration.setCurrentVariableName(variableName);
    }

    void setFilterPanelVisible(boolean visible) {
        long l2 = w ^ 0x1EC06D7D5BEAL;
        if (visible) {
            if (!this.myFilterPanel.isInitialized()) {
                this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint("__context__", this.myConfiguration));
            }
            if (!this.isFilterPanelVisible()) {
                this.mySearchEditorPanel.setSecondComponent(this.myFilterPanel.getComponent());
            }
        } else if (this.isFilterPanelVisible()) {
            this.mySearchEditorPanel.setSecondComponent(null);
            this.myConfiguration.setCurrentVariableName(null);
        }
    }

    boolean isFilterPanelVisible() {
        return this.mySearchEditorPanel.getSecondComponent() != null;
    }

    private void a(MatchOptions matchOptions) {
        long l2 = w ^ 0x3D78EBD9B15EL;
        ArrayList<String> arrayList = new ArrayList<String>(matchOptions.getUsedVariableNames());
        Collections.sort(arrayList);
        arrayList.remove("__context__");
        arrayList.add(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.o.setItems(arrayList);
        if (arrayList.size() > 1) {
            this.o.setEnabled(true);
            for (String string : arrayList) {
                MatchVariableConstraint matchVariableConstraint = matchOptions.getVariableConstraint(string);
                if (matchVariableConstraint == null || !matchVariableConstraint.isPartOfSearchResults()) continue;
                this.o.setSelectedItem(string);
                return;
            }
            this.o.setSelectedItem(SSRBundle.message("complete.match.variable.name", new Object[0]));
        } else {
            this.o.setEnabled(false);
        }
    }

    boolean loadConfiguration(String text) {
        long l2 = w ^ 0x794B3A2D9FD8L;
        if (text == null) {
            return false;
        }
        try {
            Configuration configuration = ConfigurationUtil.fromXml(text);
            if (configuration == null) {
                return false;
            }
            this.loadConfiguration(configuration);
            this.securityCheck();
        }
        catch (JDOMException jDOMException) {
            this.reportMessage(SSRBundle.message("import.template.script.corrupted", new Object[0]) + '\n' + jDOMException.getMessage(), false, (JComponent)this.myOptionsToolbar);
        }
        return true;
    }

    public void loadConfiguration(Configuration configuration) {
        SearchScope searchScope;
        long l2 = w ^ 0x517738C53F81L;
        this.myConfiguration = this.a(configuration);
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        this.a(matchOptions);
        if (!this.i) {
            this.d.setScopesFromContext();
            searchScope = matchOptions.getScope();
            if (searchScope != null) {
                this.d.setScope(searchScope);
            }
        }
        UIUtil.setContent(this.mySearchCriteriaEdit, matchOptions.getSearchPattern());
        this.h.setSelected(matchOptions.isCaseSensitiveMatch());
        this.myFileTypesComboBox.setSelectedItem(matchOptions.getFileType(), matchOptions.getDialect(), matchOptions.getPatternContext());
        searchScope = this.mySearchCriteriaEdit.getEditor();
        if (searchScope != null) {
            searchScope.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        if (this.myReplace) {
            ReplaceOptions replaceOptions;
            if (configuration instanceof ReplaceConfiguration) {
                replaceOptions = configuration.getReplaceOptions();
                UIUtil.setContent(this.myReplaceCriteriaEdit, replaceOptions.getReplacement());
                this.e.setSelected(replaceOptions.isToShortenFQN());
                this.a.setSelected(replaceOptions.isToReformatAccordingToStyle());
                this.k.setSelected(replaceOptions.isToUseStaticImport());
            } else {
                UIUtil.setContent(this.myReplaceCriteriaEdit, matchOptions.getSearchPattern());
                this.e.setSelected(propertiesComponent.getBoolean(v));
                this.a.setSelected(propertiesComponent.getBoolean(f));
                this.k.setSelected(propertiesComponent.getBoolean(m));
            }
            replaceOptions = this.myReplaceCriteriaEdit.getEditor();
            if (replaceOptions != null) {
                replaceOptions.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, this.myConfiguration);
            }
            this.myRecursive.setSelected(false);
        } else if (configuration instanceof ReplaceConfiguration) {
            this.myRecursive.setSelected(propertiesComponent.getBoolean(c));
        }
    }

    private void g() {
        Object object;
        long l2 = w ^ 0x7585AE0B5B9FL;
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        if (!this.i) {
            object = this.d.getScope();
            boolean bl2 = IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(object.getDisplayName());
            matchOptions.setScope((SearchScope)(bl2 && !this.q ? GlobalSearchScope.projectScope((Project)this.m()) : object));
        }
        matchOptions.setFileType(this.myFileType);
        matchOptions.setDialect(this.myDialect);
        matchOptions.setPatternContext(this.myPatternContext);
        matchOptions.setSearchPattern(this.a(this.mySearchCriteriaEdit));
        matchOptions.setCaseSensitiveMatch(this.h.isSelected());
        if (this.myReplace) {
            object = this.myConfiguration.getReplaceOptions();
            ((ReplaceOptions)object).setReplacement(this.a(this.myReplaceCriteriaEdit));
            ((ReplaceOptions)object).setToShortenFQN(this.e.isSelected());
            ((ReplaceOptions)object).setToReformatAccordingToStyle(this.a.isSelected());
            ((ReplaceOptions)object).setToUseStaticImport(this.k.isSelected());
            matchOptions.setRecursiveSearch(false);
        } else {
            matchOptions.setRecursiveSearch(this.myRecursive.isSelected());
        }
        object = PropertiesComponent.getInstance();
        if (this.myReplace) {
            object.setValue(v, this.e.isSelected());
            object.setValue(f, this.a.isSelected());
            object.setValue(m, this.k.isSelected());
        } else {
            object.setValue(c, this.myRecursive.isSelected());
            object.setValue(u, this.h.isSelected());
        }
    }

    private String a(EditorTextField editorTextField) {
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        assert (structuralSearchProfile != null);
        Document document = editorTextField.getDocument();
        String string = (String)ReadAction.compute(() -> {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.m()).getPsiFile(document);
            assert (psiFile != null);
            return structuralSearchProfile.getCodeFragmentText(psiFile);
        });
        return string.isEmpty() ? editorTextField.getText() : string;
    }

    @Nullable
    protected final String getDimensionServiceKey() {
        return null;
    }

    public void projectClosing(@NotNull Project project) {
        if (project == null) {
            StructuralSearchDialog.a(7);
        }
        this.close(1);
    }

    public void dispose() {
        long l2 = w ^ 0x50C7BF7AC38EL;
        this.m().putUserData(p, (Object)this.myConfiguration);
        ProjectManager.getInstance().removeProjectManagerListener(this.m(), (ProjectManagerListener)this);
        if (this.myReplace) {
            this.a(t, r);
        } else {
            this.a(r, t);
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        propertiesComponent.setValue(j, this.isFilterPanelVisible(), true);
        StructuralSearchPlugin.getInstance(this.m()).setDialog(null);
        this.s.cancelAllRequests();
        this.mySearchCriteriaEdit.removeNotify();
        this.myReplaceCriteriaEdit.removeNotify();
        this.o();
        super.dispose();
    }

    private void a(String string, String string2) {
        long l2 = w ^ 0x4FAAF0080CEL;
        if (this.i) {
            return;
        }
        Dimension dimension = this.getSize();
        DimensionService dimensionService = DimensionService.getInstance();
        Point point = this.getLocation();
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        dimensionService.setLocation(r, point, this.m());
        dimensionService.setSize(string, dimension, this.m());
        Dimension dimension2 = dimensionService.getSize(string2);
        if (dimension2 != null && dimension2.width != dimension.width) {
            dimension2.width = dimension.width;
            dimensionService.setSize(string2, dimension2, this.m());
        }
    }

    protected String getHelpId() {
        long l2 = w ^ 0xDAF8720D773L;
        return "find.structuredSearch";
    }

    public static String getUserDefined() {
        long l2 = w ^ 0x38D760C899AL;
        return SSRBundle.message("new.template.defaultname", new Object[0]);
    }

    static {
        w = lb.a(-138753619125703771L, -6505376366630327748L, MethodHandles.lookup().lookupClass()).a(1207006019526L);
        long l2 = w ^ 0x3ACC92891108L;
        STRUCTURAL_SEARCH_DIALOG = Key.create((String)"STRUCTURAL_SEARCH_DIALOG");
        STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID = Key.create((String)"STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID");
        STRUCTURAL_SEARCH_ERROR_CALLBACK = Key.create((String)"STRUCTURAL_SEARCH_ERROR_CALLBACK");
        p = Key.create((String)"STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = w ^ 0x66170E286DFCL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchResults";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTitle";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addMatchHighlights";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reportMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "projectClosing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyEditorTextField
    extends EditorTextField {
        private final boolean a;
        private static final long b = lb.a(2952282755624058502L, 4002566024763709286L, MethodHandles.lookup().lookupClass()).a(104827652133352L);

        MyEditorTextField(Document document, boolean replace) {
            super(document, StructuralSearchDialog.this.m(), (FileType)StructuralSearchDialog.this.myFileType, false, false);
            this.a = replace;
        }

        protected EditorEx createEditor() {
            EditorEx editorEx = super.createEditor();
            editorEx.setHorizontalScrollbarVisible(true);
            editorEx.setVerticalScrollbarVisible(true);
            StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
            assert (structuralSearchProfile != null);
            TemplateEditorUtil.setHighlighter((Editor)editorEx, (TemplateContextType)UIUtil.getTemplateContextType(structuralSearchProfile));
            SubstitutionShortInfoHandler.install((Editor)editorEx, string -> {
                long l2 = b ^ 0x1F05B2D24727L;
                if (string.endsWith("$replacement")) {
                    string = StringUtil.trimEnd((String)string, (String)"$replacement");
                    assert (StructuralSearchDialog.this.myConfiguration instanceof ReplaceConfiguration);
                    StructuralSearchDialog.this.myFilterPanel.initFilters(UIUtil.getOrAddReplacementVariable(string, StructuralSearchDialog.this.myConfiguration));
                } else {
                    StructuralSearchDialog.this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(string, StructuralSearchDialog.this.myConfiguration));
                }
                if (StructuralSearchDialog.this.isFilterPanelVisible()) {
                    StructuralSearchDialog.this.myConfiguration.setCurrentVariableName((String)string);
                }
            }, StructuralSearchDialog.this.myDisposable, this.a);
            editorEx.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)StructuralSearchDialog.this.myConfiguration);
            this.getDocument().putUserData(STRUCTURAL_SEARCH_ERROR_CALLBACK, () -> {
                long l2 = b ^ 0x9A613D2F66EL;
                this.putClientProperty("JComponent.outline", "error");
                this.repaint();
                StructuralSearchDialog.this.getOKAction().setEnabled(false);
                StructuralSearchDialog.this.removeMatchHighlights();
            });
            TextCompletionUtil.installCompletionHint((EditorEx)editorEx);
            editorEx.putUserData(STRUCTURAL_SEARCH_DIALOG, (Object)StructuralSearchDialog.this);
            editorEx.setEmbeddedIntoDialogWrapper(true);
            return editorEx;
        }

        protected void updateBorder(@NotNull EditorEx editor) {
            if (editor == null) {
                MyEditorTextField.a(0);
            }
            this.setupBorder(editor);
            JScrollPane jScrollPane = editor.getScrollPane();
            jScrollPane.setBorder(new ErrorBorder(jScrollPane.getBorder()));
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x7AFA912A3E32L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$MyEditorTextField", "updateBorder"));
        }
    }

    private class PasteConfigurationAction
    extends AnAction
    implements DumbAware {
        final /* synthetic */ StructuralSearchDialog this$0;
        private static final long a = lb.a(-7968126426302998732L, -8882723526602514150L, MethodHandles.lookup().lookupClass()).a(93914577079867L);

        PasteConfigurationAction(StructuralSearchDialog structuralSearchDialog) {
            long l2 = a ^ 0x34C85E0005B3L;
            this.this$0 = structuralSearchDialog;
            super(SSRBundle.messagePointer("import.template.action", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            String string;
            long l2 = a ^ 0x589E5760AACCL;
            if (e10 == null) {
                PasteConfigurationAction.a(0);
            }
            if (!this.this$0.loadConfiguration(string = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor))) {
                this.this$0.reportMessage(SSRBundle.message("no.template.found.warning", new Object[0]), false, (JComponent)this.this$0.myOptionsToolbar);
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x3D338245CD34L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$PasteConfigurationAction", "actionPerformed"));
        }
    }

    private class CopyConfigurationAction
    extends AnAction
    implements DumbAware {
        final /* synthetic */ StructuralSearchDialog this$0;
        private static final long a = lb.a(-2375206448132707794L, -6651260525564942815L, MethodHandles.lookup().lookupClass()).a(29201786279394L);

        CopyConfigurationAction(StructuralSearchDialog structuralSearchDialog) {
            long l2 = a ^ 0x27C0827D0E07L;
            this.this$0 = structuralSearchDialog;
            super(SSRBundle.messagePointer("export.template.action", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                CopyConfigurationAction.a(0);
            }
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(ConfigurationUtil.toXml(this.this$0.myConfiguration)));
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x2F6334EAA91BL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$CopyConfigurationAction", "actionPerformed"));
        }
    }

    private class SwitchAction
    extends AnAction
    implements DumbAware {
        private static final long a = lb.a(3579005725920032393L, -8585278883057790866L, MethodHandles.lookup().lookupClass()).a(54143635609648L);

        SwitchAction() {
            this.a();
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            long l2 = a ^ 0x625DB0FFAE5L;
            if (e10 == null) {
                SwitchAction.a(0);
            }
            StructuralSearchDialog.this.myReplace = !StructuralSearchDialog.this.myReplace;
            StructuralSearchDialog.this.setTitle(StructuralSearchDialog.this.getDefaultTitle());
            StructuralSearchDialog.this.myReplacePanel.setVisible(StructuralSearchDialog.this.myReplace);
            StructuralSearchDialog.this.myRecursive.setVisible(!StructuralSearchDialog.this.myReplace);
            StructuralSearchDialog.this.loadConfiguration(StructuralSearchDialog.this.myConfiguration);
            Dimension dimension = DimensionService.getInstance().getSize(StructuralSearchDialog.this.myReplace ? StructuralSearchDialog.t : StructuralSearchDialog.r);
            if (dimension != null) {
                StructuralSearchDialog.this.setSize(StructuralSearchDialog.this.getSize().width, dimension.height);
            } else {
                StructuralSearchDialog.this.pack();
            }
            this.a();
        }

        private void a() {
            long l2 = a ^ 0x29260A6F3808L;
            this.getTemplatePresentation().setText(SSRBundle.messagePointer(StructuralSearchDialog.this.myReplace ? "switch.to.search.action" : "switch.to.replace.action", new Object[0]));
            ActionManager actionManager = ActionManager.getInstance();
            ShortcutSet shortcutSet = actionManager.getAction("StructuralSearchPlugin.StructuralSearchAction").getShortcutSet();
            ShortcutSet shortcutSet2 = actionManager.getAction("StructuralSearchPlugin.StructuralReplaceAction").getShortcutSet();
            CompositeShortcutSet compositeShortcutSet = StructuralSearchDialog.this.myReplace ? new CompositeShortcutSet(new ShortcutSet[]{shortcutSet, shortcutSet2}) : new CompositeShortcutSet(new ShortcutSet[]{shortcutSet2, shortcutSet});
            this.registerCustomShortcutSet((ShortcutSet)compositeShortcutSet, StructuralSearchDialog.this.getRootPane());
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x23042B134350L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$SwitchAction", "actionPerformed"));
        }
    }

    private static class ErrorBorder
    implements Border {
        private final Border a;
        private static final long b = lb.a(3216594698744397476L, 4130624472714797027L, MethodHandles.lookup().lookupClass()).a(46591209475675L);

        ErrorBorder(Border errorBorder) {
            this.a = errorBorder;
        }

        @Override
        public void paintBorder(Component c10, Graphics g10, int x2, int y2, int width, int height) {
            long l2 = b ^ 0x4F9D9151BA69L;
            EditorTextField editorTextField = (EditorTextField)ComponentUtil.getParentOfType(EditorTextField.class, (Component)c10);
            if (editorTextField == null) {
                return;
            }
            Object object = editorTextField.getClientProperty((Object)"JComponent.outline");
            if ("error".equals(object) || "warning".equals(object)) {
                this.a.paintBorder(c10, g10, x2, y2, width, height);
            }
        }

        @Override
        public Insets getBorderInsets(Component c10) {
            return this.a.getBorderInsets(c10);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

