/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import a.g.lb;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoverageEnabledConfiguration
implements JDOMExternalizable {
    private static final Logger b;
    public static final Key<CoverageEnabledConfiguration> COVERAGE_KEY;
    @NonNls
    protected static final String COVERAGE_ENABLED_ATTRIBUTE_NAME = "enabled";
    @NonNls
    protected static final String COVERAGE_RUNNER = "runner";
    @NonNls
    protected static final String TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME = "per_test_coverage_enabled";
    @NonNls
    protected static final String SAMPLING_COVERAGE_ATTRIBUTE_NAME = "sample_coverage";
    @NonNls
    protected static final String TRACK_TEST_FOLDERS = "track_test_folders";
    private final Project h;
    private final RunConfigurationBase a;
    private boolean f = false;
    private String j;
    private CoverageRunner e;
    private boolean i = true;
    private boolean d = true;
    private boolean g = false;
    @NonNls
    protected String myCoverageFilePath;
    private CoverageSuite c;
    private static final long k;

    public CoverageEnabledConfiguration(RunConfigurationBase configuration) {
        this.a = configuration;
        this.h = configuration.getProject();
    }

    public RunConfigurationBase getConfiguration() {
        return this.a;
    }

    public boolean isCoverageEnabled() {
        return this.f;
    }

    public void setCoverageEnabled(boolean isCoverageEnabled) {
        this.f = isCoverageEnabled;
    }

    public boolean isSampling() {
        return this.d;
    }

    public void setSampling(boolean sampling) {
        this.d = sampling;
    }

    public String getRunnerId() {
        return this.j;
    }

    @Nullable
    public CoverageRunner getCoverageRunner() {
        return this.e;
    }

    public void setCoverageRunner(@Nullable CoverageRunner coverageRunner) {
        this.e = coverageRunner;
        this.j = coverageRunner != null ? coverageRunner.getId() : null;
        this.myCoverageFilePath = null;
    }

    public void coverageRunnerExtensionRemoved(@NotNull CoverageRunner runner) {
        if (runner == null) {
            CoverageEnabledConfiguration.a(0);
        }
        if (runner.getId().equals(this.j)) {
            this.e = null;
            this.myCoverageFilePath = null;
        }
    }

    public boolean isTrackPerTestCoverage() {
        return this.i;
    }

    public void setTrackPerTestCoverage(boolean collectLineInfo) {
        this.i = collectLineInfo;
    }

    public boolean isTrackTestFolders() {
        return this.g;
    }

    public void setTrackTestFolders(boolean trackTestFolders) {
        this.g = trackTestFolders;
    }

    public CoverageSuite getCurrentCoverageSuite() {
        return this.c;
    }

    public void setCurrentCoverageSuite(CoverageSuite currentCoverageSuite) {
        this.c = currentCoverageSuite;
    }

    public String getName() {
        return this.a.getName();
    }

    public boolean canHavePerTestCoverage() {
        for (CoverageEngine coverageEngine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
            if (!coverageEngine.isApplicableTo(this.a)) continue;
            return coverageEngine.canHavePerTestCoverage(this.a);
        }
        return false;
    }

    public static boolean isApplicableTo(@NotNull RunConfigurationBase runConfiguration) {
        CoverageEnabledConfiguration coverageEnabledConfiguration;
        if (runConfiguration == null) {
            CoverageEnabledConfiguration.a(1);
        }
        if ((coverageEnabledConfiguration = (CoverageEnabledConfiguration)runConfiguration.getCopyableUserData(COVERAGE_KEY)) != null) {
            return true;
        }
        for (CoverageEngine coverageEngine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
            if (!coverageEngine.isApplicableTo(runConfiguration)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static CoverageEnabledConfiguration getOrCreate(@NotNull RunConfigurationBase runConfiguration) {
        CoverageEnabledConfiguration coverageEnabledConfiguration;
        long l2 = k ^ 0x5AD78E937C9BL;
        if (runConfiguration == null) {
            CoverageEnabledConfiguration.a(2);
        }
        if ((coverageEnabledConfiguration = (CoverageEnabledConfiguration)runConfiguration.getCopyableUserData(COVERAGE_KEY)) == null) {
            for (CoverageEngine coverageEngine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
                if (!coverageEngine.isApplicableTo(runConfiguration)) continue;
                coverageEnabledConfiguration = coverageEngine.createCoverageEnabledConfiguration(runConfiguration);
                break;
            }
            b.assertTrue(coverageEnabledConfiguration != null, (Object)("Coverage enabled run configuration wasn't found for run configuration: " + runConfiguration.getName() + ", type = " + runConfiguration.getClass().getName()));
            runConfiguration.putCopyableUserData(COVERAGE_KEY, (Object)coverageEnabledConfiguration);
        }
        CoverageEnabledConfiguration coverageEnabledConfiguration2 = coverageEnabledConfiguration;
        if (coverageEnabledConfiguration2 == null) {
            CoverageEnabledConfiguration.a(3);
        }
        return coverageEnabledConfiguration2;
    }

    @Nullable
    @NonNls
    public String getCoverageFilePath() {
        if (this.myCoverageFilePath == null) {
            this.myCoverageFilePath = this.createCoverageFile();
        }
        return this.myCoverageFilePath;
    }

    public void readExternal(Element element) throws InvalidDataException {
        long l2 = k ^ 0x70FB45CBF524L;
        this.f = Boolean.parseBoolean(element.getAttributeValue(COVERAGE_ENABLED_ATTRIBUTE_NAME));
        String string = element.getAttributeValue(TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME);
        this.i = string == null || Boolean.valueOf(string) != false;
        this.d = Boolean.parseBoolean(element.getAttributeValue(SAMPLING_COVERAGE_ATTRIBUTE_NAME, "true"));
        String string2 = element.getAttributeValue(TRACK_TEST_FOLDERS);
        this.g = string2 != null && Boolean.valueOf(string2) != false;
        String string3 = element.getAttributeValue(COVERAGE_RUNNER);
        if (string3 != null) {
            this.j = string3;
            this.e = null;
            for (CoverageRunner coverageRunner : CoverageRunner.EP_NAME.getExtensionList()) {
                if (!Comparing.strEqual((String)coverageRunner.getId(), (String)this.j)) continue;
                this.e = coverageRunner;
                break;
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        long l2 = k ^ 0x1859F53E67C5L;
        if (this.f) {
            element.setAttribute(COVERAGE_ENABLED_ATTRIBUTE_NAME, String.valueOf(true));
        }
        if (!this.i) {
            element.setAttribute(TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME, String.valueOf(false));
        }
        if (!this.d) {
            element.setAttribute(SAMPLING_COVERAGE_ATTRIBUTE_NAME, String.valueOf(false));
        }
        if (this.g) {
            element.setAttribute(TRACK_TEST_FOLDERS, String.valueOf(true));
        }
        if (this.e != null) {
            element.setAttribute(COVERAGE_RUNNER, this.e.getId());
        } else if (this.j != null) {
            element.setAttribute(COVERAGE_RUNNER, this.j);
        }
    }

    @Nullable
    @NonNls
    protected String createCoverageFile() {
        long l2 = k ^ 0x7D6D76AF5107L;
        if (this.e == null) {
            return null;
        }
        String string = PathManager.getSystemPath() + File.separator + "coverage";
        String string2 = string + File.separator + FileUtil.sanitizeFileName((String)this.h.getName()) + this.coverageFileNameSeparator() + FileUtil.sanitizeFileName((String)this.a.getName()) + "." + this.e.getDataFileExtension();
        new File(string).mkdirs();
        return string2;
    }

    protected String coverageFileNameSeparator() {
        return "$";
    }

    static {
        k = lb.a(-1212801914857358868L, -337311732014020448L, MethodHandles.lookup().lookupClass()).a(124173095195277L);
        long l2 = k ^ 0x16B17112A25DL;
        b = Logger.getInstance((String)CoverageEnabledConfiguration.class.getName());
        COVERAGE_KEY = Key.create((String)"com.intellij.coverage");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = k ^ 0x575706417C2DL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = COVERAGE_RUNNER;
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/coverage/CoverageEnabledConfiguration";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/coverage/CoverageEnabledConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "coverageRunnerExtensionRemoved";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

