/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerConnector;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.registry.RegistryRuntimeTask;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntimeUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.impl.runtime.ServerTaskExecutorImpl;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.Function;
import com.intellij.util.concurrency.Semaphore;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteDockerRuntime {
    private static final Logger LOG = Logger.getInstance((String)("#" + RemoteDockerRuntime.class));
    private static final Map<Pair<DockerCloudConfiguration, Project>, RemoteDockerRuntime> myDockerRuntimeMap = new LinkedHashMap<Pair<DockerCloudConfiguration, Project>, RemoteDockerRuntime>();
    private static final Lock myDockerRuntimeMapLock = new ReentrantLock();
    private final DockerCloudConfiguration myAccount;
    @Nullable
    private final Project myProject;
    private AgentTaskExecutor myAgentTaskExecutor;
    private DockerAgent myDockerAgent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteDockerRuntime create(@NotNull DockerCloudConfiguration config, @Nullable Project project) throws ServerRuntimeException {
        RemoteDockerRuntime dockerRuntime;
        if (config == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(0);
        }
        myDockerRuntimeMapLock.lock();
        try {
            Pair key = Pair.create((Object)((Object)config), (Object)project);
            dockerRuntime = myDockerRuntimeMap.get(key);
            if (dockerRuntime == null) {
                dockerRuntime = new RemoteDockerRuntime(config, project);
                myDockerRuntimeMap.put((Pair<DockerCloudConfiguration, Project>)key, dockerRuntime);
                if (project != null) {
                    Disposer.register((Disposable)project, () -> RemoteDockerRuntime.forgetRuntime((Pair<DockerCloudConfiguration, Project>)key));
                }
            }
        }
        finally {
            myDockerRuntimeMapLock.unlock();
        }
        return dockerRuntime;
    }

    private static void forgetRuntime(Pair<DockerCloudConfiguration, Project> key) {
        myDockerRuntimeMapLock.lock();
        try {
            myDockerRuntimeMap.remove(key);
        }
        finally {
            myDockerRuntimeMapLock.unlock();
        }
    }

    private RemoteDockerRuntime(DockerCloudConfiguration account, @Nullable Project project) throws ServerRuntimeException {
        this.myAccount = account;
        this.myProject = project;
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref errorRef = Ref.create();
        new DockerConnector(account, (ServerTaskExecutor)new ServerTaskExecutorImpl()).connect(new ServerConnector.ConnectionCallback<DockerDeploymentConfiguration>(){

            public void connected(@NotNull ServerRuntimeInstance<DockerDeploymentConfiguration> serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    1.$$$reportNull$$$0(0);
                }
                DockerServerRuntimeInstance dockerServerRuntimeInstance = (DockerServerRuntimeInstance)serverRuntimeInstance;
                RemoteDockerRuntime.this.myDockerAgent = (DockerAgent)dockerServerRuntimeInstance.getAgent();
                RemoteDockerRuntime.this.myAgentTaskExecutor = dockerServerRuntimeInstance.getDockerAgentTaskExecutor();
                semaphore.up();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                errorRef.set((Object)new ServerRuntimeException(errorMessage));
                semaphore.up();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "serverRuntimeInstance";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/docker/remote/run/runtime/RemoteDockerRuntime$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "connected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        semaphore.waitFor();
        if (!errorRef.isNull()) {
            throw (ServerRuntimeException)((Object)errorRef.get());
        }
    }

    public <T> T executeAgentTask(Computable<T> computable) throws ServerRuntimeException {
        return RemoteDockerRuntimeUtil.executeAgentTask(this.myAgentTaskExecutor, computable);
    }

    public DockerAgent getAgent() {
        return this.myDockerAgent;
    }

    public AgentTaskExecutor getAgentExecutor() {
        return this.myAgentTaskExecutor;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public RemoteDockerApplicationRuntime findContainerByName(String containerName) throws ServerRuntimeException {
        return (RemoteDockerApplicationRuntime)this.createName2ContainerMapping().fun((Object)containerName);
    }

    public Function<String, RemoteDockerApplicationRuntime> createName2ContainerMapping() throws ServerRuntimeException {
        DockerAgentApplication[] applications = this.getContainers();
        return containerName -> {
            for (DockerAgentApplication application : applications) {
                if (application.getContainerNames() == null || !Arrays.stream(application.getContainerNames()).anyMatch(n -> n != null && n.startsWith("/" + containerName))) continue;
                return RemoteDockerApplicationRuntime.create(this, application);
            }
            return null;
        };
    }

    public DockerAgentApplication[] getContainers() throws ServerRuntimeException {
        return (DockerAgentApplication[])this.executeAgentTask(() -> this.getAgent().getContainers());
    }

    public DockerAgentApplication[] getImages() throws ServerRuntimeException {
        return this.getImages(null);
    }

    public DockerAgentApplication[] getImages(String label) throws ServerRuntimeException {
        return (DockerAgentApplication[])this.executeAgentTask(() -> this.getAgent().getImages(label));
    }

    public DockerAgentApplication findImageByName(String imageName) throws ServerRuntimeException {
        DockerAgentApplication[] applications;
        for (DockerAgentApplication application : applications = this.getImages()) {
            for (String imageTag : application.getImageRepoTags()) {
                if (!StringUtil.equals((CharSequence)imageTag, (CharSequence)imageName)) continue;
                return application;
            }
        }
        return null;
    }

    public void pullImage(@NotNull String imageName) throws ServerRuntimeException {
        if (imageName == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(1);
        }
        LOG.debug("Pull image {" + imageName + "}");
        try {
            this.doPullImage(imageName);
            LOG.debug("Docker image {" + imageName + "} pulled successfully");
        }
        catch (ServerRuntimeException e) {
            LOG.debug("Failed to pull docker image {" + imageName + "}", (Throwable)e);
            throw e;
        }
    }

    public CompletableFuture<BlockingQueue<byte[]>> asyncPullImage(@NotNull String imageName) {
        if (imageName == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(2);
        }
        if (this.myProject == null) {
            throw new NullPointerException();
        }
        DockerAgentRepositoryConfig repositoryConfig = RemoteDockerRuntime.forImageName(imageName);
        return this.getAgent().asyncPullImage(repositoryConfig);
    }

    public CompletableFuture<BlockingQueue<byte[]>> asyncBuildImage(@NotNull DockerAgentDeploymentConfig config) {
        if (config == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(3);
        }
        if (this.myProject == null) {
            throw new NullPointerException();
        }
        return this.getAgent().createImageBuilder().asyncBuildImage(config);
    }

    private void doPullImage(@NotNull String imageName) throws ServerRuntimeException {
        if (imageName == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(4);
        }
        final DockerAgentRepositoryConfig repositoryConfig = RemoteDockerRuntime.forImageName(imageName);
        new RegistryRuntimeTask(){

            @Override
            protected OngoingProcess doPerform(DockerAgentProgressCallback progressCallback) {
                return RemoteDockerRuntime.this.getAgent().pullImage(repositoryConfig, progressCallback);
            }
        }.performSync((ServerTaskExecutor)new ServerTaskExecutorImpl(), this.myAgentTaskExecutor, RemoteDockerRuntime.getInitialIndicatorText(imageName));
    }

    @NotNull
    private static String getInitialIndicatorText(@NotNull String imageName) {
        if (imageName == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(5);
        }
        String string = "Pulling \"" + imageName + "\" image...";
        if (string == null) {
            RemoteDockerRuntime.$$$reportNull$$$0(6);
        }
        return string;
    }

    public DockerCloudConfiguration getAccount() {
        return this.myAccount;
    }

    private static DockerAgentRepositoryConfig forImageName(String imageName) {
        DockerRepoTag repoTag = DockerRepoTag.fromString((String)imageName);
        return repoTag.toAgentRepositoryConfig();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/runtime/RemoteDockerRuntime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/runtime/RemoteDockerRuntime";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialIndicatorText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "pullImage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "asyncPullImage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "asyncBuildImage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doPullImage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInitialIndicatorText";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

