/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.pull;

import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.progress.DockerResponseItemTtyHandler;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.pull.DockerTerminalPipe;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Base64;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u0013B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u0016\u0010\r\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0010R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/pull/DockerPullToTerminal;", "Ljava/util/function/Consumer;", "Ljava/util/concurrent/BlockingQueue;", "", "pipe", "Lcom/intellij/docker/pull/DockerTerminalPipe;", "onItemWithAuxDetails", "Lkotlin/Function1;", "Lcom/intellij/docker/agent/progress/DockerResponseItem;", "", "(Lcom/intellij/docker/pull/DockerTerminalPipe;Lkotlin/jvm/functions/Function1;)V", "accept", "t", "onPullChannelAvailable", "channel", "redirectToTerminalLater", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "channelPromise", "Companion", "intellij.clouds.docker"})
public final class DockerPullToTerminal
implements Consumer<BlockingQueue<byte[]>> {
    private final DockerTerminalPipe pipe;
    private final Function1<DockerResponseItem, Unit> onItemWithAuxDetails;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void accept(@NotNull BlockingQueue<byte[]> t) {
        Intrinsics.checkParameterIsNotNull(t, (String)"t");
        this.onPullChannelAvailable(t);
    }

    @NotNull
    public final CompletableFuture<Void> redirectToTerminalLater(@NotNull CompletableFuture<BlockingQueue<byte[]>> channelPromise) {
        Intrinsics.checkParameterIsNotNull(channelPromise, (String)"channelPromise");
        CompletionStage completionStage = ((CompletableFuture)channelPromise.thenAcceptAsync((Consumer)new Consumer<BlockingQueue<byte[]>>(this){
            final /* synthetic */ DockerPullToTerminal this$0;

            public final void accept(BlockingQueue<byte[]> channel) {
                BlockingQueue<byte[]> blockingQueue = channel;
                Intrinsics.checkExpressionValueIsNotNull(blockingQueue, (String)"channel");
                DockerPullToTerminal.access$onPullChannelAvailable(this.this$0, blockingQueue);
            }
            {
                this.this$0 = dockerPullToTerminal;
            }
        }, (Executor)PooledThreadExecutor.INSTANCE)).exceptionally(new Function<Throwable, Void>(this){
            final /* synthetic */ DockerPullToTerminal this$0;

            @Nullable
            public final Void apply(Throwable failure) {
                DockerPullToTerminal.Companion.getLOG().warn(failure);
                DockerTerminalPipe dockerTerminalPipe = DockerPullToTerminal.access$getPipe$p(this.this$0);
                String string = "Operation failed: " + failure.getMessage() + ", see log for details";
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.ERROR_OUTPUT");
                dockerTerminalPipe.println(string, consoleViewContentType);
                return null;
            }
            {
                this.this$0 = dockerPullToTerminal;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"channelPromise\n      .th\u2026PUT)\n        null\n      }");
        return completionStage;
    }

    private final void onPullChannelAvailable(BlockingQueue<byte[]> channel) {
        DockerResponseItemTtyHandler handler2 = new DockerResponseItemTtyHandler(TtySink.Companion.wrap((Consumer)new Consumer<String>(this){
            final /* synthetic */ DockerPullToTerminal this$0;

            public final void accept(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                DockerTerminalPipe dockerTerminalPipe = DockerPullToTerminal.access$getPipe$p(this.this$0);
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleViewContentType, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
                dockerTerminalPipe.print(it, consoleViewContentType);
            }
            {
                this.this$0 = dockerPullToTerminal;
            }
        }));
        LOG.trace("poll: about to start");
        while (true) {
            try {
                byte[] next = channel.poll(3L, TimeUnit.SECONDS);
                if (next == null) {
                    LOG.trace("poll: nothing polled for 3 seconds");
                    continue;
                }
                byte[] byArray = next;
                boolean bl = false;
                if (byArray.length == 0) {
                    LOG.trace("poll: closing signal received");
                    break;
                }
                DockerResponseItem.Impl nextItem = DockerResponseItem.Impl.Companion.fromByteArray(next);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("packet: " + Base64.encode((byte[])next));
                    LOG.trace("decode: " + nextItem);
                }
                handler2.handleItem((DockerResponseItem)nextItem);
                if (nextItem.getAux() == null) continue;
                this.onItemWithAuxDetails.invoke((Object)nextItem);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
        }
        LOG.trace("poll: finished");
    }

    public DockerPullToTerminal(@NotNull DockerTerminalPipe pipe, @NotNull Function1<? super DockerResponseItem, Unit> onItemWithAuxDetails) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)pipe), (String)"pipe");
        Intrinsics.checkParameterIsNotNull(onItemWithAuxDetails, (String)"onItemWithAuxDetails");
        this.pipe = pipe;
        this.onItemWithAuxDetails = onItemWithAuxDetails;
    }

    public /* synthetic */ DockerPullToTerminal(DockerTerminalPipe dockerTerminalPipe, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(dockerTerminalPipe, (Function1<? super DockerResponseItem, Unit>)function1);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(DockerPullToTerminal.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Docke\u2026llToTerminal::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$onPullChannelAvailable(DockerPullToTerminal $this, BlockingQueue channel) {
        $this.onPullChannelAvailable(channel);
    }

    public static final /* synthetic */ DockerTerminalPipe access$getPipe$p(DockerPullToTerminal $this) {
        return $this.pipe;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/pull/DockerPullToTerminal$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.clouds.docker"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

