/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.DynamicBundle;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.compose.configuration.beans.DockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeConfigurationParserUtil;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.deployment.ui.DockerComposeFilesTextField;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeDeploymentEditor
extends SettingsEditor<DockerDeploymentConfiguration> {
    private static final Icon ICON_UNCHECKED = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)12));
    private final Project myProject;
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myComposeFilesField;
    private TextFieldWithBrowseButton myServicesField;
    private TextFieldWithBrowseButton myEnvVarsField;
    private JCheckBox myForceBuild;
    private JCheckBox myRemoveVolumes;
    private List<String> myLastComposeFiles;
    private List<String> myLastServices;

    public DockerComposeDeploymentEditor(@NotNull Project project) {
        if (project == null) {
            DockerComposeDeploymentEditor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.getComposeFilesField().addChangeListener(e -> this.handleSourceFilesChanged());
        this.getServicesField().addActionListener(e -> this.showServicesPopup());
    }

    protected void resetEditorFrom(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerComposeDeploymentEditor.$$$reportNull$$$0(1);
        }
        this.resetComposeFilesFrom(configuration);
        this.getServicesField().setServices(configuration.getServices());
        this.resetEnvVarsFrom(configuration);
        this.myForceBuild.setSelected(DockerComposeDeploymentSourceType.getInstance().isForceBuild(configuration));
        this.myRemoveVolumes.setSelected(configuration.isRemoveVolumesOnComposeDown());
    }

    protected void applyEditorTo(@NotNull DockerDeploymentConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            DockerComposeDeploymentEditor.$$$reportNull$$$0(2);
        }
        this.applyComposeFilesTo(configuration);
        configuration.setServices(this.getServicesField().getParsedServices());
        this.applyEnvVarsTo(configuration);
        DockerComposeDeploymentSourceType.getInstance().applyForceBuild(configuration, this.myForceBuild.isSelected());
        configuration.setRemoveVolumesOnComposeDown(this.myRemoveVolumes.isSelected());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DockerComposeDeploymentEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void resetComposeFilesFrom(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerComposeDeploymentEditor.$$$reportNull$$$0(4);
        }
        LinkedList<String> storedPaths = new LinkedList<String>();
        storedPaths.add(configuration.getSourceFilePath());
        storedPaths.addAll(configuration.getSecondarySourceFiles());
        List<String> absolutePaths = storedPaths.stream().filter(path -> !StringUtil.isEmptyOrSpaces((String)path)).map(path -> DockerDeploymentConfiguration.ProjectAwareHelper.getSourceFile(this.myProject, path)).filter(Objects::nonNull).map(File::getAbsolutePath).collect(Collectors.toList());
        this.getComposeFilesField().setConfigurationFiles(absolutePaths);
    }

    private void applyComposeFilesTo(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerComposeDeploymentEditor.$$$reportNull$$$0(5);
        }
        List allFiles = ContainerUtil.map(this.getComposeFilesField().getConfigurationFiles(), pathString -> Paths.get(pathString, new String[0]).toFile());
        DockerDeploymentConfiguration.ProjectAwareHelper.setManySourceFiles(this.myProject, configuration, allFiles);
    }

    private void applyEnvVarsTo(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerComposeDeploymentEditor.$$$reportNull$$$0(6);
        }
        List envVars = ContainerUtil.map(this.getEnvVarsField().getEnvs().entrySet(), e -> new DockerEnvVarImpl((String)e.getKey(), (String)e.getValue()));
        configuration.setEnvVars(envVars);
    }

    private void resetEnvVarsFrom(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerComposeDeploymentEditor.$$$reportNull$$$0(7);
        }
        LinkedHashMap envVars = new LinkedHashMap();
        configuration.getEnvVars().forEach(var -> envVars.put(var.getName(), var.getValue()));
        this.getEnvVarsField().setEnvs(envVars);
    }

    private void createUIComponents() {
        this.myComposeFilesField = new ComposeFilesTextFieldEx(this.myProject);
        this.myServicesField = new ServicesField();
        this.myEnvVarsField = new EnvironmentVariablesTextFieldWithBrowseButton();
    }

    private DockerComposeFilesTextField getComposeFilesField() {
        return (DockerComposeFilesTextField)this.myComposeFilesField;
    }

    private ServicesField getServicesField() {
        return (ServicesField)this.myServicesField;
    }

    private EnvironmentVariablesTextFieldWithBrowseButton getEnvVarsField() {
        return (EnvironmentVariablesTextFieldWithBrowseButton)this.myEnvVarsField;
    }

    private void handleSourceFilesChanged() {
        List<String> composeFilesNow = this.getComposeFiles();
        if (this.myLastComposeFiles != null && !this.myLastComposeFiles.equals(composeFilesNow)) {
            this.myLastComposeFiles = null;
            this.myLastServices = null;
        }
    }

    @NotNull
    private List<String> refreshServices() {
        List<String> composeFilesNow = this.getComposeFiles();
        if (this.myLastComposeFiles == null || !this.myLastComposeFiles.equals(composeFilesNow)) {
            this.myLastComposeFiles = composeFilesNow;
            this.myLastServices = DockerComposeDeploymentEditor.recomputeServices(composeFilesNow);
        }
        List<Object> list = this.myLastServices == null ? Collections.emptyList() : this.myLastServices;
        if (list == null) {
            DockerComposeDeploymentEditor.$$$reportNull$$$0(8);
        }
        return list;
    }

    private void showServicesPopup() {
        List<String> allServices = this.refreshServices();
        if (allServices.isEmpty()) {
            return;
        }
        final List<String> selectedServices = this.getServicesField().getParsedServices();
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(DockerBundle.message("DockerComposeDeploymentEditor.services.popup.title", new Object[0]), allServices){

            public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> DockerComposeDeploymentEditor.this.getServicesField().toggleService(selectedValue));
            }

            public Icon getIconFor(String value) {
                return selectedServices.contains(value) ? AllIcons.Actions.Checked : ICON_UNCHECKED;
            }
        });
        ServicesField servicesField = this.getServicesField();
        if (servicesField.getButton() != null && servicesField.getButton().getParent() != null) {
            popup.showUnderneathOf((Component)servicesField.getButton());
        } else {
            ExpandableTextField expandableTextField = servicesField.getExpandableTextField();
            int totalExtensionsWidth = expandableTextField.getExtensions().stream().filter(Objects::nonNull).mapToInt(next -> next.getPreferredSpace()).sum();
            Dimension size = servicesField.getSize();
            popup.show(new RelativePoint((Component)((Object)servicesField), new Point(size.width - totalExtensionsWidth, size.height)));
        }
    }

    private List<String> getComposeFiles() {
        return this.getComposeFilesField().getConfigurationFiles();
    }

    @NotNull
    private static List<String> recomputeServices(@NotNull List<String> composeFiles) {
        DockerComposeConfiguration nextBean;
        if (composeFiles == null) {
            DockerComposeDeploymentEditor.$$$reportNull$$$0(9);
        }
        if (composeFiles.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                DockerComposeDeploymentEditor.$$$reportNull$$$0(10);
            }
            return list;
        }
        ServiceCollector collector = new ServiceCollector();
        try {
            DockerComposeConfigurationParserUtil.saveDockerComposeFiles(composeFiles);
            nextBean = DockerComposeConfigurationParser.newInstance().parseBean(composeFiles);
        }
        catch (IOException ignored) {
            nextBean = null;
        }
        if (nextBean != null) {
            nextBean.accept(collector);
        }
        List<String> list = collector.getAllServices();
        if (list == null) {
            DockerComposeDeploymentEditor.$$$reportNull$$$0(11);
        }
        return list;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myComposeFilesField;
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerComposeDeploymentEditor.class).getString("DockerComposeDeploymentEditor.compose.files.text"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.myServicesField;
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerComposeDeploymentEditor.class).getString("DockerComposeDeploymentEditor.services.text"));
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.myEnvVarsField;
        jPanel.add((Component)textFieldWithBrowseButton3, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerComposeDeploymentEditor.class).getString("DockerComposeDeploymentEditor.environment.variables.text"));
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/DockerBundle", DockerComposeDeploymentEditor.class).getString("DockerComposeDeploymentEditor.options.panel.title"), (int)0, (int)0, null, null));
        this.myForceBuild = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerComposeDeploymentEditor.class).getString("DockerComposeDeploymentEditor.force.build.text"));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("messages/DockerBundle").getString("DockerComposeDeploymentEditor.force.build.tooltip.text"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myRemoveVolumes = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerComposeDeploymentEditor.class).getString("DockerComposeDeploymentEditor.remove.volumes.text"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deployment/ui/DockerComposeDeploymentEditor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composeFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deployment/ui/DockerComposeDeploymentEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshServices";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "recomputeServices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resetComposeFilesFrom";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyComposeFilesTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyEnvVarsTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resetEnvVarsFrom";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "recomputeServices";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ComposeFilesTextFieldEx
    extends DockerComposeFilesTextField {
        ComposeFilesTextFieldEx(@NotNull Project project) {
            if (project == null) {
                ComposeFilesTextFieldEx.$$$reportNull$$$0(0);
            }
            super(project, null);
            this.setAllowToChoseFolders(false);
        }

        protected void installPathCompletion(FileChooserDescriptor fileChooserDescriptor) {
        }

        @Override
        @NotNull
        protected String getPresentation(@NotNull List<String> configurationFiles) {
            String result;
            if (configurationFiles == null) {
                ComposeFilesTextFieldEx.$$$reportNull$$$0(1);
            }
            String string = (result = super.getPresentation(configurationFiles)).isEmpty() || result.trim().endsWith("; ".trim()) ? result : result + "; ";
            if (string == null) {
                ComposeFilesTextFieldEx.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationFiles";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/deployment/ui/DockerComposeDeploymentEditor$ComposeFilesTextFieldEx";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/deployment/ui/DockerComposeDeploymentEditor$ComposeFilesTextFieldEx";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ServicesField
    extends TextFieldWithBrowseButton {
        ServicesField() {
            super((JTextField)new ExpandableTextField(ServicesField::parseServices, ServicesField::joinServices));
            this.getButton().setIcon(IconUtil.getAddIcon());
        }

        ExpandableTextField getExpandableTextField() {
            return (ExpandableTextField)this.getChildComponent();
        }

        @NotNull
        public List<String> getParsedServices() {
            LinkedList<String> result = new LinkedList<String>();
            String fullText = this.getText().trim();
            if (!fullText.isEmpty()) {
                result.addAll(ServicesField.parseServices(fullText));
            }
            LinkedList<String> linkedList = result;
            if (linkedList == null) {
                ServicesField.$$$reportNull$$$0(0);
            }
            return linkedList;
        }

        public void setServices(@NotNull List<String> services) {
            if (services == null) {
                ServicesField.$$$reportNull$$$0(1);
            }
            this.setText(services.isEmpty() ? "" : ServicesField.joinServices(services));
        }

        public void toggleService(@NotNull String service) {
            List<String> all;
            if (service == null) {
                ServicesField.$$$reportNull$$$0(2);
            }
            if ((all = this.getParsedServices()).contains(service)) {
                all.remove(service);
            } else {
                all.add(service);
            }
            this.setServices(all);
        }

        @NotNull
        private static String joinServices(@NotNull List<String> services) {
            String result;
            if (services == null) {
                ServicesField.$$$reportNull$$$0(3);
            }
            String string = (result = services.stream().filter(ServicesField::hasSomeText).collect(Collectors.joining(", "))).isEmpty() ? result : result + ",";
            if (string == null) {
                ServicesField.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        private static List<String> parseServices(@NotNull String text) {
            if (text == null) {
                ServicesField.$$$reportNull$$$0(5);
            }
            if (StringUtil.isEmptyOrSpaces((String)text)) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    ServicesField.$$$reportNull$$$0(6);
                }
                return list;
            }
            List<String> list = Arrays.stream(text.split("(\\s|[;,])+")).filter(ServicesField::hasSomeText).collect(Collectors.toList());
            if (list == null) {
                ServicesField.$$$reportNull$$$0(7);
            }
            return list;
        }

        private static boolean hasSomeText(@Nullable String text) {
            return !StringUtil.isEmptyOrSpaces((String)text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/deployment/ui/DockerComposeDeploymentEditor$ServicesField";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "services";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParsedServices";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/deployment/ui/DockerComposeDeploymentEditor$ServicesField";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "joinServices";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseServices";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setServices";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "toggleService";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "joinServices";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "parseServices";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ServiceCollector
    implements DockerComposeConfiguration.Visitor<Void> {
        private final LinkedHashSet<String> myServices = new LinkedHashSet();

        private ServiceCollector() {
        }

        public List<String> getAllServices() {
            return new ArrayList<String>(this.myServices);
        }

        @Override
        public Void visit(@NotNull DockerComposeConfigurationV1 configuration) {
            if (configuration == null) {
                ServiceCollector.$$$reportNull$$$0(0);
            }
            return this.registerServices(configuration.getServices());
        }

        @Override
        public Void visit(@NotNull DockerComposeConfigurationV2 configuration) {
            if (configuration == null) {
                ServiceCollector.$$$reportNull$$$0(1);
            }
            return this.registerServices(configuration.getServices());
        }

        private Void registerServices(Map<String, ?> services) {
            this.myServices.addAll(services.keySet());
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/docker/deployment/ui/DockerComposeDeploymentEditor$ServiceCollector", "visit"));
        }
    }
}

