/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import org.jetbrains.annotations.NotNull;

public class CssQuotesFormatPreprocessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode node, @NotNull TextRange range) {
        PsiElement psiElement;
        if (node == null) {
            CssQuotesFormatPreprocessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            CssQuotesFormatPreprocessor.$$$reportNull$$$0(1);
        }
        if ((psiElement = node.getPsi()) == null || !psiElement.isValid()) {
            TextRange textRange = range;
            if (textRange == null) {
                CssQuotesFormatPreprocessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        if (psiElement.getContainingFile().getContext() != null) {
            TextRange textRange = range;
            if (textRange == null) {
                CssQuotesFormatPreprocessor.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        CssCodeStyleSettings settings = CssCodeStyleSettings.getLanguageSpecificSettings(psiElement);
        if (settings == null || !settings.ENFORCE_QUOTES_ON_FORMAT) {
            TextRange textRange = range;
            if (textRange == null) {
                CssQuotesFormatPreprocessor.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        char quoteChar = settings.USE_DOUBLE_QUOTES ? (char)'\"' : '\'';
        CssQuotesConverter converter = new CssQuotesConverter(quoteChar);
        psiElement.accept((PsiElementVisitor)converter);
        TextRange textRange = range.grown(converter.getRangeDelta());
        if (textRange == null) {
            CssQuotesFormatPreprocessor.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/editor/CssQuotesFormatPreprocessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/editor/CssQuotesFormatPreprocessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CssQuotesConverter
    extends CssElementVisitor {
        private final char myOldQuoteChar;
        private final char myNewQuoteChar;
        private int myRangeDelta = 0;

        CssQuotesConverter(char quoteChar) {
            this.myOldQuoteChar = (char)(quoteChar == '\"' ? 39 : 34);
            this.myNewQuoteChar = quoteChar;
        }

        private int getRangeDelta() {
            return this.myRangeDelta;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                CssQuotesConverter.$$$reportNull$$$0(0);
            }
            element.acceptChildren((PsiElementVisitor)this);
        }

        public void visitCssString(CssString string) {
            if (string.getParent() instanceof CssCharset) {
                return;
            }
            if (string.getTextLength() < 2) {
                return;
            }
            String oldText = string.getText();
            if (oldText.charAt(0) == this.myOldQuoteChar && oldText.charAt(oldText.length() - 1) == this.myOldQuoteChar) {
                String newText = oldText.substring(1, oldText.length() - 1);
                newText = StringUtil.replace((String)newText, (String)("\\" + this.myOldQuoteChar), (String)String.valueOf(this.myOldQuoteChar));
                newText = StringUtil.replace((String)newText, (String)String.valueOf(this.myNewQuoteChar), (String)("\\" + this.myNewQuoteChar));
                CssString newString = CssElementFactory.getInstance((Project)string.getProject()).createString(this.myNewQuoteChar, newText, string.getLanguage());
                this.myRangeDelta += newString.getTextLength() - string.getTextLength();
                string.replace((PsiElement)newString);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/editor/CssQuotesFormatPreprocessor$CssQuotesConverter", "visitElement"));
        }
    }
}

