/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssAtRule;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class AtRulePresentation
implements ItemPresentation {
    private final CssAtRule myAtRule;
    @Nullable
    private final String myText;
    @Nullable
    private final Icon myIcon;

    public AtRulePresentation(CssAtRule atRule) {
        this(atRule, null);
    }

    public AtRulePresentation(CssAtRule atRule, @Nullable String presentableText) {
        this(atRule, presentableText, null);
    }

    public AtRulePresentation(CssAtRule atRule, @Nullable String presentableText, @Nullable Icon icon) {
        this.myAtRule = atRule;
        this.myText = presentableText;
        this.myIcon = icon;
    }

    @Nullable
    public String getPresentableText() {
        if (this.myText == null) {
            String typeName = this.myAtRule.getName();
            return StringUtil.startsWithChar((CharSequence)typeName, (char)'@') ? typeName.substring(1) : typeName;
        }
        return this.myText;
    }

    @Nullable
    public String getLocationString() {
        return null;
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return this.myIcon != null ? this.myIcon : AllIcons.Nodes.Annotationtype;
    }
}

