/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.connection.VmConnection;

public class RemoteUrlMappingHelper {
    public static void showSetRemoteUrlDialog(@NotNull JavaScriptDebugProcess<? extends VmConnection> debugProcess, @NotNull VirtualFile file2) {
        if (debugProcess == null) {
            RemoteUrlMappingHelper.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            RemoteUrlMappingHelper.$$$reportNull$$$0(1);
        }
        Url hostUrl = debugProcess.getCurrentLocationUrl();
        String url = Messages.showInputDialog((Project)debugProcess.getSession().getProject(), (String)JSDebuggerBundle.message("label.text.input.remote.url.for.0", file2.getName()), (String)JSDebuggerBundle.message("dialog.title.remote.url", new Object[0]), null, (String)(hostUrl == null ? null : hostUrl.trimParameters().toDecodedForm()), null);
        if (url != null) {
            RemoteUrlMappingHelper.addUrlMapping(debugProcess, file2, url);
        }
    }

    private static void addUrlMapping(@NotNull JavaScriptDebugProcess<? extends VmConnection> debugProcess, VirtualFile file2, String url) {
        RunProfile configuration;
        if (debugProcess == null) {
            RemoteUrlMappingHelper.$$$reportNull$$$0(2);
        }
        if ((configuration = debugProcess.getSession().getRunProfile()) instanceof JavaScriptDebugConfiguration) {
            List<RemoteUrlMappingBean> mappings = ((JavaScriptDebugConfiguration)configuration).getMappings();
            String filePath = file2.getPath();
            Iterator<RemoteUrlMappingBean> iterator = mappings.iterator();
            while (iterator.hasNext()) {
                RemoteUrlMappingBean mapping = iterator.next();
                if (!filePath.equals(mapping.localFilePath)) continue;
                iterator.remove();
            }
            mappings.add(new RemoteUrlMappingBean(filePath, url));
            debugProcess.updateRemoteUrlMappings(mappings);
        }
    }

    public static void showSetLocalPathDialog(@NotNull JavaScriptDebugProcess<? extends VmConnection> debugProcess, @NotNull Url url, boolean allowFiles) {
        if (debugProcess == null) {
            RemoteUrlMappingHelper.$$$reportNull$$$0(3);
        }
        if (url == null) {
            RemoteUrlMappingHelper.$$$reportNull$$$0(4);
        }
        final Project project = debugProcess.getSession().getProject();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(allowFiles, true, false, false, false, false){

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                if (!super.isFileVisible(file2, showHiddenFiles) || !file2.isDirectory() && !JsFileUtil.isHtmlOrJavaScript(file2)) {
                    return false;
                }
                return !ProjectRootManager.getInstance((Project)project).getFileIndex().isExcluded(file2);
            }
        };
        descriptor.setTitle(JSDebuggerBundle.message("js.remote.mapper.choose.path.title", new Object[0]));
        descriptor.setDescription(JSDebuggerBundle.message("js.remote.mapper.choose.path.description", url));
        descriptor.setRoots(ProjectRootManager.getInstance((Project)project).getContentRoots());
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null, (VirtualFile)debugProcess.findFile(url), file2 -> RemoteUrlMappingHelper.addUrlMapping(debugProcess, file2, url.trimParameters().toDecodedForm()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/debugger/RemoteUrlMappingHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showSetRemoteUrlDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addUrlMapping";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showSetLocalPathDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

