/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.refactoring;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.Language;
import com.intellij.lang.puppet.PuppetLanguage;
import com.intellij.lang.puppet.psi.PuppetDelegatingLightNamedElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.util.containers.StringInterner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetMemberInplaceRenamer
extends MemberInplaceRenamer {
    private final List<String> myOldNames;

    public PuppetMemberInplaceRenamer(@NotNull PsiNamedElement elementToRename, PsiElement substituted, Editor editor) {
        if (elementToRename == null) {
            PuppetMemberInplaceRenamer.$$$reportNull$$$0(0);
        }
        super(elementToRename, substituted, editor);
        this.myOldNames = new ArrayList<String>();
    }

    public PuppetMemberInplaceRenamer(@NotNull PsiNamedElement elementToRename, PsiElement substituted, Editor editor, String initialName, String oldName) {
        if (elementToRename == null) {
            PuppetMemberInplaceRenamer.$$$reportNull$$$0(1);
        }
        super(elementToRename, substituted, editor, initialName, oldName);
        this.myOldNames = new ArrayList<String>();
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiElement element) {
        ElementManipulator manipulator;
        if (element == null) {
            PuppetMemberInplaceRenamer.$$$reportNull$$$0(2);
        }
        TextRange textRange = (manipulator = ElementManipulators.getManipulator((PsiElement)element)) == null ? super.getRangeToRename(element) : manipulator.getRangeInElement(element);
        if (textRange == null) {
            PuppetMemberInplaceRenamer.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    protected boolean appendAdditionalElement(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        PsiElement substituted;
        boolean showChooser = stringUsages.isEmpty() || StartMarkAction.canStart((Project)this.myProject) != null;
        PsiNamedElement variable = this.getVariable();
        if (variable != null && (substituted = this.getSubstituted()) != null) {
            this.appendAdditionalElement(stringUsages, variable, substituted);
            RenamePsiElementProcessor processor = RenamePsiElementProcessor.forElement((PsiElement)substituted);
            HashMap allRenames = new HashMap();
            PsiFile currentFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
            processor.prepareRenaming(substituted, "", allRenames, (SearchScope)new LocalSearchScope((PsiElement)currentFile));
            for (PsiElement element : allRenames.keySet()) {
                this.appendAdditionalElement(stringUsages, variable, element);
            }
        }
        return showChooser;
    }

    private void appendAdditionalElement(Collection<Pair<PsiElement, TextRange>> stringUsages, PsiNamedElement variable, PsiElement element) {
        PsiElement identifier;
        if (element != variable && element instanceof PsiNameIdentifierOwner && !this.notSameFile(null, element.getContainingFile()) && (identifier = ((PsiNameIdentifierOwner)element).getNameIdentifier()) != null) {
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)identifier, (Object)this.getRangeToRename(identifier)));
        }
    }

    @NotNull
    protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
        return new PuppetMemberInplaceRenamer(variable, this.getSubstituted(), editor, initialName, this.myOldName);
    }

    protected boolean buildTemplateAndStart(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages, PsiElement scope, PsiFile containingFile) {
        Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor((Editor)this.myEditor);
        String documentText = topLevelEditor.getDocument().getText();
        boolean result = super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
        if (result) {
            TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)topLevelEditor);
            assert (templateState != null);
            this.myOldNames.clear();
            StringInterner stringInterner = new StringInterner();
            int count = templateState.getSegmentsCount();
            int documentOffset = 0;
            int templateOffset = 0;
            int initialNameSize = this.myInitialName.length();
            int oldNameSize = this.myOldName.length();
            for (int i = 0; i < count; ++i) {
                TextRange templateSegmentRange = templateState.getSegmentRange(i);
                int segmentOffset = templateSegmentRange.getStartOffset() - templateOffset;
                TextRange documentRange = TextRange.from((int)(documentOffset += segmentOffset), (int)oldNameSize);
                this.myOldNames.add((String)stringInterner.intern((Object)documentRange.substring(documentText)));
                documentOffset += oldNameSize;
                templateOffset += segmentOffset + initialNameSize;
            }
        }
        return result;
    }

    protected boolean isIdentifier(String newName, Language language) {
        return super.isIdentifier(newName, language) && RenameUtil.isValidName((Project)this.myProject, (PsiElement)this.getVariable(), (String)newName);
    }

    @Nullable
    protected PsiNamedElement getVariable() {
        PsiElement namedElement;
        PsiElement psiLeaf;
        PsiFile psiFile;
        PsiNamedElement variable = super.getVariable();
        if (variable != null) {
            return variable;
        }
        if (this.myElementToRename instanceof PuppetDelegatingLightNamedElement && (psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument())) != null && (psiLeaf = psiFile.getViewProvider().findElementAt(this.myRenameOffset.getStartOffset(), (Language)PuppetLanguage.INSTANCE)) != null && (namedElement = TargetElementUtil.getInstance().getNamedElement(psiLeaf, 0)) instanceof PuppetDelegatingLightNamedElement) {
            return (PsiNamedElement)namedElement;
        }
        return null;
    }

    protected void revertState() {
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor((Editor)this.myEditor);
            ApplicationManager.getApplication().runWriteAction(() -> {
                TemplateState state = TemplateManagerImpl.getTemplateState((Editor)topLevelEditor);
                assert (state != null);
                int segmentsCount = state.getSegmentsCount();
                Document document = topLevelEditor.getDocument();
                for (int i = 0; i < segmentsCount; ++i) {
                    TextRange segmentRange = state.getSegmentRange(i);
                    document.replaceString(segmentRange.getStartOffset(), segmentRange.getEndOffset(), (CharSequence)this.myOldNames.get(i));
                }
                this.myOldNames.clear();
            });
            if (!this.myProject.isDisposed() && this.myProject.isOpen()) {
                PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(topLevelEditor.getDocument());
            }
        }, this.getCommandName(), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/refactoring/PuppetMemberInplaceRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/refactoring/PuppetMemberInplaceRenamer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToRename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToRename";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

