/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.jobs.AdderRemover;
import org.jetbrains.idea.perforce.perforce.jobs.JobsTablePresentation;
import org.jetbrains.idea.perforce.perforce.jobs.JobsWorker;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;

class WritingAdderRemover
implements AdderRemover {
    private final JobsTablePresentation myPresentation;
    private final JobsWorker myWorker;

    WritingAdderRemover(JobsWorker worker, JobsTablePresentation presentation) {
        this.myWorker = worker;
        this.myPresentation = presentation;
    }

    @Override
    @Nullable
    public VcsException add(@NotNull PerforceJob job, LocalChangeList list, Project project) {
        if (job == null) {
            WritingAdderRemover.$$$reportNull$$$0(0);
        }
        Ref exceptionRef = new Ref();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                this.myWorker.addJob(job, list);
                this.myPresentation.refreshJobs(job);
            }
            catch (VcsException e) {
                exceptionRef.set((Object)e);
            }
        }, "Adding job to changelist", false, this.myWorker.getProject());
        return (VcsException)((Object)exceptionRef.get());
    }

    @Override
    @Nullable
    public VcsException remove(@NotNull PerforceJob job, LocalChangeList list, Project project) {
        if (job == null) {
            WritingAdderRemover.$$$reportNull$$$0(1);
        }
        Ref exceptionRef = new Ref();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                this.myWorker.removeJob(job, list);
                this.myPresentation.refreshJobs(null);
            }
            catch (VcsException e) {
                exceptionRef.set((Object)e);
            }
        }, "Removing job from changelist", false, this.myWorker.getProject());
        return (VcsException)((Object)exceptionRef.get());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "job";
        objectArray2[1] = "org/jetbrains/idea/perforce/perforce/jobs/WritingAdderRemover";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

