/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.server;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterActionsKt;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerFinished;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerService;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerStarted;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerStarting;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerState;
import org.jetbrains.plugins.notebooks.jupyter.server.JupyterServerStopped;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\f\u0010\u000b\u001a\u00020\n*\u00020\fH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0003\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"startServerIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "stopServerIcon", "module", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getModule", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/openapi/module/Module;", "isJupyterServerStarted", "", "isStarted", "Lorg/jetbrains/plugins/notebooks/jupyter/server/JupyterServerState;", "intellij.python.jupyter"})
public final class JupyterServerManageActionsKt {
    private static final Icon startServerIcon;
    private static final Icon stopServerIcon;

    private static final Module getModule(@NotNull AnActionEvent $this$module) {
        Project project = $this$module.getProject();
        if (project == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project ?: return null");
        Project project2 = project;
        VirtualFile virtualFile2 = JupyterActionsKt.getVirtualFile($this$module);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        return ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile3, (Project)project2);
    }

    private static final boolean isJupyterServerStarted(Module module) {
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        Object object = JupyterServerService.Companion.getInstance(project).getCurrentExecution(module);
        return object != null && (object = object.getState()) != null ? JupyterServerManageActionsKt.isStarted((JupyterServerState)object) : false;
    }

    private static final boolean isStarted(@NotNull JupyterServerState $this$isStarted) {
        return (Boolean)$this$isStarted.accept(new JupyterServerState.Visitor<Boolean>(){

            @NotNull
            public Boolean visit(@NotNull JupyterServerStopped state2) {
                Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
                return false;
            }

            @NotNull
            public Boolean visit(@NotNull JupyterServerStarting state2) {
                Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
                return true;
            }

            @NotNull
            public Boolean visit(@NotNull JupyterServerStarted state2) {
                Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
                return true;
            }

            @NotNull
            public Boolean visit(@NotNull JupyterServerFinished state2) {
                Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
                return false;
            }
        });
    }

    static {
        Icon icon = AllIcons.Actions.Execute;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Actions.Execute");
        startServerIcon = icon;
        Icon icon2 = AllIcons.Actions.Suspend;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Actions.Suspend");
        stopServerIcon = icon2;
    }

    public static final /* synthetic */ boolean access$isJupyterServerStarted(Module module) {
        return JupyterServerManageActionsKt.isJupyterServerStarted(module);
    }

    public static final /* synthetic */ boolean access$isStarted(JupyterServerState $this$access_u24isStarted) {
        return JupyterServerManageActionsKt.isStarted($this$access_u24isStarted);
    }

    public static final /* synthetic */ Module access$getModule$p(AnActionEvent $this$access_u24module_u24p) {
        return JupyterServerManageActionsKt.getModule($this$access_u24module_u24p);
    }

    public static final /* synthetic */ Icon access$getStartServerIcon$p() {
        return startServerIcon;
    }

    public static final /* synthetic */ Icon access$getStopServerIcon$p() {
        return stopServerIcon;
    }
}

