/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterElementType;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterTokenType;
import org.jetbrains.plugins.notebooks.jupyter.psi.impl.JupyterCellImpl;
import org.jetbrains.plugins.notebooks.jupyter.psi.impl.JupyterCellMagicImpl;
import org.jetbrains.plugins.notebooks.jupyter.psi.impl.JupyterCellMarkerImpl;
import org.jetbrains.plugins.notebooks.jupyter.psi.impl.JupyterNotebookImpl;
import org.jetbrains.plugins.notebooks.jupyter.psi.impl.JupyterSourceImpl;
import org.jetbrains.plugins.notebooks.jupyter.psi.impl.JupyterStemCellImpl;

public interface JupyterTypes {
    public static final IElementType CELL = new JupyterElementType("CELL");
    public static final IElementType CELL_MAGIC = new JupyterElementType("CELL_MAGIC");
    public static final IElementType CELL_MARKER = new JupyterElementType("CELL_MARKER");
    public static final IElementType NOTEBOOK = new JupyterElementType("NOTEBOOK");
    public static final IElementType SOURCE = new JupyterElementType("SOURCE");
    public static final IElementType STEM_CELL = new JupyterElementType("STEM_CELL");
    public static final IElementType ANY = new JupyterTokenType("ANY");
    public static final IElementType CODE_MARKER = new JupyterTokenType("CODE_MARKER");
    public static final IElementType CODE_SOURCE = new JupyterTokenType("CODE_SOURCE");
    public static final IElementType MAGIC = new JupyterTokenType("MAGIC");
    public static final IElementType MARKDOWN_MARKER = new JupyterTokenType("MARKDOWN_MARKER");
    public static final IElementType MARKDOWN_SOURCE = new JupyterTokenType("MARKDOWN_SOURCE");
    public static final IElementType RAW_MARKER = new JupyterTokenType("RAW_MARKER");
    public static final IElementType RAW_SOURCE = new JupyterTokenType("RAW_SOURCE");

    public static class Factory {
        public static PsiElement createElement(ASTNode node) {
            IElementType type = node.getElementType();
            if (type == CELL) {
                return new JupyterCellImpl(node);
            }
            if (type == CELL_MAGIC) {
                return new JupyterCellMagicImpl(node);
            }
            if (type == CELL_MARKER) {
                return new JupyterCellMarkerImpl(node);
            }
            if (type == NOTEBOOK) {
                return new JupyterNotebookImpl(node);
            }
            if (type == SOURCE) {
                return new JupyterSourceImpl(node);
            }
            if (type == STEM_CELL) {
                return new JupyterStemCellImpl(node);
            }
            throw new AssertionError((Object)("Unknown element type: " + type));
        }
    }
}

