/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.psi;

import com.fasterxml.jackson.databind.node.TextNode;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.core.api.psi.NotebookASTCellMapper;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.core.impl.psi.NotebookPsiChangeListener;
import org.jetbrains.plugins.notebooks.jupyter.JupyterFileType;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCell;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCellBuilder;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterTypes;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u000eH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterASTCellMapper;", "Lorg/jetbrains/plugins/notebooks/core/api/psi/NotebookASTCellMapper;", "()V", "getCellType", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterCellType;", "cellMarker", "Lcom/intellij/psi/tree/IElementType;", "isSupported", "", "virtualFile", "Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;", "onBuildCallback", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterCellBuilder;", "cellBuilder", "Lcom/intellij/lang/ASTNode;", "onUpdateCallback", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterCell;", "cell", "intellij.python.jupyter"})
public final class JupyterASTCellMapper
implements NotebookASTCellMapper {
    @Override
    public boolean isSupported(@NotNull NotebookVirtualFile virtualFile2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)virtualFile2), (String)"virtualFile");
        return Intrinsics.areEqual((Object)virtualFile2.getFileType(), (Object)((Object)JupyterFileType.INSTANCE));
    }

    @Override
    @NotNull
    public JupyterCellType getCellType(@NotNull IElementType cellMarker) {
        JupyterCellType jupyterCellType;
        Intrinsics.checkParameterIsNotNull((Object)cellMarker, (String)"cellMarker");
        IElementType iElementType = cellMarker;
        if (Intrinsics.areEqual((Object)iElementType, (Object)JupyterTypes.CODE_MARKER)) {
            jupyterCellType = JupyterCellType.CODE;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)JupyterTypes.RAW_MARKER)) {
            jupyterCellType = JupyterCellType.RAW;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)JupyterTypes.MARKDOWN_MARKER)) {
            jupyterCellType = JupyterCellType.MARKDOWN;
        } else {
            NotebookPsiChangeListener.Companion.getLOG().error("Unknown cell type token: " + cellMarker);
            jupyterCellType = JupyterCellType.CODE;
        }
        return jupyterCellType;
    }

    @Override
    @NotNull
    public JupyterCellBuilder onBuildCallback(@NotNull JupyterCellBuilder cellBuilder, @NotNull ASTNode cellMarker) {
        Intrinsics.checkParameterIsNotNull((Object)cellBuilder, (String)"cellBuilder");
        Intrinsics.checkParameterIsNotNull((Object)cellMarker, (String)"cellMarker");
        if (cellBuilder.getCellType() == JupyterCellType.CODE) {
            TextNode textNode = TextNode.valueOf((String)cellMarker.getText());
            Intrinsics.checkExpressionValueIsNotNull((Object)textNode, (String)"TextNode.valueOf(cellMarker.text)");
            cellBuilder.setMetadata("name", textNode);
        }
        return cellBuilder;
    }

    @Override
    @NotNull
    public JupyterCell onUpdateCallback(@NotNull JupyterCell cell, @NotNull ASTNode cellMarker) {
        Intrinsics.checkParameterIsNotNull((Object)cell, (String)"cell");
        Intrinsics.checkParameterIsNotNull((Object)cellMarker, (String)"cellMarker");
        TextNode textNode = TextNode.valueOf((String)cellMarker.getText());
        Intrinsics.checkExpressionValueIsNotNull((Object)textNode, (String)"TextNode.valueOf(cellMarker.text)");
        cell.setMetadata("name", textNode);
        return cell;
    }
}

