/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.CachingFileContentsApi;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.ContentsApiModel;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.DirectoryModel;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.FileContentsApi;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.FileContentsApiKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.FileModel;
import org.jetbrains.plugins.notebooks.jupyter.connections.filecontentsapi.FileWriterOutputStream;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/TreeCachingFileContentsApi;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/CachingFileContentsApi;", "forward", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/FileContentsApi;", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/FileContentsApi;)V", "directoryContents", "Lcom/google/common/cache/Cache;", "", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/ContentsApiModel;", "createDirectory", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/DirectoryModel;", "path", "delete", "", "fileWriter", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/filecontentsapi/FileWriterOutputStream;", "getFileNode", "content", "", "invalidateAll", "invalidateForPath", "recursive", "normalizePath", "value", "rename", "oldPath", "newPath", "intellij.python.jupyter"})
public final class TreeCachingFileContentsApi
implements CachingFileContentsApi {
    private final Cache<String, ContentsApiModel> directoryContents;
    private final FileContentsApi forward;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public ContentsApiModel getFileNode(@NotNull String path, boolean content2) {
        ContentsApiModel contentsApiModel;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String normalizedPath = this.normalizePath(path);
        if (!content2) {
            ContentsApiModel contentsApiModel2 = (ContentsApiModel)this.directoryContents.getIfPresent((Object)normalizedPath);
            if (contentsApiModel2 != null) {
                ContentsApiModel contentsApiModel3 = contentsApiModel2;
                boolean bl = false;
                boolean bl2 = false;
                ContentsApiModel it = contentsApiModel3;
                boolean bl3 = false;
                Logger $this$debug$iv = FileContentsApiKt.access$getLOG$p();
                Exception e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    Logger logger = $this$debug$iv;
                    boolean bl4 = false;
                    String string = "Returning the cached model from getFileNode(\"" + normalizedPath + "\").";
                    logger.debug(string, (Throwable)e$iv);
                }
                ContentsApiModel contentsApiModel4 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)contentsApiModel4, (String)"it");
                return contentsApiModel4;
            }
        }
        ContentsApiModel result = this.forward.getFileNode(path, content2);
        if (content2) {
            ContentsApiModel contentsApiModel5 = result;
            if (contentsApiModel5 instanceof DirectoryModel) {
                contentsApiModel = DirectoryModel.copy$default((DirectoryModel)result, null, null, 1, null);
            } else {
                if (!(contentsApiModel5 instanceof FileModel)) throw new NoWhenBranchMatchedException();
                contentsApiModel = new FileModel(result.getName(), null);
            }
        } else {
            contentsApiModel = result;
        }
        this.directoryContents.put((Object)normalizedPath, (Object)contentsApiModel);
        Logger $this$debug$iv = FileContentsApiKt.access$getLOG$p();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if (!$this$debug$iv.isDebugEnabled()) return result;
        Logger logger = $this$debug$iv;
        boolean bl = false;
        String string = "Caching a model from getFileNode(\"" + normalizedPath + "\").";
        logger.debug(string, (Throwable)e$iv);
        return result;
    }

    @Override
    @NotNull
    public FileWriterOutputStream fileWriter(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        FileWriterOutputStream stream = this.forward.fileWriter(path);
        String normalizedPath = this.normalizePath(path);
        return new FileWriterOutputStream(this, normalizedPath, stream){
            final /* synthetic */ TreeCachingFileContentsApi this$0;
            final /* synthetic */ String $normalizedPath;
            final /* synthetic */ FileWriterOutputStream $stream;

            private final void updateCache() {
                FileModel model = this.getModel();
                if (model != null) {
                    boolean bl = model.getContent() == null;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    bl3 = false;
                    boolean bl4 = false;
                    if (!bl) {
                        boolean bl5 = false;
                        String string = "Check failed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    TreeCachingFileContentsApi.access$getDirectoryContents$p(this.this$0).put((Object)this.$normalizedPath, (Object)model);
                    Logger $this$debug$iv = FileContentsApiKt.access$getLOG$p();
                    Exception e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        Logger logger = $this$debug$iv;
                        boolean bl6 = false;
                        String string = "Caching a model from fileWriter(\"" + this.$normalizedPath + "\").";
                        logger.debug(string, (Throwable)e$iv);
                    }
                } else {
                    Logger $this$debug$iv = FileContentsApiKt.access$getLOG$p();
                    Exception e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        Logger logger = $this$debug$iv;
                        boolean bl = false;
                        String string = "Invalidating the cached model from fileWriter(\"" + this.$normalizedPath + "\").";
                        logger.debug(string, (Throwable)e$iv);
                    }
                    TreeCachingFileContentsApi.access$getDirectoryContents$p(this.this$0).invalidate((Object)this.$normalizedPath);
                }
            }

            @Nullable
            public FileModel getModel() {
                return this.$stream.getModel();
            }

            public void write(int b) {
                this.$stream.write(b);
                Unit unit = Unit.INSTANCE;
                boolean bl = false;
                boolean bl2 = false;
                Unit it = unit;
                boolean bl3 = false;
                this.updateCache();
            }

            public void write(@NotNull byte[] b, int off, int len) {
                Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
                this.$stream.write(b, off, len);
                Unit unit = Unit.INSTANCE;
                boolean bl = false;
                boolean bl2 = false;
                Unit it = unit;
                boolean bl3 = false;
                this.updateCache();
            }

            public void flush() {
                this.$stream.flush();
                Unit unit = Unit.INSTANCE;
                boolean bl = false;
                boolean bl2 = false;
                Unit it = unit;
                boolean bl3 = false;
                this.updateCache();
            }

            public void close() {
                this.$stream.close();
                Unit unit = Unit.INSTANCE;
                boolean bl = false;
                boolean bl2 = false;
                Unit it = unit;
                boolean bl3 = false;
                this.updateCache();
            }
            {
                this.this$0 = $outer;
                this.$normalizedPath = $captured_local_variable$1;
                this.$stream = $captured_local_variable$2;
            }
        };
    }

    @Override
    @NotNull
    public DirectoryModel createDirectory(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        DirectoryModel directoryModel = this.forward.createDirectory(path);
        boolean bl = false;
        boolean bl2 = false;
        DirectoryModel it = directoryModel;
        boolean bl3 = false;
        boolean bl4 = it.getContent() == null;
        boolean bl5 = false;
        boolean bl6 = false;
        bl6 = false;
        boolean bl7 = false;
        if (!bl4) {
            boolean bl8 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String normalizedPath = this.normalizePath(path);
        Logger $this$debug$iv = FileContentsApiKt.access$getLOG$p();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl9 = false;
            String string = "Caching a model from createDirectory(\"" + normalizedPath + "\").";
            logger.debug(string, (Throwable)e$iv);
        }
        this.directoryContents.put((Object)normalizedPath, (Object)it);
        return directoryModel;
    }

    @Override
    public void delete(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.forward.delete(path);
        Unit unit = Unit.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        Unit it = unit;
        boolean bl3 = false;
        this.directoryContents.invalidate((Object)this.normalizePath(path));
    }

    @Override
    @NotNull
    public ContentsApiModel rename(@NotNull String oldPath, @NotNull String newPath) {
        Intrinsics.checkParameterIsNotNull((Object)oldPath, (String)"oldPath");
        Intrinsics.checkParameterIsNotNull((Object)newPath, (String)"newPath");
        ContentsApiModel contentsApiModel = this.forward.rename(oldPath, newPath);
        boolean bl = false;
        boolean bl2 = false;
        ContentsApiModel it = contentsApiModel;
        boolean bl3 = false;
        String normalizedOldPath = this.normalizePath(oldPath);
        this.directoryContents.invalidate((Object)normalizedOldPath);
        String normalizedNewPath = this.normalizePath(newPath);
        Logger $this$debug$iv = FileContentsApiKt.access$getLOG$p();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl4 = false;
            String string = "Invalidating the cached model and caching a new model from rename(\"" + normalizedOldPath + "\", \"" + normalizedNewPath + "\").";
            logger.debug(string, (Throwable)e$iv);
        }
        this.directoryContents.put((Object)normalizedNewPath, (Object)it);
        return contentsApiModel;
    }

    @Override
    public void invalidateAll() {
        FileContentsApiKt.access$getLOG$p().debug("Invalidating all cached models by invalidateAll().");
        this.directoryContents.invalidateAll();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void invalidateForPath(@NotNull String path, boolean recursive) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String normalizedPath = this.normalizePath(path);
        if (!recursive) {
            Logger $this$debug$iv = FileContentsApiKt.access$getLOG$p();
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv;
                boolean bl = false;
                String string = "Invalidating the cached model for \"" + path + '\"';
                logger.debug(string, (Throwable)e$iv);
            }
            this.directoryContents.invalidate((Object)normalizedPath);
        } else {
            CharSequence $this$debug$iv = normalizedPath;
            boolean e$iv = false;
            if ($this$debug$iv.length() == 0) {
                FileContentsApiKt.access$getLOG$p().debug("Invalidating all cached models by invalidateAll(\"\", recursive=true).");
                this.invalidateAll();
            } else {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.directoryContents.asMap().keySet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    String string = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                    if (!(StringsKt.startsWith$default((String)string, (String)normalizedPath, (boolean)false, (int)2, null) && (it.length() == normalizedPath.length() || it.charAt(normalizedPath.length()) == '/'))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List keys = (List)destination$iv$iv;
                Logger $this$debug$iv2 = FileContentsApiKt.access$getLOG$p();
                Exception e$iv2 = null;
                boolean $i$f$debug = false;
                if ($this$debug$iv2.isDebugEnabled()) {
                    Logger logger = $this$debug$iv2;
                    boolean bl = false;
                    String string = "Invalidating " + keys.size() + " cached models for \"" + path + "\", recursively.";
                    logger.debug(string, (Throwable)e$iv2);
                }
                this.directoryContents.invalidateAll((Iterable)keys);
            }
        }
    }

    private final String normalizePath(String value2) {
        String string;
        String string2 = StringsKt.trim((String)value2, (char[])new char[]{'/'});
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        if (StringsKt.contains$default((CharSequence)it, (CharSequence)"//", (boolean)false, (int)2, null)) {
            CharSequence charSequence = it;
            Regex regex = new Regex("//+");
            String string3 = "/";
            boolean bl4 = false;
            string = regex.replace(charSequence, string3);
        } else {
            string = it;
        }
        return string;
    }

    public TreeCachingFileContentsApi(@NotNull FileContentsApi forward) {
        Intrinsics.checkParameterIsNotNull((Object)forward, (String)"forward");
        this.forward = forward;
        Cache cache2 = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)cache2, (String)"CacheBuilder.newBuilder(\u2026dom timeout.\n    .build()");
        this.directoryContents = cache2;
    }

    public static final /* synthetic */ Cache access$getDirectoryContents$p(TreeCachingFileContentsApi $this) {
        return $this.directoryContents;
    }
}

