/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.execution.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.util.io.IoKt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.JupyterJsonKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.BytesWebSocketMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessageBase;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessageChannel;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessageHeader;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessageHeaderBase;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterProtocolSchema;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.StringWebSocketMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.WebSocketMessage;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterMetadataAwareBase;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u0000 72\u00020\u00012\u00020\u0002:\u00017B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010'\u001a\u00020\u0004J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0096\u0002J\n\u0010,\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u000200H\u0016J\"\u0010/\u001a\u0002002\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020402H\u0080\b\u00a2\u0006\u0002\b5J\b\u00106\u001a\u000204H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00178V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0016R$\u0010\u001e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u0016\"\u0004\b \u0010!R(\u0010\"\u001a\u0004\u0018\u00010\u00172\b\u0010\r\u001a\u0004\u0018\u00010\u00178V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\u001a\"\u0004\b$\u0010\u001cR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00068"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessageBase;", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterMetadataAwareBase;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessage;", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "buffers", "", "", "schema", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterProtocolSchema;", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;Ljava/util/List;Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterProtocolSchema;)V", "getBuffers", "()Ljava/util/List;", "value", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessageChannel;", "channel", "getChannel", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessageChannel;", "setChannel", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessageChannel;)V", "content", "getContent", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessageHeader;", "header", "getHeader", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessageHeader;", "setHeader", "(Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessageHeader;)V", "getJson", "messageContent", "getMessageContent", "setMessageContent", "(Lcom/fasterxml/jackson/databind/node/ObjectNode;)V", "parentHeader", "getParentHeader", "setParentHeader", "getSchema$intellij_python_jupyter", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterProtocolSchema;", "createMetadata", "equals", "", "other", "", "getMetadata", "hashCode", "", "serialize", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/WebSocketMessage;", "jsonSerializer", "Lkotlin/Function1;", "Lcom/fasterxml/jackson/databind/JsonNode;", "", "serialize$intellij_python_jupyter", "toString", "Companion", "intellij.python.jupyter"})
public class JupyterMessageBase
extends JupyterMetadataAwareBase
implements JupyterMessage {
    @NotNull
    private final ObjectNode content;
    @NotNull
    private final ObjectNode json;
    @NotNull
    private final List<byte[]> buffers;
    @NotNull
    private final JupyterProtocolSchema schema;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected ObjectNode getContent() {
        return this.content;
    }

    @Override
    @Nullable
    public ObjectNode getMetadata() {
        JsonNode jsonNode = this.getContent().get("metadata");
        if (!(jsonNode instanceof ObjectNode)) {
            jsonNode = null;
        }
        return (ObjectNode)jsonNode;
    }

    @Override
    @NotNull
    public final ObjectNode createMetadata() {
        ObjectNode objectNode = this.getContent().putObject("metadata");
        Intrinsics.checkExpressionValueIsNotNull((Object)objectNode, (String)"content.putObject(\"metadata\")");
        return objectNode;
    }

    @Override
    @NotNull
    public JupyterMessageHeader getHeader() {
        JsonNode jsonNode = this.json.get(this.schema.getHeaderFieldName());
        if (jsonNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        }
        return new JupyterMessageHeaderBase((ObjectNode)jsonNode, new JupyterProtocolSchema.JupyterProtocolHeaderSchema(this.schema));
    }

    public void setHeader(@NotNull JupyterMessageHeader value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        this.json.set(this.schema.getHeaderFieldName(), (JsonNode)value2.getJson());
    }

    @Override
    @Nullable
    public JupyterMessageHeader getParentHeader() {
        JsonNode parentHeaderJson;
        JsonNode jsonNode = parentHeaderJson = this.json.get(this.schema.getParentHeaderFieldName());
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonNode, (String)"parentHeaderJson");
        if (!jsonNode.isEmpty()) {
            return new JupyterMessageHeaderBase((ObjectNode)parentHeaderJson, new JupyterProtocolSchema.JupyterProtocolHeaderSchema(this.schema));
        }
        return null;
    }

    public void setParentHeader(@Nullable JupyterMessageHeader value2) {
        JupyterMessageHeader jupyterMessageHeader;
        this.json.set(this.schema.getParentHeaderFieldName(), (jupyterMessageHeader = value2) != null && (jupyterMessageHeader = jupyterMessageHeader.getJson()) != null ? (JsonNode)jupyterMessageHeader : (JsonNode)JupyterJsonKt.getJackson().createObjectNode());
    }

    @Override
    @NotNull
    public ObjectNode getMessageContent() {
        JsonNode jsonNode = this.json.get(this.schema.getContentFieldName());
        if (jsonNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        }
        return (ObjectNode)jsonNode;
    }

    public void setMessageContent(@NotNull ObjectNode value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        this.json.set(this.schema.getContentFieldName(), (JsonNode)value2);
    }

    @Override
    @NotNull
    public JupyterMessageChannel getChannel() {
        String string = this.json.get(this.schema.getChannelFieldsName()).asText();
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        String string2 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
        String string3 = string2;
        boolean bl4 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
        return JupyterMessageChannel.valueOf(string5);
    }

    public void setChannel(@NotNull JupyterMessageChannel value2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value2), (String)"value");
        this.json.put("channel", value2.getValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public WebSocketMessage serialize() {
        WebSocketMessage webSocketMessage;
        void this_$iv;
        JupyterMessageBase jupyterMessageBase = this;
        ObjectMapper objectMapper = JupyterJsonKt.getJackson();
        boolean $i$f$serialize$intellij_python_jupyter = false;
        ObjectNode p1 = this_$iv.getJson();
        boolean bl = false;
        String jsonString$iv = objectMapper.writeValueAsString((Object)p1);
        if (this_$iv.getBuffers().isEmpty()) {
            webSocketMessage = new StringWebSocketMessage(jsonString$iv);
        } else {
            int n;
            Object element$iv$iv2;
            void $this$sumBy$iv$iv;
            String string = jsonString$iv;
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] jsonBytes$iv = byArray;
            int contentStart$iv = 4 * (2 + this_$iv.getBuffers().size());
            Iterable iterable = this_$iv.getBuffers();
            int n2 = contentStart$iv + jsonBytes$iv.length;
            boolean $i$f$sumBy = false;
            int sum$iv$iv = 0;
            for (Object element$iv$iv2 : $this$sumBy$iv$iv) {
                void it$iv;
                byte[] byArray2 = (byte[])element$iv$iv2;
                n = sum$iv$iv;
                boolean bl3 = false;
                int n3 = ((void)it$iv).length;
                sum$iv$iv = n + n3;
            }
            n = sum$iv$iv;
            ByteBuffer resultBuffer$iv = ByteBuffer.allocate(n2 + n);
            boolean bl4 = false;
            boolean bl5 = false;
            ByteBuffer $this$with$iv = resultBuffer$iv;
            boolean bl6 = false;
            $this$with$iv.order(ByteOrder.BIG_ENDIAN);
            $this$with$iv.putInt(this_$iv.getBuffers().size() + 1);
            element$iv$iv2 = $this$with$iv;
            boolean bl7 = false;
            boolean bl8 = false;
            Object $this$run$iv = element$iv$iv2;
            boolean bl9 = false;
            int offset$iv = contentStart$iv;
            ((ByteBuffer)$this$run$iv).putInt(offset$iv);
            offset$iv += jsonBytes$iv.length;
            for (byte[] buffer$iv : this_$iv.getBuffers()) {
                ((ByteBuffer)$this$run$iv).putInt(offset$iv);
                offset$iv += buffer$iv.length;
            }
            $this$with$iv.put(jsonBytes$iv);
            for (byte[] buffer$iv : this_$iv.getBuffers()) {
                $this$with$iv.put(buffer$iv);
            }
            $this$with$iv.rewind();
            ByteBuffer byteBuffer = resultBuffer$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"resultBuffer");
            webSocketMessage = new BytesWebSocketMessage(byteBuffer);
        }
        return webSocketMessage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final WebSocketMessage serialize$intellij_python_jupyter(@NotNull Function1<? super JsonNode, String> jsonSerializer) {
        int n;
        Object element$iv2;
        void $this$sumBy$iv;
        int $i$f$serialize$intellij_python_jupyter = 0;
        Intrinsics.checkParameterIsNotNull(jsonSerializer, (String)"jsonSerializer");
        String jsonString = (String)jsonSerializer.invoke((Object)this.getJson());
        if (this.getBuffers().isEmpty()) {
            return new StringWebSocketMessage(jsonString);
        }
        String string = jsonString;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] jsonBytes = byArray;
        int contentStart = 4 * (2 + this.getBuffers().size());
        Iterable iterable = this.getBuffers();
        int n2 = contentStart + jsonBytes.length;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv2 : $this$sumBy$iv) {
            void it;
            byte[] byArray2 = (byte[])element$iv2;
            n = sum$iv;
            boolean bl2 = false;
            int n3 = ((void)it).length;
            sum$iv = n + n3;
        }
        n = sum$iv;
        ByteBuffer resultBuffer = ByteBuffer.allocate(n2 + n);
        boolean bl3 = false;
        boolean bl4 = false;
        ByteBuffer $this$with = resultBuffer;
        boolean bl5 = false;
        $this$with.order(ByteOrder.BIG_ENDIAN);
        $this$with.putInt(this.getBuffers().size() + 1);
        element$iv2 = $this$with;
        boolean bl6 = false;
        boolean bl7 = false;
        Object $this$run = element$iv2;
        boolean bl8 = false;
        int offset = contentStart;
        ((ByteBuffer)$this$run).putInt(offset);
        offset += jsonBytes.length;
        for (byte[] buffer : this.getBuffers()) {
            ((ByteBuffer)$this$run).putInt(offset);
            offset += buffer.length;
        }
        $this$with.put(jsonBytes);
        for (byte[] buffer : this.getBuffers()) {
            $this$with.put(buffer);
        }
        $this$with.rewind();
        ByteBuffer byteBuffer = resultBuffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"resultBuffer");
        return new BytesWebSocketMessage(byteBuffer);
    }

    @NotNull
    public String toString() {
        return "JupyterMessage: " + JupyterJsonKt.getJackson().writeValueAsString((Object)this.json);
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        String string = this.getHeader().getMessageId();
        Object object2 = other;
        if (!(object2 instanceof JupyterMessage)) {
            object2 = null;
        }
        return Intrinsics.areEqual((Object)string, (object = (JupyterMessage)object2) != null && (object = object.getHeader()) != null ? object.getMessageId() : null);
    }

    public int hashCode() {
        return this.getHeader().getMessageId().hashCode();
    }

    @Override
    @NotNull
    public final ObjectNode getJson() {
        return this.json;
    }

    @Override
    @NotNull
    public List<byte[]> getBuffers() {
        return this.buffers;
    }

    @NotNull
    public final JupyterProtocolSchema getSchema$intellij_python_jupyter() {
        return this.schema;
    }

    public JupyterMessageBase(@NotNull ObjectNode json, @NotNull List<byte[]> buffers, @NotNull JupyterProtocolSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull(buffers, (String)"buffers");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        this.json = json;
        this.buffers = buffers;
        this.schema = schema;
        this.content = this.json;
        this.getOrCreateMetadata();
    }

    @JvmStatic
    @NotNull
    public static final JupyterMessage parse(@NotNull WebSocketMessage content2, @NotNull JupyterProtocolSchema schema) {
        return Companion.parse(content2, schema);
    }

    @JvmStatic
    private static final int[] readOffsets(IntBuffer intBuffer) {
        return JupyterMessageBase.Companion.readOffsets(intBuffer);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessageBase$Companion;", "", "()V", "parse", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessage;", "content", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/WebSocketMessage;", "schema", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterProtocolSchema;", "readOffsets", "", "intBuffer", "Ljava/nio/IntBuffer;", "intellij.python.jupyter"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final JupyterMessage parse(@NotNull WebSocketMessage content2, @NotNull JupyterProtocolSchema schema) {
            JupyterMessage jupyterMessage;
            Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            WebSocketMessage webSocketMessage = content2;
            if (webSocketMessage instanceof StringWebSocketMessage) {
                Object object = JupyterJsonKt.getJackson().readValue(((StringWebSocketMessage)content2).getString(), ObjectNode.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"jackson.readValue(conten\u2026, ObjectNode::class.java)");
                jupyterMessage = new JupyterMessageBase((ObjectNode)object, CollectionsKt.emptyList(), schema);
            } else if (webSocketMessage instanceof BytesWebSocketMessage) {
                ByteBuffer byteBuffer = ((BytesWebSocketMessage)content2).getBytes();
                boolean bl = false;
                boolean bl2 = false;
                ByteBuffer $this$with = byteBuffer;
                boolean bl3 = false;
                boolean bl4 = Intrinsics.areEqual((Object)$this$with.order(), (Object)ByteOrder.BIG_ENDIAN);
                boolean bl5 = false;
                boolean bl6 = false;
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl7 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                IntBuffer intBuffer = $this$with.asIntBuffer();
                Intrinsics.checkExpressionValueIsNotNull((Object)intBuffer, (String)"asIntBuffer()");
                int[] offsets = Companion.readOffsets(intBuffer);
                offsets[offsets.length - 1] = ((BytesWebSocketMessage)content2).getBytes().limit();
                List buffers = SequencesKt.toList((Sequence)SequencesKt.zipWithNext((Sequence)ArraysKt.asSequence((int[])offsets), (Function2)((Function2)new Function2<Integer, Integer, ByteBuffer>(content2, schema){
                    final /* synthetic */ WebSocketMessage $content$inlined;
                    final /* synthetic */ JupyterProtocolSchema $schema$inlined;
                    {
                        this.$content$inlined = webSocketMessage;
                        this.$schema$inlined = jupyterProtocolSchema;
                        super(2);
                    }

                    public final ByteBuffer invoke(int start, int end) {
                        ((BytesWebSocketMessage)this.$content$inlined).getBytes().limit(end);
                        ((BytesWebSocketMessage)this.$content$inlined).getBytes().position(start);
                        return ((BytesWebSocketMessage)this.$content$inlined).getBytes().slice();
                    }
                })));
                ObjectMapper objectMapper = JupyterJsonKt.getJackson();
                Object e = buffers.get(0);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"buffers[0]");
                Object object = objectMapper.readValue(IoKt.toByteArray$default((ByteBuffer)((ByteBuffer)e), (boolean)false, (int)1, null), ObjectNode.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"jackson.readValue(buffer\u2026, ObjectNode::class.java)");
                jupyterMessage = new JupyterMessageBase((ObjectNode)object, SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)buffers), (int)1), (Function1)parse.1.1.INSTANCE)), schema);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return jupyterMessage;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        private final int[] readOffsets(IntBuffer intBuffer) {
            int[] offsets = new int[intBuffer.get() + 1];
            int n = 0;
            int n2 = offsets.length - 1;
            while (n < n2) {
                void i;
                offsets[i] = intBuffer.get();
                ++i;
            }
            return offsets;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

