/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.HelperPackage;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonProcessRunner;
import com.jetbrains.rest.run.RestRunConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RestCommandLineState
extends PythonCommandLineState {
    protected final RestRunConfiguration myConfiguration;

    public RestCommandLineState(RestRunConfiguration configuration, ExecutionEnvironment env) {
        super(configuration, env);
        this.myConfiguration = configuration;
    }

    @Override
    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
        ParametersList parametersList = commandLine.getParametersList();
        ParamsGroup exeOptions = parametersList.getParamsGroup("Exe Options");
        assert (exeOptions != null);
        exeOptions.addParametersString(this.myConfiguration.getInterpreterOptions());
        ParamsGroup scriptParameters = parametersList.getParamsGroup("Script");
        assert (scriptParameters != null);
        this.getRunner().addToGroup(scriptParameters, commandLine);
        String key = this.getKey();
        if (key != null) {
            scriptParameters.addParameter(key);
        }
        scriptParameters.addParameter(this.getTask());
        String params = this.myConfiguration.getParams();
        if (params != null) {
            scriptParameters.addParametersString(params);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfiguration.getInputFile())) {
            scriptParameters.addParameter(this.myConfiguration.getInputFile());
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfiguration.getOutputFile())) {
            scriptParameters.addParameter(this.myConfiguration.getOutputFile());
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfiguration.getWorkingDirectory())) {
            commandLine.setWorkDirectory(this.myConfiguration.getWorkingDirectory());
        }
    }

    @Override
    protected ProcessHandler doCreateProcess(GeneralCommandLine commandLine) throws ExecutionException {
        final Runnable afterTask = this.getAfterTask();
        ProcessHandler processHandler2 = PythonProcessRunner.createProcess(commandLine, false);
        if (afterTask != null) {
            processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event2) {
                    if (event2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeLater(afterTask);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/rest/run/RestCommandLineState$1", "processTerminated"));
                }
            });
        }
        return processHandler2;
    }

    @Nullable
    protected Runnable getAfterTask() {
        return null;
    }

    @Nullable
    protected VirtualFile findOutput() {
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfiguration.getOutputFile())) {
            VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myConfiguration.getOutputFile());
            if (virtualFile2 == null) {
                virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myConfiguration.getWorkingDirectory() + this.myConfiguration.getOutputFile());
            }
            return virtualFile2;
        }
        return null;
    }

    protected abstract HelperPackage getRunner();

    protected abstract String getTask();

    @Nullable
    protected abstract String getKey();
}

