/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.tox;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.testing.tox.PyToxConfiguration;
import com.jetbrains.python.testing.tox.PyToxConfigurationFactory;
import com.jetbrains.python.testing.tox.PyToxTestLocator;
import org.jetbrains.annotations.NotNull;

public final class PyToxConfigurationProducer
extends LazyRunConfigurationProducer<PyToxConfiguration> {
    private static final String TOX_FILE_NAME = "tox.ini";

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = PyToxConfigurationFactory.INSTANCE;
        if (configurationFactory == null) {
            PyToxConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    public boolean isConfigurationFromContext(@NotNull PyToxConfiguration configuration, @NotNull ConfigurationContext context) {
        Location location;
        if (configuration == null) {
            PyToxConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PyToxConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        VirtualFile virtualFile2 = location.getVirtualFile();
        if (virtualFile2 == null) {
            return false;
        }
        String currentPath = virtualFile2.getParent().getCanonicalPath();
        String directoryPath2 = configuration.getWorkingDirectory();
        if (currentPath != null && directoryPath2 != null && !directoryPath2.equals(currentPath)) {
            return false;
        }
        return TOX_FILE_NAME.equals(virtualFile2.getName());
    }

    protected boolean setupConfigurationFromContext(@NotNull PyToxConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiFile file2;
        if (configuration == null) {
            PyToxConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PyToxConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (sourceElement == null) {
            PyToxConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((file2 = ((PsiElement)sourceElement.get()).getContainingFile()) == null) {
            return false;
        }
        String envName = PyToxTestLocator.getEnvNameFromElement(file2);
        if (envName != null) {
            configuration.setRunOnlyEnvs(envName);
            configuration.setName(String.format("tox: run on %s", envName));
            return true;
        }
        PsiDirectory directory2 = file2.getContainingDirectory();
        if (directory2 == null) {
            return false;
        }
        configuration.setWorkingDirectory(directory2.getVirtualFile().getCanonicalPath());
        if (TOX_FILE_NAME.equals(file2.getName())) {
            configuration.setName("tox");
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/tox/PyToxConfigurationProducer";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/tox/PyToxConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

