/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.skeletons;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.skeletons.LineWiseProcessOutputListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySkeletonGenerator {
    protected static final Logger LOG = Logger.getInstance(PySkeletonGenerator.class);
    protected static final String GENERATOR3 = "generator3/__main__.py";
    @NonNls
    public static final String STATE_MARKER_FILE = ".state.json";
    @NonNls
    public static final String BLACKLIST_FILE_NAME = ".blacklist";
    private static final Gson ourGson = new GsonBuilder().create();
    protected final Sdk mySdk;
    @Nullable
    private final String myCurrentFolder;
    private final String mySkeletonsPath;

    public PySkeletonGenerator(String skeletonPath, @NotNull Sdk pySdk, @Nullable String currentFolder) {
        if (pySdk == null) {
            PySkeletonGenerator.$$$reportNull$$$0(0);
        }
        this.mySkeletonsPath = skeletonPath;
        this.mySdk = pySdk;
        this.myCurrentFolder = currentFolder;
    }

    @NotNull
    public final Builder commandBuilder() {
        Builder builder = new Builder();
        if (this.myCurrentFolder != null) {
            builder.workingDir(this.myCurrentFolder);
        }
        Builder builder2 = builder;
        if (builder2 == null) {
            PySkeletonGenerator.$$$reportNull$$$0(1);
        }
        return builder2;
    }

    @NotNull
    protected List<GenerationResult> runGeneration(@NotNull Builder builder, final @Nullable ProgressIndicator indicator) throws InvalidSdkException, ExecutionException {
        if (builder == null) {
            PySkeletonGenerator.$$$reportNull$$$0(2);
        }
        final ArrayList<GenerationResult> results = new ArrayList<GenerationResult>();
        LineWiseProcessOutputListener listener2 = new LineWiseProcessOutputListener(){

            @Override
            public void onStdoutLine(@NotNull String line2) {
                String trimmed;
                if (line2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                if ((trimmed = line2.trim()).startsWith("{")) {
                    JsonObject controlMessage;
                    try {
                        controlMessage = (JsonObject)ourGson.fromJson(trimmed, JsonObject.class);
                    }
                    catch (JsonSyntaxException e) {
                        LOG.warn("Malformed control message: " + line2);
                        return;
                    }
                    String msgType = controlMessage.get("type").getAsString();
                    if (msgType.equals("progress") && indicator != null) {
                        JsonElement fraction;
                        JsonElement text2 = controlMessage.get("text");
                        if (text2 != null) {
                            if (controlMessage.get("minor").getAsBoolean()) {
                                indicator.setText2(text2.getAsString());
                            } else {
                                indicator.setText(text2.getAsString());
                            }
                        }
                        if ((fraction = controlMessage.get("fraction")) != null) {
                            indicator.setIndeterminate(false);
                            indicator.setFraction(fraction.getAsDouble());
                        }
                    } else if (msgType.equals("log")) {
                        String level = controlMessage.get("level").getAsString();
                        String message = controlMessage.get("message").getAsString();
                        if (level.equals("info")) {
                            Run.LOG.info(message);
                        } else if (level.equals("debug")) {
                            Run.LOG.debug(message);
                        } else if (level.equals("trace")) {
                            Run.LOG.trace(message);
                        }
                    } else if (msgType.equals("generation_result")) {
                        results.add(ourGson.fromJson(trimmed, GenerationResult.class));
                    }
                }
            }

            @Override
            public void onStderrLine(@NotNull String line2) {
                if (line2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                Run.LOG.info(StringUtil.trimTrailing((String)line2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "line";
                objectArray2[1] = "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onStdoutLine";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onStderrLine";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ProcessOutput output = this.runProcessWithLineOutputListener(builder.getWorkingDir(), builder.getCommandLine(), builder.getEnvironment(), builder.myStdin, builder.getTimeout(1200000), listener2);
        if (output.getExitCode() != 0) {
            throw new InvalidSdkException(this.formatGeneratorFailureMessage(output));
        }
        ArrayList<GenerationResult> arrayList = results;
        if (arrayList == null) {
            PySkeletonGenerator.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    protected ProcessOutput runProcess(@NotNull Builder builder, boolean ensureSuccess) throws InvalidSdkException {
        if (builder == null) {
            PySkeletonGenerator.$$$reportNull$$$0(4);
        }
        ProcessOutput output = this.getProcessOutput(builder.getWorkingDir(), ArrayUtil.toStringArray(builder.getCommandLine()), builder.getStdin(), builder.getEnvironment(), builder.getTimeout(600000));
        if (ensureSuccess && output.getExitCode() != 0) {
            throw new InvalidSdkException(this.formatGeneratorFailureMessage(output));
        }
        ProcessOutput processOutput = output;
        if (processOutput == null) {
            PySkeletonGenerator.$$$reportNull$$$0(5);
        }
        return processOutput;
    }

    public void finishSkeletonsGeneration() {
    }

    public boolean exists(@NotNull String name) {
        if (name == null) {
            PySkeletonGenerator.$$$reportNull$$$0(6);
        }
        return new File(name).exists();
    }

    @NotNull
    protected ProcessOutput runProcessWithLineOutputListener(@NotNull String homePath, @NotNull List<String> cmd, @NotNull Map<String, String> env, @Nullable String stdin, int timeout, @NotNull LineWiseProcessOutputListener listener2) throws ExecutionException, InvalidSdkException {
        if (homePath == null) {
            PySkeletonGenerator.$$$reportNull$$$0(7);
        }
        if (cmd == null) {
            PySkeletonGenerator.$$$reportNull$$$0(8);
        }
        if (env == null) {
            PySkeletonGenerator.$$$reportNull$$$0(9);
        }
        if (listener2 == null) {
            PySkeletonGenerator.$$$reportNull$$$0(10);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(cmd).withWorkDirectory(homePath).withEnvironment(env);
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
        if (stdin != null) {
            PySkeletonGenerator.sendLineToProcessInput(handler, stdin);
        }
        handler.addProcessListener((ProcessListener)new LineWiseProcessOutputListener.Adapter(listener2));
        ProcessOutput processOutput = handler.runProcess(timeout);
        if (processOutput == null) {
            PySkeletonGenerator.$$$reportNull$$$0(11);
        }
        return processOutput;
    }

    public String getSkeletonsPath() {
        return this.mySkeletonsPath;
    }

    public void prepare() {
    }

    protected ProcessOutput getProcessOutput(String homePath, String @NotNull [] commandLine, @Nullable String stdin, Map<String, String> extraEnv, int timeout) throws InvalidSdkException {
        if (commandLine == null) {
            PySkeletonGenerator.$$$reportNull$$$0(12);
        }
        byte[] bytes = stdin != null ? stdin.getBytes(StandardCharsets.UTF_8) : null;
        return PySdkUtil.getProcessOutput(homePath, commandLine, extraEnv, timeout, bytes, true);
    }

    @NotNull
    private String formatGeneratorFailureMessage(@NotNull ProcessOutput process2) {
        if (process2 == null) {
            PySkeletonGenerator.$$$reportNull$$$0(13);
        }
        StringBuilder sb = new StringBuilder("failed to run ").append(GENERATOR3).append(" for ").append(this.mySdk.getHomePath());
        if (process2.isTimeout()) {
            sb.append(": timed out.");
        } else {
            sb.append(", exit code ").append(process2.getExitCode()).append(", stderr: \n-----\n");
            for (String line2 : process2.getStderrLines()) {
                sb.append(line2).append("\n");
            }
            sb.append("-----");
        }
        String string = sb.toString();
        if (string == null) {
            PySkeletonGenerator.$$$reportNull$$$0(14);
        }
        return string;
    }

    public boolean deleteOrLog(@NotNull File item) {
        boolean deleted;
        if (item == null) {
            PySkeletonGenerator.$$$reportNull$$$0(15);
        }
        if (!(deleted = item.delete())) {
            LOG.warn("Failed to delete skeleton file " + item.getAbsolutePath());
        }
        return deleted;
    }

    public void refreshGeneratedSkeletons() {
        VirtualFile skeletonsVFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.getSkeletonsPath());
        assert (skeletonsVFile != null);
        skeletonsVFile.refresh(false, true);
    }

    protected static void sendLineToProcessInput(@NotNull BaseProcessHandler<?> handler, @NotNull String line2) throws ExecutionException {
        OutputStream input;
        if (handler == null) {
            PySkeletonGenerator.$$$reportNull$$$0(16);
        }
        if (line2 == null) {
            PySkeletonGenerator.$$$reportNull$$$0(17);
        }
        if ((input = handler.getProcessInput()) != null) {
            try {
                PySkeletonGenerator.sendLineToStream(input, line2);
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        } else {
            LOG.warn("Process " + handler.getCommandLine() + " can't accept any input");
        }
    }

    protected static void sendLineToStream(@NotNull OutputStream input, @NotNull String line2) throws IOException {
        if (input == null) {
            PySkeletonGenerator.$$$reportNull$$$0(18);
        }
        if (line2 == null) {
            PySkeletonGenerator.$$$reportNull$$$0(19);
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(input, StandardCharsets.UTF_8));
        writer.write(line2);
        writer.write(10);
        writer.flush();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pySdk";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "commandBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runGeneration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcess";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithLineOutputListener";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "formatGeneratorFailureMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runGeneration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithLineOutputListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "formatGeneratorFailureMessage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "deleteOrLog";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sendLineToProcessInput";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sendLineToStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GenerationResult {
        @SerializedName(value="module_name")
        private String myModuleName;
        @SerializedName(value="module_origin")
        private String myModuleOrigin;
        @SerializedName(value="generation_status")
        private GenerationStatus myGenerationStatus;

        @NotNull
        public String getModuleName() {
            String string = this.myModuleName;
            if (string == null) {
                GenerationResult.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getModuleOrigin() {
            String string = this.myModuleOrigin;
            if (string == null) {
                GenerationResult.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public GenerationStatus getGenerationStatus() {
            GenerationStatus generationStatus = this.myGenerationStatus;
            if (generationStatus == null) {
                GenerationResult.$$$reportNull$$$0(2);
            }
            return generationStatus;
        }

        public boolean isBuiltin() {
            return this.myModuleOrigin.equals("(built-in)");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator$GenerationResult";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleOrigin";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGenerationStatus";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static enum GenerationStatus {
        UP_TO_DATE,
        GENERATED,
        COPIED,
        FAILED;

    }

    public final class Builder {
        private final List<String> myExtraSysPath = new ArrayList<String>();
        private final List<String> myAssemblyRefs = new ArrayList<String>();
        private final List<String> myExtraArgs = new ArrayList<String>();
        private String myWorkingDir;
        private String myTargetModuleName;
        private String myTargetModulePath;
        private boolean myPrebuilt = false;
        private int myTimeout;
        private String myStdin;

        private Builder() {
        }

        @NotNull
        public Builder extraSysPath(@NotNull List<String> roots) {
            if (roots == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myExtraSysPath.addAll(roots);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder assemblyRefs(@NotNull List<String> assemblyRefs) {
            if (assemblyRefs == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myAssemblyRefs.addAll(assemblyRefs);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder extraArgs(@NotNull List<String> args2) {
            if (args2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myExtraArgs.addAll(args2);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder extraArgs(String ... args2) {
            if (args2 == null) {
                Builder.$$$reportNull$$$0(6);
            }
            Builder builder = this.extraArgs(Arrays.asList(args2));
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public Builder workingDir(@NotNull String path) {
            if (path == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myWorkingDir = path;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder;
        }

        @NotNull
        public Builder inPrebuildingMode() {
            this.myPrebuilt = true;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder;
        }

        @NotNull
        public Builder targetModule(@NotNull String name, @Nullable String path) {
            if (name == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.myTargetModuleName = name;
            this.myTargetModulePath = path;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder;
        }

        @NotNull
        public Builder timeout(int timeout) {
            this.myTimeout = timeout;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder;
        }

        @NotNull
        public Builder stdin(@NotNull String content2) {
            if (content2 == null) {
                Builder.$$$reportNull$$$0(14);
            }
            this.myStdin = content2;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(15);
            }
            return builder;
        }

        @Nullable
        public String getStdin() {
            return this.myStdin;
        }

        @NotNull
        public List<String> getCommandLine() {
            ArrayList<String> commandLine = new ArrayList<String>();
            commandLine.add(PySkeletonGenerator.this.mySdk.getHomePath());
            commandLine.add(PythonHelpersLocator.getHelperPath(PySkeletonGenerator.GENERATOR3));
            commandLine.add("-d");
            commandLine.add(PySkeletonGenerator.this.mySkeletonsPath);
            if (!ContainerUtil.isEmpty(this.myAssemblyRefs)) {
                commandLine.add("-c");
                commandLine.add(StringUtil.join(this.myAssemblyRefs, (String)";"));
            }
            if (!ContainerUtil.isEmpty(this.myExtraSysPath)) {
                commandLine.add("-s");
                commandLine.add(StringUtil.join(this.myExtraSysPath, (String)File.pathSeparator));
            }
            commandLine.addAll(this.myExtraArgs);
            if (StringUtil.isNotEmpty((String)this.myTargetModuleName)) {
                commandLine.add(this.myTargetModuleName);
                if (StringUtil.isNotEmpty((String)this.myTargetModulePath)) {
                    commandLine.add(this.myTargetModulePath);
                }
            }
            ArrayList<String> arrayList = commandLine;
            if (arrayList == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return arrayList;
        }

        @NotNull
        public Map<String, String> getEnvironment() {
            String flavorPathParam;
            Map<String, String> env = new HashMap<String, String>();
            PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(PySkeletonGenerator.this.mySdk);
            String string = flavorPathParam = flavor != null ? flavor.envPathParam() : null;
            if (this.myWorkingDir != null && flavorPathParam != null) {
                env = PySdkUtil.mergeEnvVariables(env, (Map<String, String>)ImmutableMap.of((Object)flavorPathParam, (Object)this.myWorkingDir));
            }
            env = PySdkUtil.mergeEnvVariables(env, PySdkUtil.activateVirtualEnv(PySkeletonGenerator.this.mySdk));
            PythonEnvUtil.setPythonDontWriteBytecode(env);
            if (this.myPrebuilt) {
                env.put("IS_PREGENERATED_SKELETONS", "1");
            }
            Map<String, String> map2 = env;
            if (map2 == null) {
                Builder.$$$reportNull$$$0(17);
            }
            return map2;
        }

        @NotNull
        public String getWorkingDir() throws InvalidSdkException {
            if (this.myWorkingDir != null) {
                String string = this.myWorkingDir;
                if (string == null) {
                    Builder.$$$reportNull$$$0(18);
                }
                return string;
            }
            String binaryPath = PySkeletonGenerator.this.mySdk.getHomePath();
            if (binaryPath == null) {
                throw new InvalidSdkException("Broken home path for " + PySkeletonGenerator.this.mySdk.getName());
            }
            String string = new File(binaryPath).getParent();
            if (string == null) {
                Builder.$$$reportNull$$$0(19);
            }
            return string;
        }

        public int getTimeout(int defaultTimeout) {
            return this.myTimeout > 0 ? this.myTimeout : defaultTimeout;
        }

        @NotNull
        public ProcessOutput runProcess(boolean ensureSuccess) throws InvalidSdkException {
            ProcessOutput processOutput = PySkeletonGenerator.this.runProcess(this, ensureSuccess);
            if (processOutput == null) {
                Builder.$$$reportNull$$$0(20);
            }
            return processOutput;
        }

        @NotNull
        public List<GenerationResult> runGeneration(@Nullable ProgressIndicator indicator) throws InvalidSdkException, ExecutionException {
            List<GenerationResult> list = PySkeletonGenerator.this.runGeneration(this, indicator);
            if (list == null) {
                Builder.$$$reportNull$$$0(21);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator$Builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assemblyRefs";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "args";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extraSysPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "assemblyRefs";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extraArgs";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "workingDir";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "inPrebuildingMode";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "targetModule";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "timeout";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stdin";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandLine";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnvironment";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWorkingDir";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runProcess";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runGeneration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "extraSysPath";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "assemblyRefs";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "extraArgs";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "workingDir";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "targetModule";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "stdin";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Run {
        static final Logger LOG = Logger.getInstance(Run.class);

        private Run() {
        }
    }
}

