/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.google.common.collect.Lists;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.AbstractRunConfiguration;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PyCommonOptionsFormData;
import com.jetbrains.python.run.PythonExtendedConfigurationEditor;
import com.jetbrains.python.run.PythonRunConfigurationExtensionsManager;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPythonRunConfiguration<T extends AbstractPythonRunConfiguration<T>>
extends AbstractRunConfiguration
implements AbstractPythonRunConfigurationParams,
CommandLinePatcher,
RunProfileWithCompileBeforeLaunchOption {
    private String myInterpreterOptions;
    private String myWorkingDirectory;
    private String mySdkHome;
    private boolean myUseModuleSdk;
    private boolean myAddContentRoots;
    private boolean myAddSourceRoots;
    protected PathMappingSettings myMappingSettings;
    protected boolean mySkipModuleSerialization;

    public AbstractPythonRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory) {
        if (project == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(1);
        }
        super(project, factory);
        this.myInterpreterOptions = "";
        this.myWorkingDirectory = "";
        this.mySdkHome = "";
        this.myAddContentRoots = true;
        this.myAddSourceRoots = true;
        this.getConfigurationModule().setModuleToAnyFirstIfNotSpecified();
    }

    public List<Module> getValidModules() {
        return AbstractPythonRunConfiguration.getValidModules(this.getProject());
    }

    @Override
    public PathMappingSettings getMappingSettings() {
        return this.myMappingSettings;
    }

    @Override
    public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
        this.myMappingSettings = mappingSettings;
    }

    public boolean isIdTestBased() {
        return false;
    }

    public static List<Module> getValidModules(Project project) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        ArrayList result = Lists.newArrayList();
        for (Module module : modules) {
            if (PythonSdkUtil.findPythonSdk(module) == null) continue;
            result.add(module);
        }
        return result;
    }

    public PyCommonOptionsFormData getCommonOptionsFormData() {
        return new PyCommonOptionsFormData(){

            @Override
            public Project getProject() {
                return AbstractPythonRunConfiguration.this.getProject();
            }

            @Override
            public List<Module> getValidModules() {
                return AbstractPythonRunConfiguration.this.getValidModules();
            }

            @Override
            public boolean showConfigureInterpretersLink() {
                return false;
            }
        };
    }

    @NotNull
    public final SettingsEditor<T> getConfigurationEditor() {
        PythonExtendedConfigurationEditor<T> runConfigurationEditor = PythonExtendedConfigurationEditor.create(this.createConfigurationEditor());
        SettingsEditorGroup group2 = new SettingsEditorGroup();
        group2.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), runConfigurationEditor);
        PythonRunConfigurationExtensionsManager.Companion.getInstance().appendEditors((RunConfigurationBase)this, group2);
        group2.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group2;
        if (settingsEditorGroup == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(2);
        }
        return settingsEditorGroup;
    }

    protected abstract SettingsEditor<T> createConfigurationEditor();

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        this.checkSdk();
        this.checkExtensions();
    }

    private void checkExtensions() throws RuntimeConfigurationException {
        try {
            PythonRunConfigurationExtensionsManager.Companion.getInstance().validateConfiguration((RunConfigurationBase)this, false);
        }
        catch (RuntimeConfigurationException e) {
            throw e;
        }
        catch (Exception ee) {
            throw new RuntimeConfigurationException(ee.getMessage());
        }
    }

    private void checkSdk() throws RuntimeConfigurationError {
        if (PlatformUtils.isPyCharm()) {
            String path = this.getInterpreterPath();
            if (StringUtil.isEmptyOrSpaces((String)path)) {
                throw new RuntimeConfigurationError("Please select a valid Python interpreter");
            }
        } else if (!this.myUseModuleSdk) {
            if (StringUtil.isEmptyOrSpaces((String)this.getSdkHome())) {
                Sdk projectSdk = ProjectRootManager.getInstance((Project)this.getProject()).getProjectSdk();
                if (projectSdk == null || !(projectSdk.getSdkType() instanceof PythonSdkType)) {
                    throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_sdk", new Object[0]));
                }
            } else if (!PythonSdkType.getInstance().isValidSdkHome(this.getSdkHome())) {
                throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_valid_sdk", new Object[0]));
            }
        } else {
            Sdk sdk = PythonSdkUtil.findPythonSdk(this.getModule());
            if (sdk == null) {
                throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_module_sdk", new Object[0]));
            }
        }
    }

    @Override
    public String getSdkHome() {
        Sdk projectJdk;
        String sdkHome = this.mySdkHome;
        if (StringUtil.isEmptyOrSpaces((String)this.mySdkHome) && (projectJdk = PythonSdkUtil.findPythonSdk(this.getModule())) != null) {
            sdkHome = projectJdk.getHomePath();
        }
        return sdkHome;
    }

    @Nullable
    public String getInterpreterPath() {
        String sdkHome;
        if (this.myUseModuleSdk) {
            Sdk sdk = PythonSdkUtil.findPythonSdk(this.getModule());
            if (sdk == null) {
                return null;
            }
            sdkHome = sdk.getHomePath();
        } else {
            sdkHome = this.getSdkHome();
        }
        return sdkHome;
    }

    @Nullable
    public Sdk getSdk() {
        if (this.myUseModuleSdk) {
            return PythonSdkUtil.findPythonSdk(this.getModule());
        }
        return PythonSdkUtil.findSdkByPath(this.getSdkHome());
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(3);
        }
        super.readExternal(element);
        this.myInterpreterOptions = JDOMExternalizerUtil.readField((Element)element, (String)"INTERPRETER_OPTIONS");
        this.readEnvs(element);
        this.mySdkHome = JDOMExternalizerUtil.readField((Element)element, (String)"SDK_HOME");
        this.myWorkingDirectory = JDOMExternalizerUtil.readField((Element)element, (String)"WORKING_DIRECTORY");
        this.myUseModuleSdk = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"IS_MODULE_SDK"));
        String addContentRoots = JDOMExternalizerUtil.readField((Element)element, (String)"ADD_CONTENT_ROOTS");
        this.myAddContentRoots = addContentRoots == null || Boolean.parseBoolean(addContentRoots);
        String addSourceRoots = JDOMExternalizerUtil.readField((Element)element, (String)"ADD_SOURCE_ROOTS");
        boolean bl = this.myAddSourceRoots = addSourceRoots == null || Boolean.parseBoolean(addSourceRoots);
        if (!this.mySkipModuleSerialization) {
            this.getConfigurationModule().readExternal(element);
        }
        this.setMappingSettings(PathMappingSettings.readExternal((Element)element));
        PythonRunConfigurationExtensionsManager.Companion.getInstance().readExternal((RunConfigurationBase)this, element);
    }

    protected void readEnvs(Element element) {
        String parentEnvs = JDOMExternalizerUtil.readField((Element)element, (String)"PARENT_ENVS");
        if (parentEnvs != null) {
            this.setPassParentEnvs(Boolean.parseBoolean(parentEnvs));
        }
        EnvironmentVariablesComponent.readExternal((Element)element, (Map)this.getEnvs());
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(4);
        }
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)"INTERPRETER_OPTIONS", (String)this.myInterpreterOptions);
        this.writeEnvs(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)"SDK_HOME", (String)this.mySdkHome);
        JDOMExternalizerUtil.writeField((Element)element, (String)"WORKING_DIRECTORY", (String)this.myWorkingDirectory);
        JDOMExternalizerUtil.writeField((Element)element, (String)"IS_MODULE_SDK", (String)Boolean.toString(this.myUseModuleSdk));
        JDOMExternalizerUtil.writeField((Element)element, (String)"ADD_CONTENT_ROOTS", (String)Boolean.toString(this.myAddContentRoots));
        JDOMExternalizerUtil.writeField((Element)element, (String)"ADD_SOURCE_ROOTS", (String)Boolean.toString(this.myAddSourceRoots));
        if (!this.mySkipModuleSerialization) {
            this.getConfigurationModule().writeExternal(element);
        }
        PythonRunConfigurationExtensionsManager.Companion.getInstance().writeExternal((RunConfigurationBase)this, element);
        PathMappingSettings.writeExternal((Element)element, (PathMappingSettings)this.getMappingSettings());
    }

    protected void writeEnvs(Element element) {
        JDOMExternalizerUtil.writeField((Element)element, (String)"PARENT_ENVS", (String)Boolean.toString(this.isPassParentEnvs()));
        EnvironmentVariablesComponent.writeExternal((Element)element, (Map)this.getEnvs());
    }

    @Override
    public String getInterpreterOptions() {
        return this.myInterpreterOptions;
    }

    @Override
    public void setInterpreterOptions(String interpreterOptions) {
        this.myInterpreterOptions = interpreterOptions;
    }

    @Override
    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    @Override
    public void setWorkingDirectory(String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    @Override
    public void setSdkHome(String sdkHome) {
        this.mySdkHome = sdkHome;
    }

    @Override
    @Transient
    @Nullable
    public Module getModule() {
        return this.getConfigurationModule().getModule();
    }

    @Override
    public boolean isUseModuleSdk() {
        return this.myUseModuleSdk;
    }

    @Override
    public void setUseModuleSdk(boolean useModuleSdk) {
        this.myUseModuleSdk = useModuleSdk;
    }

    @Override
    public boolean shouldAddContentRoots() {
        return this.myAddContentRoots;
    }

    @Override
    public boolean shouldAddSourceRoots() {
        return this.myAddSourceRoots;
    }

    @Override
    public void setAddSourceRoots(boolean flag) {
        this.myAddSourceRoots = flag;
    }

    @Override
    public void setAddContentRoots(boolean flag) {
        this.myAddContentRoots = flag;
    }

    public static void copyParams(AbstractPythonRunConfigurationParams source2, AbstractPythonRunConfigurationParams target) {
        target.setEnvs(new LinkedHashMap<String, String>(source2.getEnvs()));
        target.setInterpreterOptions(source2.getInterpreterOptions());
        target.setPassParentEnvs(source2.isPassParentEnvs());
        target.setSdkHome(source2.getSdkHome());
        target.setWorkingDirectory(source2.getWorkingDirectory());
        target.setModule(source2.getModule());
        target.setUseModuleSdk(source2.isUseModuleSdk());
        target.setMappingSettings(source2.getMappingSettings());
        target.setAddContentRoots(source2.shouldAddContentRoots());
        target.setAddSourceRoots(source2.shouldAddSourceRoots());
    }

    @Override
    public void patchCommandLine(GeneralCommandLine commandLine) {
        String interpreterPath = this.getInterpreterPath();
        Sdk sdk = this.getSdk();
        if (sdk != null && interpreterPath != null) {
            this.patchCommandLineFirst(commandLine, interpreterPath);
            this.patchCommandLineForVirtualenv(commandLine, sdk);
            this.patchCommandLineForBuildout(commandLine, interpreterPath);
            this.patchCommandLineLast(commandLine, interpreterPath);
        }
    }

    protected void patchCommandLineFirst(GeneralCommandLine commandLine, String sdkHome) {
    }

    protected void patchCommandLineLast(GeneralCommandLine commandLine, String sdkHome) {
    }

    protected void patchCommandLineForBuildout(GeneralCommandLine commandLine, String sdkHome) {
    }

    protected void patchCommandLineForVirtualenv(@NotNull GeneralCommandLine commandLine, @NotNull Sdk sdk) {
        if (commandLine == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(5);
        }
        if (sdk == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(6);
        }
        PythonSdkType.patchCommandLineForVirtualenv(commandLine, sdk);
    }

    protected void setUnbufferedEnv() {
        Map envs = this.getEnvs();
        PythonEnvUtil.setPythonUnbuffered(envs);
    }

    public boolean isExcludeCompileBeforeLaunchOption() {
        Module module = this.getModule();
        return module == null || ModuleType.get((Module)module) instanceof PythonModuleTypeBase;
    }

    public boolean canRunWithCoverage() {
        return true;
    }

    @NotNull
    public String getWorkingDirectorySafe() {
        String result;
        String string = result = StringUtil.isEmpty((String)this.myWorkingDirectory) ? this.getProject().getBasePath() : this.myWorkingDirectory;
        if (result != null) {
            String string2 = result;
            if (string2 == null) {
                AbstractPythonRunConfiguration.$$$reportNull$$$0(7);
            }
            return string2;
        }
        String firstModuleRoot = this.getFirstModuleRoot();
        if (firstModuleRoot != null) {
            String string3 = firstModuleRoot;
            if (string3 == null) {
                AbstractPythonRunConfiguration.$$$reportNull$$$0(8);
            }
            return string3;
        }
        String string4 = new File(".").getAbsolutePath();
        if (string4 == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(9);
        }
        return string4;
    }

    @Nullable
    private String getFirstModuleRoot() {
        Module module = this.getModule();
        if (module == null) {
            return null;
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        return roots.length > 0 ? roots[0].getPath() : null;
    }

    @Override
    public String getModuleName() {
        Module module = this.getModule();
        return module != null ? module.getName() : null;
    }

    public boolean isBuildBeforeLaunchAddedByDefault() {
        return false;
    }

    public void addTestSpecsAsParameters(@NotNull ParamsGroup paramsGroup, @NotNull List<String> testSpecs) {
        if (paramsGroup == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(10);
        }
        if (testSpecs == null) {
            AbstractPythonRunConfiguration.$$$reportNull$$$0(11);
        }
        paramsGroup.addParameters(testSpecs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/AbstractPythonRunConfiguration";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramsGroup";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testSpecs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/AbstractPythonRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectorySafe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLineForVirtualenv";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTestSpecsAsParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

